/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClient;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse;

public class ListTranscriptionJobsPublisher
implements SdkPublisher<ListTranscriptionJobsResponse> {
    private final TranscribeAsyncClient client;
    private final ListTranscriptionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTranscriptionJobsPublisher(TranscribeAsyncClient client, ListTranscriptionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTranscriptionJobsPublisher(TranscribeAsyncClient client, ListTranscriptionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTranscriptionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTranscriptionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTranscriptionJobsResponseFetcher
    implements AsyncPageFetcher<ListTranscriptionJobsResponse> {
        private ListTranscriptionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTranscriptionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTranscriptionJobsResponse> nextPage(ListTranscriptionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTranscriptionJobsPublisher.this.client.listTranscriptionJobs(ListTranscriptionJobsPublisher.this.firstRequest);
            }
            return ListTranscriptionJobsPublisher.this.client.listTranscriptionJobs((ListTranscriptionJobsRequest)((Object)ListTranscriptionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

