/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.tnb.TnbAsyncClient;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackageInfo;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesResponse;

public class ListSolNetworkPackagesPublisher
implements SdkPublisher<ListSolNetworkPackagesResponse> {
    private final TnbAsyncClient client;
    private final ListSolNetworkPackagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSolNetworkPackagesPublisher(TnbAsyncClient client, ListSolNetworkPackagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSolNetworkPackagesPublisher(TnbAsyncClient client, ListSolNetworkPackagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSolNetworkPackagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSolNetworkPackagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListSolNetworkPackageInfo> networkPackages() {
        Function<ListSolNetworkPackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkPackages() != null) {
                return response.networkPackages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSolNetworkPackagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSolNetworkPackagesResponseFetcher
    implements AsyncPageFetcher<ListSolNetworkPackagesResponse> {
        private ListSolNetworkPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListSolNetworkPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSolNetworkPackagesResponse> nextPage(ListSolNetworkPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListSolNetworkPackagesPublisher.this.client.listSolNetworkPackages(ListSolNetworkPackagesPublisher.this.firstRequest);
            }
            return ListSolNetworkPackagesPublisher.this.client.listSolNetworkPackages((ListSolNetworkPackagesRequest)((Object)ListSolNetworkPackagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

