/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.internal.UserAgentUtils;
import software.amazon.awssdk.services.swf.model.DomainInfo;
import software.amazon.awssdk.services.swf.model.ListDomainsRequest;
import software.amazon.awssdk.services.swf.model.ListDomainsResponse;

public class ListDomainsIterable
implements SdkIterable<ListDomainsResponse> {
    private final SwfClient client;
    private final ListDomainsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainsIterable(SwfClient client, ListDomainsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainsResponseFetcher();
    }

    public Iterator<ListDomainsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DomainInfo> domainInfos() {
        Function<ListDomainsResponse, Iterator> getIterator = response -> {
            if (response != null && response.domainInfos() != null) {
                return response.domainInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDomainsResponseFetcher
    implements SyncPageFetcher<ListDomainsResponse> {
        private ListDomainsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListDomainsResponse nextPage(ListDomainsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainsIterable.this.client.listDomains(ListDomainsIterable.this.firstRequest);
            }
            return ListDomainsIterable.this.client.listDomains((ListDomainsRequest)((Object)ListDomainsIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

