/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class TrustedAdvisorCheckRefreshStatusListCopier {
    static List<TrustedAdvisorCheckRefreshStatus> copy(
            Collection<? extends TrustedAdvisorCheckRefreshStatus> trustedAdvisorCheckRefreshStatusListParam) {
        List<TrustedAdvisorCheckRefreshStatus> list;
        if (trustedAdvisorCheckRefreshStatusListParam == null
                || trustedAdvisorCheckRefreshStatusListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TrustedAdvisorCheckRefreshStatus> modifiableList = new ArrayList<>();
            trustedAdvisorCheckRefreshStatusListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TrustedAdvisorCheckRefreshStatus> copyFromBuilder(
            Collection<? extends TrustedAdvisorCheckRefreshStatus.Builder> trustedAdvisorCheckRefreshStatusListParam) {
        List<TrustedAdvisorCheckRefreshStatus> list;
        if (trustedAdvisorCheckRefreshStatusListParam == null
                || trustedAdvisorCheckRefreshStatusListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TrustedAdvisorCheckRefreshStatus> modifiableList = new ArrayList<>();
            trustedAdvisorCheckRefreshStatusListParam.forEach(entry -> {
                TrustedAdvisorCheckRefreshStatus member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TrustedAdvisorCheckRefreshStatus.Builder> copyToBuilder(
            Collection<? extends TrustedAdvisorCheckRefreshStatus> trustedAdvisorCheckRefreshStatusListParam) {
        List<TrustedAdvisorCheckRefreshStatus.Builder> list;
        if (trustedAdvisorCheckRefreshStatusListParam == null
                || trustedAdvisorCheckRefreshStatusListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TrustedAdvisorCheckRefreshStatus.Builder> modifiableList = new ArrayList<>();
            trustedAdvisorCheckRefreshStatusListParam.forEach(entry -> {
                TrustedAdvisorCheckRefreshStatus.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
