/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCreateCaseOptionsResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeCreateCaseOptionsResponse.Builder, DescribeCreateCaseOptionsResponse> {
    private static final SdkField<String> LANGUAGE_AVAILABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("languageAvailability").getter(getter(DescribeCreateCaseOptionsResponse::languageAvailability))
            .setter(setter(Builder::languageAvailability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageAvailability").build())
            .build();

    private static final SdkField<List<CommunicationTypeOptions>> COMMUNICATION_TYPES_FIELD = SdkField
            .<List<CommunicationTypeOptions>> builder(MarshallingType.LIST)
            .memberName("communicationTypes")
            .getter(getter(DescribeCreateCaseOptionsResponse::communicationTypes))
            .setter(setter(Builder::communicationTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CommunicationTypeOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommunicationTypeOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_AVAILABILITY_FIELD,
            COMMUNICATION_TYPES_FIELD));

    private final String languageAvailability;

    private final List<CommunicationTypeOptions> communicationTypes;

    private DescribeCreateCaseOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.languageAvailability = builder.languageAvailability;
        this.communicationTypes = builder.communicationTypes;
    }

    /**
     * <p>
     * Language availability can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * available
     * </p>
     * </li>
     * <li>
     * <p>
     * best_effort
     * </p>
     * </li>
     * <li>
     * <p>
     * unavailable
     * </p>
     * </li>
     * </ul>
     * 
     * @return Language availability can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         available
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         best_effort
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         unavailable
     *         </p>
     *         </li>
     */
    public final String languageAvailability() {
        return languageAvailability;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommunicationTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCommunicationTypes() {
        return communicationTypes != null && !(communicationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON-formatted array that contains the available communication type options, along with the available support
     * timeframes for the given inputs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommunicationTypes} method.
     * </p>
     * 
     * @return A JSON-formatted array that contains the available communication type options, along with the available
     *         support timeframes for the given inputs.
     */
    public final List<CommunicationTypeOptions> communicationTypes() {
        return communicationTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(languageAvailability());
        hashCode = 31 * hashCode + Objects.hashCode(hasCommunicationTypes() ? communicationTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCreateCaseOptionsResponse)) {
            return false;
        }
        DescribeCreateCaseOptionsResponse other = (DescribeCreateCaseOptionsResponse) obj;
        return Objects.equals(languageAvailability(), other.languageAvailability())
                && hasCommunicationTypes() == other.hasCommunicationTypes()
                && Objects.equals(communicationTypes(), other.communicationTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCreateCaseOptionsResponse").add("LanguageAvailability", languageAvailability())
                .add("CommunicationTypes", hasCommunicationTypes() ? communicationTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "languageAvailability":
            return Optional.ofNullable(clazz.cast(languageAvailability()));
        case "communicationTypes":
            return Optional.ofNullable(clazz.cast(communicationTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCreateCaseOptionsResponse, T> g) {
        return obj -> g.apply((DescribeCreateCaseOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCreateCaseOptionsResponse> {
        /**
         * <p>
         * Language availability can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * available
         * </p>
         * </li>
         * <li>
         * <p>
         * best_effort
         * </p>
         * </li>
         * <li>
         * <p>
         * unavailable
         * </p>
         * </li>
         * </ul>
         * 
         * @param languageAvailability
         *        Language availability can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        available
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        best_effort
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        unavailable
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageAvailability(String languageAvailability);

        /**
         * <p>
         * A JSON-formatted array that contains the available communication type options, along with the available
         * support timeframes for the given inputs.
         * </p>
         * 
         * @param communicationTypes
         *        A JSON-formatted array that contains the available communication type options, along with the
         *        available support timeframes for the given inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationTypes(Collection<CommunicationTypeOptions> communicationTypes);

        /**
         * <p>
         * A JSON-formatted array that contains the available communication type options, along with the available
         * support timeframes for the given inputs.
         * </p>
         * 
         * @param communicationTypes
         *        A JSON-formatted array that contains the available communication type options, along with the
         *        available support timeframes for the given inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationTypes(CommunicationTypeOptions... communicationTypes);

        /**
         * <p>
         * A JSON-formatted array that contains the available communication type options, along with the available
         * support timeframes for the given inputs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.support.model.CommunicationTypeOptions.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.support.model.CommunicationTypeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.support.model.CommunicationTypeOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #communicationTypes(List<CommunicationTypeOptions>)}.
         * 
         * @param communicationTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.support.model.CommunicationTypeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #communicationTypes(java.util.Collection<CommunicationTypeOptions>)
         */
        Builder communicationTypes(Consumer<CommunicationTypeOptions.Builder>... communicationTypes);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private String languageAvailability;

        private List<CommunicationTypeOptions> communicationTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCreateCaseOptionsResponse model) {
            super(model);
            languageAvailability(model.languageAvailability);
            communicationTypes(model.communicationTypes);
        }

        public final String getLanguageAvailability() {
            return languageAvailability;
        }

        public final void setLanguageAvailability(String languageAvailability) {
            this.languageAvailability = languageAvailability;
        }

        @Override
        public final Builder languageAvailability(String languageAvailability) {
            this.languageAvailability = languageAvailability;
            return this;
        }

        public final List<CommunicationTypeOptions.Builder> getCommunicationTypes() {
            List<CommunicationTypeOptions.Builder> result = CommunicationTypeOptionsListCopier
                    .copyToBuilder(this.communicationTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommunicationTypes(Collection<CommunicationTypeOptions.BuilderImpl> communicationTypes) {
            this.communicationTypes = CommunicationTypeOptionsListCopier.copyFromBuilder(communicationTypes);
        }

        @Override
        public final Builder communicationTypes(Collection<CommunicationTypeOptions> communicationTypes) {
            this.communicationTypes = CommunicationTypeOptionsListCopier.copy(communicationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communicationTypes(CommunicationTypeOptions... communicationTypes) {
            communicationTypes(Arrays.asList(communicationTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communicationTypes(Consumer<CommunicationTypeOptions.Builder>... communicationTypes) {
            communicationTypes(Stream.of(communicationTypes)
                    .map(c -> CommunicationTypeOptions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCreateCaseOptionsResponse build() {
            return new DescribeCreateCaseOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
