/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GatewayCapacity {
    SMALL("Small"),
    MEDIUM("Medium"),
    LARGE("Large"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GatewayCapacity> VALUE_MAP;
    private final String value;

    private GatewayCapacity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GatewayCapacity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GatewayCapacity> knownValues() {
        EnumSet<GatewayCapacity> knownValues = EnumSet.allOf(GatewayCapacity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GatewayCapacity.class, GatewayCapacity::toString);
    }
}

