/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeNFSFileSharesOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNfsFileSharesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeNfsFileSharesResponse.Builder, DescribeNfsFileSharesResponse> {
    private static final SdkField<List<NFSFileShareInfo>> NFS_FILE_SHARE_INFO_LIST_FIELD = SdkField
            .<List<NFSFileShareInfo>> builder(MarshallingType.LIST)
            .memberName("NFSFileShareInfoList")
            .getter(getter(DescribeNfsFileSharesResponse::nfsFileShareInfoList))
            .setter(setter(Builder::nfsFileShareInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFSFileShareInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NFSFileShareInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(NFSFileShareInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NFS_FILE_SHARE_INFO_LIST_FIELD));

    private final List<NFSFileShareInfo> nfsFileShareInfoList;

    private DescribeNfsFileSharesResponse(BuilderImpl builder) {
        super(builder);
        this.nfsFileShareInfoList = builder.nfsFileShareInfoList;
    }

    /**
     * For responses, this returns true if the service returned a value for the NFSFileShareInfoList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNfsFileShareInfoList() {
        return nfsFileShareInfoList != null && !(nfsFileShareInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing a description for each requested file share.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNfsFileShareInfoList} method.
     * </p>
     * 
     * @return An array containing a description for each requested file share.
     */
    public final List<NFSFileShareInfo> nfsFileShareInfoList() {
        return nfsFileShareInfoList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNfsFileShareInfoList() ? nfsFileShareInfoList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNfsFileSharesResponse)) {
            return false;
        }
        DescribeNfsFileSharesResponse other = (DescribeNfsFileSharesResponse) obj;
        return hasNfsFileShareInfoList() == other.hasNfsFileShareInfoList()
                && Objects.equals(nfsFileShareInfoList(), other.nfsFileShareInfoList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNfsFileSharesResponse")
                .add("NFSFileShareInfoList", hasNfsFileShareInfoList() ? nfsFileShareInfoList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NFSFileShareInfoList":
            return Optional.ofNullable(clazz.cast(nfsFileShareInfoList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNfsFileSharesResponse, T> g) {
        return obj -> g.apply((DescribeNfsFileSharesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNfsFileSharesResponse> {
        /**
         * <p>
         * An array containing a description for each requested file share.
         * </p>
         * 
         * @param nfsFileShareInfoList
         *        An array containing a description for each requested file share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nfsFileShareInfoList(Collection<NFSFileShareInfo> nfsFileShareInfoList);

        /**
         * <p>
         * An array containing a description for each requested file share.
         * </p>
         * 
         * @param nfsFileShareInfoList
         *        An array containing a description for each requested file share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nfsFileShareInfoList(NFSFileShareInfo... nfsFileShareInfoList);

        /**
         * <p>
         * An array containing a description for each requested file share.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.NFSFileShareInfo.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.storagegateway.model.NFSFileShareInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.NFSFileShareInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #nfsFileShareInfoList(List<NFSFileShareInfo>)}.
         * 
         * @param nfsFileShareInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.NFSFileShareInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nfsFileShareInfoList(java.util.Collection<NFSFileShareInfo>)
         */
        Builder nfsFileShareInfoList(Consumer<NFSFileShareInfo.Builder>... nfsFileShareInfoList);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<NFSFileShareInfo> nfsFileShareInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNfsFileSharesResponse model) {
            super(model);
            nfsFileShareInfoList(model.nfsFileShareInfoList);
        }

        public final List<NFSFileShareInfo.Builder> getNfsFileShareInfoList() {
            List<NFSFileShareInfo.Builder> result = NFSFileShareInfoListCopier.copyToBuilder(this.nfsFileShareInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNfsFileShareInfoList(Collection<NFSFileShareInfo.BuilderImpl> nfsFileShareInfoList) {
            this.nfsFileShareInfoList = NFSFileShareInfoListCopier.copyFromBuilder(nfsFileShareInfoList);
        }

        @Override
        public final Builder nfsFileShareInfoList(Collection<NFSFileShareInfo> nfsFileShareInfoList) {
            this.nfsFileShareInfoList = NFSFileShareInfoListCopier.copy(nfsFileShareInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nfsFileShareInfoList(NFSFileShareInfo... nfsFileShareInfoList) {
            nfsFileShareInfoList(Arrays.asList(nfsFileShareInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nfsFileShareInfoList(Consumer<NFSFileShareInfo.Builder>... nfsFileShareInfoList) {
            nfsFileShareInfoList(Stream.of(nfsFileShareInfoList).map(c -> NFSFileShareInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeNfsFileSharesResponse build() {
            return new DescribeNfsFileSharesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
