/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DeleteTapeArchiveInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTapeArchiveRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<DeleteTapeArchiveRequest.Builder, DeleteTapeArchiveRequest> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeARN").getter(getter(DeleteTapeArchiveRequest::tapeARN)).setter(setter(Builder::tapeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()).build();

    private static final SdkField<Boolean> BYPASS_GOVERNANCE_RETENTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("BypassGovernanceRetention")
            .getter(getter(DeleteTapeArchiveRequest::bypassGovernanceRetention))
            .setter(setter(Builder::bypassGovernanceRetention))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BypassGovernanceRetention").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD,
            BYPASS_GOVERNANCE_RETENTION_FIELD));

    private final String tapeARN;

    private final Boolean bypassGovernanceRetention;

    private DeleteTapeArchiveRequest(BuilderImpl builder) {
        super(builder);
        this.tapeARN = builder.tapeARN;
        this.bypassGovernanceRetention = builder.bypassGovernanceRetention;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf (VTS).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf (VTS).
     */
    public final String tapeARN() {
        return tapeARN;
    }

    /**
     * <p>
     * Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention lock. Only
     * archived tapes with tape retention lock set to <code>governance</code> can be deleted. Archived tapes with tape
     * retention lock set to <code>compliance</code> can't be deleted.
     * </p>
     * 
     * @return Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention
     *         lock. Only archived tapes with tape retention lock set to <code>governance</code> can be deleted.
     *         Archived tapes with tape retention lock set to <code>compliance</code> can't be deleted.
     */
    public final Boolean bypassGovernanceRetention() {
        return bypassGovernanceRetention;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(bypassGovernanceRetention());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTapeArchiveRequest)) {
            return false;
        }
        DeleteTapeArchiveRequest other = (DeleteTapeArchiveRequest) obj;
        return Objects.equals(tapeARN(), other.tapeARN())
                && Objects.equals(bypassGovernanceRetention(), other.bypassGovernanceRetention());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTapeArchiveRequest").add("TapeARN", tapeARN())
                .add("BypassGovernanceRetention", bypassGovernanceRetention()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeARN":
            return Optional.ofNullable(clazz.cast(tapeARN()));
        case "BypassGovernanceRetention":
            return Optional.ofNullable(clazz.cast(bypassGovernanceRetention()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTapeArchiveRequest, T> g) {
        return obj -> g.apply((DeleteTapeArchiveRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTapeArchiveRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf (VTS).
         * </p>
         * 
         * @param tapeARN
         *        The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf (VTS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARN(String tapeARN);

        /**
         * <p>
         * Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention lock.
         * Only archived tapes with tape retention lock set to <code>governance</code> can be deleted. Archived tapes
         * with tape retention lock set to <code>compliance</code> can't be deleted.
         * </p>
         * 
         * @param bypassGovernanceRetention
         *        Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention
         *        lock. Only archived tapes with tape retention lock set to <code>governance</code> can be deleted.
         *        Archived tapes with tape retention lock set to <code>compliance</code> can't be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String tapeARN;

        private Boolean bypassGovernanceRetention;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTapeArchiveRequest model) {
            super(model);
            tapeARN(model.tapeARN);
            bypassGovernanceRetention(model.bypassGovernanceRetention);
        }

        public final String getTapeARN() {
            return tapeARN;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final Boolean getBypassGovernanceRetention() {
            return bypassGovernanceRetention;
        }

        public final void setBypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
        }

        @Override
        public final Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTapeArchiveRequest build() {
            return new DeleteTapeArchiveRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
