/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.GatewayCapacity;
import software.amazon.awssdk.services.storagegateway.model.GatewayNetworkInterfacesCopier;
import software.amazon.awssdk.services.storagegateway.model.HostEnvironment;
import software.amazon.awssdk.services.storagegateway.model.NetworkInterface;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.SupportedGatewayCapacitiesCopier;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGatewayInformationResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeGatewayInformationResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayARN)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayId").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayId)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()}).build();
    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayName").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayName)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()}).build();
    private static final SdkField<String> GATEWAY_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayTimezone").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayTimezone)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayTimezone").build()}).build();
    private static final SdkField<String> GATEWAY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayState").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayState)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayState").build()}).build();
    private static final SdkField<List<NetworkInterface>> GATEWAY_NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GatewayNetworkInterfaces").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayNetworkInterfaces)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayNetworkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayNetworkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayType").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayType)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()}).build();
    private static final SdkField<String> NEXT_UPDATE_AVAILABILITY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextUpdateAvailabilityDate").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::nextUpdateAvailabilityDate)).setter(DescribeGatewayInformationResponse.setter(Builder::nextUpdateAvailabilityDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextUpdateAvailabilityDate").build()}).build();
    private static final SdkField<String> LAST_SOFTWARE_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastSoftwareUpdate").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::lastSoftwareUpdate)).setter(DescribeGatewayInformationResponse.setter(Builder::lastSoftwareUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSoftwareUpdate").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2InstanceId").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::ec2InstanceId)).setter(DescribeGatewayInformationResponse.setter(Builder::ec2InstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2InstanceRegion").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::ec2InstanceRegion)).setter(DescribeGatewayInformationResponse.setter(Builder::ec2InstanceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceRegion").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::tags)).setter(DescribeGatewayInformationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCEndpoint").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::vpcEndpoint)).setter(DescribeGatewayInformationResponse.setter(Builder::vpcEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCEndpoint").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLogGroupARN").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::cloudWatchLogGroupARN)).setter(DescribeGatewayInformationResponse.setter(Builder::cloudWatchLogGroupARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupARN").build()}).build();
    private static final SdkField<String> HOST_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostEnvironment").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::hostEnvironmentAsString)).setter(DescribeGatewayInformationResponse.setter(Builder::hostEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostEnvironment").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::endpointType)).setter(DescribeGatewayInformationResponse.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> SOFTWARE_UPDATES_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SoftwareUpdatesEndDate").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::softwareUpdatesEndDate)).setter(DescribeGatewayInformationResponse.setter(Builder::softwareUpdatesEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareUpdatesEndDate").build()}).build();
    private static final SdkField<String> DEPRECATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeprecationDate").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::deprecationDate)).setter(DescribeGatewayInformationResponse.setter(Builder::deprecationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecationDate").build()}).build();
    private static final SdkField<String> GATEWAY_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayCapacity").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayCapacityAsString)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayCapacity").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_GATEWAY_CAPACITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedGatewayCapacities").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::supportedGatewayCapacitiesAsStrings)).setter(DescribeGatewayInformationResponse.setter(Builder::supportedGatewayCapacitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedGatewayCapacities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HOST_ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostEnvironmentId").getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::hostEnvironmentId)).setter(DescribeGatewayInformationResponse.setter(Builder::hostEnvironmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostEnvironmentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, GATEWAY_ID_FIELD, GATEWAY_NAME_FIELD, GATEWAY_TIMEZONE_FIELD, GATEWAY_STATE_FIELD, GATEWAY_NETWORK_INTERFACES_FIELD, GATEWAY_TYPE_FIELD, NEXT_UPDATE_AVAILABILITY_DATE_FIELD, LAST_SOFTWARE_UPDATE_FIELD, EC2_INSTANCE_ID_FIELD, EC2_INSTANCE_REGION_FIELD, TAGS_FIELD, VPC_ENDPOINT_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, HOST_ENVIRONMENT_FIELD, ENDPOINT_TYPE_FIELD, SOFTWARE_UPDATES_END_DATE_FIELD, DEPRECATION_DATE_FIELD, GATEWAY_CAPACITY_FIELD, SUPPORTED_GATEWAY_CAPACITIES_FIELD, HOST_ENVIRONMENT_ID_FIELD));
    private final String gatewayARN;
    private final String gatewayId;
    private final String gatewayName;
    private final String gatewayTimezone;
    private final String gatewayState;
    private final List<NetworkInterface> gatewayNetworkInterfaces;
    private final String gatewayType;
    private final String nextUpdateAvailabilityDate;
    private final String lastSoftwareUpdate;
    private final String ec2InstanceId;
    private final String ec2InstanceRegion;
    private final List<Tag> tags;
    private final String vpcEndpoint;
    private final String cloudWatchLogGroupARN;
    private final String hostEnvironment;
    private final String endpointType;
    private final String softwareUpdatesEndDate;
    private final String deprecationDate;
    private final String gatewayCapacity;
    private final List<String> supportedGatewayCapacities;
    private final String hostEnvironmentId;

    private DescribeGatewayInformationResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.gatewayId = builder.gatewayId;
        this.gatewayName = builder.gatewayName;
        this.gatewayTimezone = builder.gatewayTimezone;
        this.gatewayState = builder.gatewayState;
        this.gatewayNetworkInterfaces = builder.gatewayNetworkInterfaces;
        this.gatewayType = builder.gatewayType;
        this.nextUpdateAvailabilityDate = builder.nextUpdateAvailabilityDate;
        this.lastSoftwareUpdate = builder.lastSoftwareUpdate;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.ec2InstanceRegion = builder.ec2InstanceRegion;
        this.tags = builder.tags;
        this.vpcEndpoint = builder.vpcEndpoint;
        this.cloudWatchLogGroupARN = builder.cloudWatchLogGroupARN;
        this.hostEnvironment = builder.hostEnvironment;
        this.endpointType = builder.endpointType;
        this.softwareUpdatesEndDate = builder.softwareUpdatesEndDate;
        this.deprecationDate = builder.deprecationDate;
        this.gatewayCapacity = builder.gatewayCapacity;
        this.supportedGatewayCapacities = builder.supportedGatewayCapacities;
        this.hostEnvironmentId = builder.hostEnvironmentId;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String gatewayName() {
        return this.gatewayName;
    }

    public final String gatewayTimezone() {
        return this.gatewayTimezone;
    }

    public final String gatewayState() {
        return this.gatewayState;
    }

    public final boolean hasGatewayNetworkInterfaces() {
        return this.gatewayNetworkInterfaces != null && !(this.gatewayNetworkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<NetworkInterface> gatewayNetworkInterfaces() {
        return this.gatewayNetworkInterfaces;
    }

    public final String gatewayType() {
        return this.gatewayType;
    }

    public final String nextUpdateAvailabilityDate() {
        return this.nextUpdateAvailabilityDate;
    }

    public final String lastSoftwareUpdate() {
        return this.lastSoftwareUpdate;
    }

    public final String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public final String ec2InstanceRegion() {
        return this.ec2InstanceRegion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String vpcEndpoint() {
        return this.vpcEndpoint;
    }

    public final String cloudWatchLogGroupARN() {
        return this.cloudWatchLogGroupARN;
    }

    public final HostEnvironment hostEnvironment() {
        return HostEnvironment.fromValue(this.hostEnvironment);
    }

    public final String hostEnvironmentAsString() {
        return this.hostEnvironment;
    }

    public final String endpointType() {
        return this.endpointType;
    }

    public final String softwareUpdatesEndDate() {
        return this.softwareUpdatesEndDate;
    }

    public final String deprecationDate() {
        return this.deprecationDate;
    }

    public final GatewayCapacity gatewayCapacity() {
        return GatewayCapacity.fromValue(this.gatewayCapacity);
    }

    public final String gatewayCapacityAsString() {
        return this.gatewayCapacity;
    }

    public final List<GatewayCapacity> supportedGatewayCapacities() {
        return SupportedGatewayCapacitiesCopier.copyStringToEnum(this.supportedGatewayCapacities);
    }

    public final boolean hasSupportedGatewayCapacities() {
        return this.supportedGatewayCapacities != null && !(this.supportedGatewayCapacities instanceof SdkAutoConstructList);
    }

    public final List<String> supportedGatewayCapacitiesAsStrings() {
        return this.supportedGatewayCapacities;
    }

    public final String hostEnvironmentId() {
        return this.hostEnvironmentId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayState());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatewayNetworkInterfaces() ? this.gatewayNetworkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextUpdateAvailabilityDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSoftwareUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointType());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareUpdatesEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedGatewayCapacities() ? this.supportedGatewayCapacitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hostEnvironmentId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayInformationResponse)) {
            return false;
        }
        DescribeGatewayInformationResponse other = (DescribeGatewayInformationResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.gatewayName(), other.gatewayName()) && Objects.equals(this.gatewayTimezone(), other.gatewayTimezone()) && Objects.equals(this.gatewayState(), other.gatewayState()) && this.hasGatewayNetworkInterfaces() == other.hasGatewayNetworkInterfaces() && Objects.equals(this.gatewayNetworkInterfaces(), other.gatewayNetworkInterfaces()) && Objects.equals(this.gatewayType(), other.gatewayType()) && Objects.equals(this.nextUpdateAvailabilityDate(), other.nextUpdateAvailabilityDate()) && Objects.equals(this.lastSoftwareUpdate(), other.lastSoftwareUpdate()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.ec2InstanceRegion(), other.ec2InstanceRegion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcEndpoint(), other.vpcEndpoint()) && Objects.equals(this.cloudWatchLogGroupARN(), other.cloudWatchLogGroupARN()) && Objects.equals(this.hostEnvironmentAsString(), other.hostEnvironmentAsString()) && Objects.equals(this.endpointType(), other.endpointType()) && Objects.equals(this.softwareUpdatesEndDate(), other.softwareUpdatesEndDate()) && Objects.equals(this.deprecationDate(), other.deprecationDate()) && Objects.equals(this.gatewayCapacityAsString(), other.gatewayCapacityAsString()) && this.hasSupportedGatewayCapacities() == other.hasSupportedGatewayCapacities() && Objects.equals(this.supportedGatewayCapacitiesAsStrings(), other.supportedGatewayCapacitiesAsStrings()) && Objects.equals(this.hostEnvironmentId(), other.hostEnvironmentId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGatewayInformationResponse").add("GatewayARN", (Object)this.gatewayARN()).add("GatewayId", (Object)this.gatewayId()).add("GatewayName", (Object)this.gatewayName()).add("GatewayTimezone", (Object)this.gatewayTimezone()).add("GatewayState", (Object)this.gatewayState()).add("GatewayNetworkInterfaces", this.hasGatewayNetworkInterfaces() ? this.gatewayNetworkInterfaces() : null).add("GatewayType", (Object)this.gatewayType()).add("NextUpdateAvailabilityDate", (Object)this.nextUpdateAvailabilityDate()).add("LastSoftwareUpdate", (Object)this.lastSoftwareUpdate()).add("Ec2InstanceId", (Object)this.ec2InstanceId()).add("Ec2InstanceRegion", (Object)this.ec2InstanceRegion()).add("Tags", this.hasTags() ? this.tags() : null).add("VPCEndpoint", (Object)this.vpcEndpoint()).add("CloudWatchLogGroupARN", (Object)this.cloudWatchLogGroupARN()).add("HostEnvironment", (Object)this.hostEnvironmentAsString()).add("EndpointType", (Object)this.endpointType()).add("SoftwareUpdatesEndDate", (Object)this.softwareUpdatesEndDate()).add("DeprecationDate", (Object)this.deprecationDate()).add("GatewayCapacity", (Object)this.gatewayCapacityAsString()).add("SupportedGatewayCapacities", this.hasSupportedGatewayCapacities() ? this.supportedGatewayCapacitiesAsStrings() : null).add("HostEnvironmentId", (Object)this.hostEnvironmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "GatewayName": {
                return Optional.ofNullable(clazz.cast(this.gatewayName()));
            }
            case "GatewayTimezone": {
                return Optional.ofNullable(clazz.cast(this.gatewayTimezone()));
            }
            case "GatewayState": {
                return Optional.ofNullable(clazz.cast(this.gatewayState()));
            }
            case "GatewayNetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.gatewayNetworkInterfaces()));
            }
            case "GatewayType": {
                return Optional.ofNullable(clazz.cast(this.gatewayType()));
            }
            case "NextUpdateAvailabilityDate": {
                return Optional.ofNullable(clazz.cast(this.nextUpdateAvailabilityDate()));
            }
            case "LastSoftwareUpdate": {
                return Optional.ofNullable(clazz.cast(this.lastSoftwareUpdate()));
            }
            case "Ec2InstanceId": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceId()));
            }
            case "Ec2InstanceRegion": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceRegion()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VPCEndpoint": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpoint()));
            }
            case "CloudWatchLogGroupARN": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupARN()));
            }
            case "HostEnvironment": {
                return Optional.ofNullable(clazz.cast(this.hostEnvironmentAsString()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointType()));
            }
            case "SoftwareUpdatesEndDate": {
                return Optional.ofNullable(clazz.cast(this.softwareUpdatesEndDate()));
            }
            case "DeprecationDate": {
                return Optional.ofNullable(clazz.cast(this.deprecationDate()));
            }
            case "GatewayCapacity": {
                return Optional.ofNullable(clazz.cast(this.gatewayCapacityAsString()));
            }
            case "SupportedGatewayCapacities": {
                return Optional.ofNullable(clazz.cast(this.supportedGatewayCapacitiesAsStrings()));
            }
            case "HostEnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.hostEnvironmentId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayInformationResponse, T> g) {
        return obj -> g.apply((DescribeGatewayInformationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private String gatewayId;
        private String gatewayName;
        private String gatewayTimezone;
        private String gatewayState;
        private List<NetworkInterface> gatewayNetworkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String gatewayType;
        private String nextUpdateAvailabilityDate;
        private String lastSoftwareUpdate;
        private String ec2InstanceId;
        private String ec2InstanceRegion;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String vpcEndpoint;
        private String cloudWatchLogGroupARN;
        private String hostEnvironment;
        private String endpointType;
        private String softwareUpdatesEndDate;
        private String deprecationDate;
        private String gatewayCapacity;
        private List<String> supportedGatewayCapacities = DefaultSdkAutoConstructList.getInstance();
        private String hostEnvironmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayInformationResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.gatewayId(model.gatewayId);
            this.gatewayName(model.gatewayName);
            this.gatewayTimezone(model.gatewayTimezone);
            this.gatewayState(model.gatewayState);
            this.gatewayNetworkInterfaces(model.gatewayNetworkInterfaces);
            this.gatewayType(model.gatewayType);
            this.nextUpdateAvailabilityDate(model.nextUpdateAvailabilityDate);
            this.lastSoftwareUpdate(model.lastSoftwareUpdate);
            this.ec2InstanceId(model.ec2InstanceId);
            this.ec2InstanceRegion(model.ec2InstanceRegion);
            this.tags(model.tags);
            this.vpcEndpoint(model.vpcEndpoint);
            this.cloudWatchLogGroupARN(model.cloudWatchLogGroupARN);
            this.hostEnvironment(model.hostEnvironment);
            this.endpointType(model.endpointType);
            this.softwareUpdatesEndDate(model.softwareUpdatesEndDate);
            this.deprecationDate(model.deprecationDate);
            this.gatewayCapacity(model.gatewayCapacity);
            this.supportedGatewayCapacitiesWithStrings(model.supportedGatewayCapacities);
            this.hostEnvironmentId(model.hostEnvironmentId);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getGatewayName() {
            return this.gatewayName;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final String getGatewayTimezone() {
            return this.gatewayTimezone;
        }

        public final void setGatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
        }

        @Override
        public final Builder gatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
            return this;
        }

        public final String getGatewayState() {
            return this.gatewayState;
        }

        public final void setGatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
        }

        @Override
        public final Builder gatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
            return this;
        }

        public final List<NetworkInterface.Builder> getGatewayNetworkInterfaces() {
            List<NetworkInterface.Builder> result = GatewayNetworkInterfacesCopier.copyToBuilder(this.gatewayNetworkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGatewayNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces = GatewayNetworkInterfacesCopier.copyFromBuilder(gatewayNetworkInterfaces);
        }

        @Override
        public final Builder gatewayNetworkInterfaces(Collection<NetworkInterface> gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces = GatewayNetworkInterfacesCopier.copy(gatewayNetworkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayNetworkInterfaces(NetworkInterface ... gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces(Arrays.asList(gatewayNetworkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayNetworkInterfaces(Consumer<NetworkInterface.Builder> ... gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces(Stream.of(gatewayNetworkInterfaces).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGatewayType() {
            return this.gatewayType;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        @Override
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        public final String getNextUpdateAvailabilityDate() {
            return this.nextUpdateAvailabilityDate;
        }

        public final void setNextUpdateAvailabilityDate(String nextUpdateAvailabilityDate) {
            this.nextUpdateAvailabilityDate = nextUpdateAvailabilityDate;
        }

        @Override
        public final Builder nextUpdateAvailabilityDate(String nextUpdateAvailabilityDate) {
            this.nextUpdateAvailabilityDate = nextUpdateAvailabilityDate;
            return this;
        }

        public final String getLastSoftwareUpdate() {
            return this.lastSoftwareUpdate;
        }

        public final void setLastSoftwareUpdate(String lastSoftwareUpdate) {
            this.lastSoftwareUpdate = lastSoftwareUpdate;
        }

        @Override
        public final Builder lastSoftwareUpdate(String lastSoftwareUpdate) {
            this.lastSoftwareUpdate = lastSoftwareUpdate;
            return this;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final String getEc2InstanceRegion() {
            return this.ec2InstanceRegion;
        }

        public final void setEc2InstanceRegion(String ec2InstanceRegion) {
            this.ec2InstanceRegion = ec2InstanceRegion;
        }

        @Override
        public final Builder ec2InstanceRegion(String ec2InstanceRegion) {
            this.ec2InstanceRegion = ec2InstanceRegion;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcEndpoint() {
            return this.vpcEndpoint;
        }

        public final void setVpcEndpoint(String vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
        }

        @Override
        public final Builder vpcEndpoint(String vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        public final String getCloudWatchLogGroupARN() {
            return this.cloudWatchLogGroupARN;
        }

        public final void setCloudWatchLogGroupARN(String cloudWatchLogGroupARN) {
            this.cloudWatchLogGroupARN = cloudWatchLogGroupARN;
        }

        @Override
        public final Builder cloudWatchLogGroupARN(String cloudWatchLogGroupARN) {
            this.cloudWatchLogGroupARN = cloudWatchLogGroupARN;
            return this;
        }

        public final String getHostEnvironment() {
            return this.hostEnvironment;
        }

        public final void setHostEnvironment(String hostEnvironment) {
            this.hostEnvironment = hostEnvironment;
        }

        @Override
        public final Builder hostEnvironment(String hostEnvironment) {
            this.hostEnvironment = hostEnvironment;
            return this;
        }

        @Override
        public final Builder hostEnvironment(HostEnvironment hostEnvironment) {
            this.hostEnvironment(hostEnvironment == null ? null : hostEnvironment.toString());
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public final String getSoftwareUpdatesEndDate() {
            return this.softwareUpdatesEndDate;
        }

        public final void setSoftwareUpdatesEndDate(String softwareUpdatesEndDate) {
            this.softwareUpdatesEndDate = softwareUpdatesEndDate;
        }

        @Override
        public final Builder softwareUpdatesEndDate(String softwareUpdatesEndDate) {
            this.softwareUpdatesEndDate = softwareUpdatesEndDate;
            return this;
        }

        public final String getDeprecationDate() {
            return this.deprecationDate;
        }

        public final void setDeprecationDate(String deprecationDate) {
            this.deprecationDate = deprecationDate;
        }

        @Override
        public final Builder deprecationDate(String deprecationDate) {
            this.deprecationDate = deprecationDate;
            return this;
        }

        public final String getGatewayCapacity() {
            return this.gatewayCapacity;
        }

        public final void setGatewayCapacity(String gatewayCapacity) {
            this.gatewayCapacity = gatewayCapacity;
        }

        @Override
        public final Builder gatewayCapacity(String gatewayCapacity) {
            this.gatewayCapacity = gatewayCapacity;
            return this;
        }

        @Override
        public final Builder gatewayCapacity(GatewayCapacity gatewayCapacity) {
            this.gatewayCapacity(gatewayCapacity == null ? null : gatewayCapacity.toString());
            return this;
        }

        public final Collection<String> getSupportedGatewayCapacities() {
            if (this.supportedGatewayCapacities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedGatewayCapacities;
        }

        public final void setSupportedGatewayCapacities(Collection<String> supportedGatewayCapacities) {
            this.supportedGatewayCapacities = SupportedGatewayCapacitiesCopier.copy(supportedGatewayCapacities);
        }

        @Override
        public final Builder supportedGatewayCapacitiesWithStrings(Collection<String> supportedGatewayCapacities) {
            this.supportedGatewayCapacities = SupportedGatewayCapacitiesCopier.copy(supportedGatewayCapacities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedGatewayCapacitiesWithStrings(String ... supportedGatewayCapacities) {
            this.supportedGatewayCapacitiesWithStrings(Arrays.asList(supportedGatewayCapacities));
            return this;
        }

        @Override
        public final Builder supportedGatewayCapacities(Collection<GatewayCapacity> supportedGatewayCapacities) {
            this.supportedGatewayCapacities = SupportedGatewayCapacitiesCopier.copyEnumToString(supportedGatewayCapacities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedGatewayCapacities(GatewayCapacity ... supportedGatewayCapacities) {
            this.supportedGatewayCapacities(Arrays.asList(supportedGatewayCapacities));
            return this;
        }

        public final String getHostEnvironmentId() {
            return this.hostEnvironmentId;
        }

        public final void setHostEnvironmentId(String hostEnvironmentId) {
            this.hostEnvironmentId = hostEnvironmentId;
        }

        @Override
        public final Builder hostEnvironmentId(String hostEnvironmentId) {
            this.hostEnvironmentId = hostEnvironmentId;
            return this;
        }

        @Override
        public DescribeGatewayInformationResponse build() {
            return new DescribeGatewayInformationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGatewayInformationResponse> {
        public Builder gatewayARN(String var1);

        public Builder gatewayId(String var1);

        public Builder gatewayName(String var1);

        public Builder gatewayTimezone(String var1);

        public Builder gatewayState(String var1);

        public Builder gatewayNetworkInterfaces(Collection<NetworkInterface> var1);

        public Builder gatewayNetworkInterfaces(NetworkInterface ... var1);

        public Builder gatewayNetworkInterfaces(Consumer<NetworkInterface.Builder> ... var1);

        public Builder gatewayType(String var1);

        public Builder nextUpdateAvailabilityDate(String var1);

        public Builder lastSoftwareUpdate(String var1);

        public Builder ec2InstanceId(String var1);

        public Builder ec2InstanceRegion(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder vpcEndpoint(String var1);

        public Builder cloudWatchLogGroupARN(String var1);

        public Builder hostEnvironment(String var1);

        public Builder hostEnvironment(HostEnvironment var1);

        public Builder endpointType(String var1);

        public Builder softwareUpdatesEndDate(String var1);

        public Builder deprecationDate(String var1);

        public Builder gatewayCapacity(String var1);

        public Builder gatewayCapacity(GatewayCapacity var1);

        public Builder supportedGatewayCapacitiesWithStrings(Collection<String> var1);

        public Builder supportedGatewayCapacitiesWithStrings(String ... var1);

        public Builder supportedGatewayCapacities(Collection<GatewayCapacity> var1);

        public Builder supportedGatewayCapacities(GatewayCapacity ... var1);

        public Builder hostEnvironmentId(String var1);
    }
}

