/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc;

import java.util.Objects;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.token.credentials.ChildProfileTokenProviderFactory;
import software.amazon.awssdk.auth.token.credentials.SdkToken;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.internal.ProfileSection;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssooidc.SsoOidcClient;
import software.amazon.awssdk.services.ssooidc.SsoOidcClientBuilder;
import software.amazon.awssdk.services.ssooidc.SsoOidcTokenProvider;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkProtectedApi
public final class SsoOidcProfileTokenProviderFactory
implements ChildProfileTokenProviderFactory {
    private static final String MISSING_PROPERTY_ERROR_FORMAT = "'%s' must be set to use bearer tokens loading in the '%s' profile.";

    public SdkTokenProvider create(ProfileFile profileFile, Profile profile) {
        return new SsoOidcProfileTokenProvider(profileFile, profile);
    }

    public SdkTokenProvider create(Supplier<ProfileFile> profileFile, String profileName) {
        return new SsoOidcSuppliedProfileTokenProvider(profileFile, profileName);
    }

    private static final class SsoOidcProfileTokenProvider
    implements SdkTokenProvider,
    SdkAutoCloseable {
        private final SsoOidcTokenProvider sdkTokenProvider;

        private SsoOidcProfileTokenProvider(ProfileFile profileFile, Profile profile) {
            String profileSsoSectionName = (String)profile.property(ProfileSection.SSO_SESSION.getPropertyKeyName()).orElseThrow(() -> new IllegalStateException("Profile " + profile.name() + " does not have sso_session property"));
            Profile ssoProfile = (Profile)profileFile.getSection(ProfileSection.SSO_SESSION.getSectionTitle(), profileSsoSectionName).orElseThrow(() -> new IllegalArgumentException("Sso-session section not found with sso-session title " + profileSsoSectionName + "."));
            String startUrl = this.requireProperty(ssoProfile, "sso_start_url");
            String region = this.requireProperty(ssoProfile, "sso_region");
            if (ssoProfile.property("sso_account_id").isPresent() || ssoProfile.property("sso_role_name").isPresent()) {
                throw new IllegalStateException("sso_account_id or sso_role_name properties must not be defined forprofiles that provide ssooidc providers");
            }
            this.sdkTokenProvider = SsoOidcTokenProvider.builder().sessionName(ssoProfile.name()).ssoOidcClient((SsoOidcClient)((SsoOidcClientBuilder)((SsoOidcClientBuilder)SsoOidcClient.builder().region(Region.of((String)region))).credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).build()).build();
        }

        private String requireProperty(Profile profile, String requiredProperty) {
            return (String)profile.property(requiredProperty).orElseThrow(() -> new IllegalArgumentException(String.format(SsoOidcProfileTokenProviderFactory.MISSING_PROPERTY_ERROR_FORMAT, requiredProperty, profile.name())));
        }

        public SdkToken resolveToken() {
            return this.sdkTokenProvider.resolveToken();
        }

        public void close() {
            IoUtils.closeQuietly((AutoCloseable)((Object)this.sdkTokenProvider), null);
        }
    }

    private static final class SsoOidcSuppliedProfileTokenProvider
    implements SdkTokenProvider,
    SdkAutoCloseable {
        private final Supplier<ProfileFile> profileFile;
        private final String profileName;
        private volatile ProfileFile currentProfileFile;
        private volatile SsoOidcProfileTokenProvider currentTokenProvider;

        private SsoOidcSuppliedProfileTokenProvider(Supplier<ProfileFile> profileFile, String profileName) {
            this.profileFile = profileFile;
            this.profileName = profileName;
        }

        public SdkToken resolveToken() {
            return this.sdkTokenProvider().resolveToken();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SdkTokenProvider sdkTokenProvider() {
            ProfileFile profileFileInstance = this.profileFile.get();
            if (!Objects.equals(profileFileInstance, this.currentProfileFile)) {
                SsoOidcSuppliedProfileTokenProvider ssoOidcSuppliedProfileTokenProvider = this;
                synchronized (ssoOidcSuppliedProfileTokenProvider) {
                    if (!Objects.equals(profileFileInstance, this.currentProfileFile)) {
                        Profile profileInstance = this.resolveProfile(profileFileInstance, this.profileName);
                        this.currentProfileFile = profileFileInstance;
                        this.currentTokenProvider = new SsoOidcProfileTokenProvider(profileFileInstance, profileInstance);
                    }
                }
            }
            return this.currentTokenProvider;
        }

        private Profile resolveProfile(ProfileFile profileFile, String profileName) {
            return (Profile)profileFile.profile(profileName).orElseThrow(() -> {
                String errorMessage = String.format("Profile file contained no information for profile'%s': %s", profileName, profileFile);
                return SdkClientException.builder().message(errorMessage).build();
            });
        }

        public void close() {
            IoUtils.closeQuietly((AutoCloseable)((Object)this.currentTokenProvider), null);
        }
    }
}

