/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountAssignmentDeletionStatusRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, DescribeAccountAssignmentDeletionStatusRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceArn").getter(DescribeAccountAssignmentDeletionStatusRequest.getter(DescribeAccountAssignmentDeletionStatusRequest::instanceArn)).setter(DescribeAccountAssignmentDeletionStatusRequest.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ASSIGNMENT_DELETION_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountAssignmentDeletionRequestId").getter(DescribeAccountAssignmentDeletionStatusRequest.getter(DescribeAccountAssignmentDeletionStatusRequest::accountAssignmentDeletionRequestId)).setter(DescribeAccountAssignmentDeletionStatusRequest.setter(Builder::accountAssignmentDeletionRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssignmentDeletionRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, ACCOUNT_ASSIGNMENT_DELETION_REQUEST_ID_FIELD));
    private final String instanceArn;
    private final String accountAssignmentDeletionRequestId;

    private DescribeAccountAssignmentDeletionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.accountAssignmentDeletionRequestId = builder.accountAssignmentDeletionRequestId;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final String accountAssignmentDeletionRequestId() {
        return this.accountAssignmentDeletionRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAssignmentDeletionRequestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAssignmentDeletionStatusRequest)) {
            return false;
        }
        DescribeAccountAssignmentDeletionStatusRequest other = (DescribeAccountAssignmentDeletionStatusRequest)((Object)obj);
        return Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.accountAssignmentDeletionRequestId(), other.accountAssignmentDeletionRequestId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccountAssignmentDeletionStatusRequest").add("InstanceArn", (Object)this.instanceArn()).add("AccountAssignmentDeletionRequestId", (Object)this.accountAssignmentDeletionRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "AccountAssignmentDeletionRequestId": {
                return Optional.ofNullable(clazz.cast(this.accountAssignmentDeletionRequestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAssignmentDeletionStatusRequest, T> g) {
        return obj -> g.apply((DescribeAccountAssignmentDeletionStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String instanceArn;
        private String accountAssignmentDeletionRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAssignmentDeletionStatusRequest model) {
            super(model);
            this.instanceArn(model.instanceArn);
            this.accountAssignmentDeletionRequestId(model.accountAssignmentDeletionRequestId);
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getAccountAssignmentDeletionRequestId() {
            return this.accountAssignmentDeletionRequestId;
        }

        public final void setAccountAssignmentDeletionRequestId(String accountAssignmentDeletionRequestId) {
            this.accountAssignmentDeletionRequestId = accountAssignmentDeletionRequestId;
        }

        @Override
        public final Builder accountAssignmentDeletionRequestId(String accountAssignmentDeletionRequestId) {
            this.accountAssignmentDeletionRequestId = accountAssignmentDeletionRequestId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAccountAssignmentDeletionStatusRequest build() {
            return new DescribeAccountAssignmentDeletionStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountAssignmentDeletionStatusRequest> {
        public Builder instanceArn(String var1);

        public Builder accountAssignmentDeletionRequestId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

