/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.HostRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Host
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Host> {
    private static final SdkField<String> HOST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostName").getter(Host.getter(Host::hostName)).setter(Host.setter(Builder::hostName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostName").build()}).build();
    private static final SdkField<String> HOST_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostRole").getter(Host.getter(Host::hostRoleAsString)).setter(Host.setter(Builder::hostRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostRole").build()}).build();
    private static final SdkField<String> HOST_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostIp").getter(Host.getter(Host::hostIp)).setter(Host.setter(Builder::hostIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostIp").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(Host.getter(Host::instanceId)).setter(Host.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_NAME_FIELD, HOST_ROLE_FIELD, HOST_IP_FIELD, INSTANCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hostName;
    private final String hostRole;
    private final String hostIp;
    private final String instanceId;

    private Host(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.hostRole = builder.hostRole;
        this.hostIp = builder.hostIp;
        this.instanceId = builder.instanceId;
    }

    public final String hostName() {
        return this.hostName;
    }

    public final HostRole hostRole() {
        return HostRole.fromValue(this.hostRole);
    }

    public final String hostRoleAsString() {
        return this.hostRole;
    }

    public final String hostIp() {
        return this.hostIp;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        return Objects.equals(this.hostName(), other.hostName()) && Objects.equals(this.hostRoleAsString(), other.hostRoleAsString()) && Objects.equals(this.hostIp(), other.hostIp()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public final String toString() {
        return ToString.builder((String)"Host").add("HostName", (Object)this.hostName()).add("HostRole", (Object)this.hostRoleAsString()).add("HostIp", (Object)this.hostIp()).add("InstanceId", (Object)this.instanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostName": {
                return Optional.ofNullable(clazz.cast(this.hostName()));
            }
            case "HostRole": {
                return Optional.ofNullable(clazz.cast(this.hostRoleAsString()));
            }
            case "HostIp": {
                return Optional.ofNullable(clazz.cast(this.hostIp()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Host, T> g) {
        return obj -> g.apply((Host)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostName;
        private String hostRole;
        private String hostIp;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            this.hostName(model.hostName);
            this.hostRole(model.hostRole);
            this.hostIp(model.hostIp);
            this.instanceId(model.instanceId);
        }

        public final String getHostName() {
            return this.hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final String getHostRole() {
            return this.hostRole;
        }

        public final void setHostRole(String hostRole) {
            this.hostRole = hostRole;
        }

        @Override
        public final Builder hostRole(String hostRole) {
            this.hostRole = hostRole;
            return this;
        }

        @Override
        public final Builder hostRole(HostRole hostRole) {
            this.hostRole(hostRole == null ? null : hostRole.toString());
            return this;
        }

        public final String getHostIp() {
            return this.hostIp;
        }

        public final void setHostIp(String hostIp) {
            this.hostIp = hostIp;
        }

        @Override
        public final Builder hostIp(String hostIp) {
            this.hostIp = hostIp;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Host build() {
            return new Host(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Host> {
        public Builder hostName(String var1);

        public Builder hostRole(String var1);

        public Builder hostRole(HostRole var1);

        public Builder hostIp(String var1);

        public Builder instanceId(String var1);
    }
}

