/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ssmsap.DefaultSsmSapClientBuilder;
import software.amazon.awssdk.services.ssmsap.SsmSapClientBuilder;
import software.amazon.awssdk.services.ssmsap.SsmSapServiceClientConfiguration;
import software.amazon.awssdk.services.ssmsap.model.ConflictException;
import software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionRequest;
import software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionResponse;
import software.amazon.awssdk.services.ssmsap.model.DeregisterApplicationRequest;
import software.amazon.awssdk.services.ssmsap.model.DeregisterApplicationResponse;
import software.amazon.awssdk.services.ssmsap.model.GetApplicationRequest;
import software.amazon.awssdk.services.ssmsap.model.GetApplicationResponse;
import software.amazon.awssdk.services.ssmsap.model.GetComponentRequest;
import software.amazon.awssdk.services.ssmsap.model.GetComponentResponse;
import software.amazon.awssdk.services.ssmsap.model.GetDatabaseRequest;
import software.amazon.awssdk.services.ssmsap.model.GetDatabaseResponse;
import software.amazon.awssdk.services.ssmsap.model.GetOperationRequest;
import software.amazon.awssdk.services.ssmsap.model.GetOperationResponse;
import software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionRequest;
import software.amazon.awssdk.services.ssmsap.model.GetResourcePermissionResponse;
import software.amazon.awssdk.services.ssmsap.model.InternalServerException;
import software.amazon.awssdk.services.ssmsap.model.ListApplicationsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListApplicationsResponse;
import software.amazon.awssdk.services.ssmsap.model.ListComponentsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListComponentsResponse;
import software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest;
import software.amazon.awssdk.services.ssmsap.model.ListDatabasesResponse;
import software.amazon.awssdk.services.ssmsap.model.ListOperationsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListOperationsResponse;
import software.amazon.awssdk.services.ssmsap.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssmsap.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionRequest;
import software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionResponse;
import software.amazon.awssdk.services.ssmsap.model.RegisterApplicationRequest;
import software.amazon.awssdk.services.ssmsap.model.RegisterApplicationResponse;
import software.amazon.awssdk.services.ssmsap.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ssmsap.model.SsmSapException;
import software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshRequest;
import software.amazon.awssdk.services.ssmsap.model.StartApplicationRefreshResponse;
import software.amazon.awssdk.services.ssmsap.model.TagResourceRequest;
import software.amazon.awssdk.services.ssmsap.model.TagResourceResponse;
import software.amazon.awssdk.services.ssmsap.model.UntagResourceRequest;
import software.amazon.awssdk.services.ssmsap.model.UntagResourceResponse;
import software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsRequest;
import software.amazon.awssdk.services.ssmsap.model.UpdateApplicationSettingsResponse;
import software.amazon.awssdk.services.ssmsap.model.ValidationException;
import software.amazon.awssdk.services.ssmsap.paginators.ListApplicationsIterable;
import software.amazon.awssdk.services.ssmsap.paginators.ListComponentsIterable;
import software.amazon.awssdk.services.ssmsap.paginators.ListDatabasesIterable;
import software.amazon.awssdk.services.ssmsap.paginators.ListOperationsIterable;

@SdkPublicApi
@ThreadSafe
public interface SsmSapClient
extends AwsClient {
    public static final String SERVICE_NAME = "ssm-sap";
    public static final String SERVICE_METADATA_ID = "ssm-sap";

    default public DeleteResourcePermissionResponse deleteResourcePermission(DeleteResourcePermissionRequest deleteResourcePermissionRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public DeleteResourcePermissionResponse deleteResourcePermission(Consumer<DeleteResourcePermissionRequest.Builder> deleteResourcePermissionRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.deleteResourcePermission((DeleteResourcePermissionRequest)((Object)((DeleteResourcePermissionRequest.Builder)DeleteResourcePermissionRequest.builder().applyMutation(deleteResourcePermissionRequest)).build()));
    }

    default public DeregisterApplicationResponse deregisterApplication(DeregisterApplicationRequest deregisterApplicationRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public DeregisterApplicationResponse deregisterApplication(Consumer<DeregisterApplicationRequest.Builder> deregisterApplicationRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.deregisterApplication((DeregisterApplicationRequest)((Object)((DeregisterApplicationRequest.Builder)DeregisterApplicationRequest.builder().applyMutation(deregisterApplicationRequest)).build()));
    }

    default public GetApplicationResponse getApplication(GetApplicationRequest getApplicationRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public GetApplicationResponse getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.getApplication((GetApplicationRequest)((Object)((GetApplicationRequest.Builder)GetApplicationRequest.builder().applyMutation(getApplicationRequest)).build()));
    }

    default public GetComponentResponse getComponent(GetComponentRequest getComponentRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public GetComponentResponse getComponent(Consumer<GetComponentRequest.Builder> getComponentRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.getComponent((GetComponentRequest)((Object)((GetComponentRequest.Builder)GetComponentRequest.builder().applyMutation(getComponentRequest)).build()));
    }

    default public GetDatabaseResponse getDatabase(GetDatabaseRequest getDatabaseRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public GetDatabaseResponse getDatabase(Consumer<GetDatabaseRequest.Builder> getDatabaseRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.getDatabase((GetDatabaseRequest)((Object)((GetDatabaseRequest.Builder)GetDatabaseRequest.builder().applyMutation(getDatabaseRequest)).build()));
    }

    default public GetOperationResponse getOperation(GetOperationRequest getOperationRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public GetOperationResponse getOperation(Consumer<GetOperationRequest.Builder> getOperationRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.getOperation((GetOperationRequest)((Object)((GetOperationRequest.Builder)GetOperationRequest.builder().applyMutation(getOperationRequest)).build()));
    }

    default public GetResourcePermissionResponse getResourcePermission(GetResourcePermissionRequest getResourcePermissionRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public GetResourcePermissionResponse getResourcePermission(Consumer<GetResourcePermissionRequest.Builder> getResourcePermissionRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.getResourcePermission((GetResourcePermissionRequest)((Object)((GetResourcePermissionRequest.Builder)GetResourcePermissionRequest.builder().applyMutation(getResourcePermissionRequest)).build()));
    }

    default public ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public ListApplicationsResponse listApplications(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.listApplications((ListApplicationsRequest)((Object)((ListApplicationsRequest.Builder)ListApplicationsRequest.builder().applyMutation(listApplicationsRequest)).build()));
    }

    default public ListApplicationsIterable listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return new ListApplicationsIterable(this, listApplicationsRequest);
    }

    default public ListApplicationsIterable listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.listApplicationsPaginator((ListApplicationsRequest)((Object)((ListApplicationsRequest.Builder)ListApplicationsRequest.builder().applyMutation(listApplicationsRequest)).build()));
    }

    default public ListComponentsResponse listComponents(ListComponentsRequest listComponentsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public ListComponentsResponse listComponents(Consumer<ListComponentsRequest.Builder> listComponentsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.listComponents((ListComponentsRequest)((Object)((ListComponentsRequest.Builder)ListComponentsRequest.builder().applyMutation(listComponentsRequest)).build()));
    }

    default public ListComponentsIterable listComponentsPaginator(ListComponentsRequest listComponentsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return new ListComponentsIterable(this, listComponentsRequest);
    }

    default public ListComponentsIterable listComponentsPaginator(Consumer<ListComponentsRequest.Builder> listComponentsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.listComponentsPaginator((ListComponentsRequest)((Object)((ListComponentsRequest.Builder)ListComponentsRequest.builder().applyMutation(listComponentsRequest)).build()));
    }

    default public ListDatabasesResponse listDatabases(ListDatabasesRequest listDatabasesRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public ListDatabasesResponse listDatabases(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.listDatabases((ListDatabasesRequest)((Object)((ListDatabasesRequest.Builder)ListDatabasesRequest.builder().applyMutation(listDatabasesRequest)).build()));
    }

    default public ListDatabasesIterable listDatabasesPaginator(ListDatabasesRequest listDatabasesRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return new ListDatabasesIterable(this, listDatabasesRequest);
    }

    default public ListDatabasesIterable listDatabasesPaginator(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.listDatabasesPaginator((ListDatabasesRequest)((Object)((ListDatabasesRequest.Builder)ListDatabasesRequest.builder().applyMutation(listDatabasesRequest)).build()));
    }

    default public ListOperationsResponse listOperations(ListOperationsRequest listOperationsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public ListOperationsResponse listOperations(Consumer<ListOperationsRequest.Builder> listOperationsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.listOperations((ListOperationsRequest)((Object)((ListOperationsRequest.Builder)ListOperationsRequest.builder().applyMutation(listOperationsRequest)).build()));
    }

    default public ListOperationsIterable listOperationsPaginator(ListOperationsRequest listOperationsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return new ListOperationsIterable(this, listOperationsRequest);
    }

    default public ListOperationsIterable listOperationsPaginator(Consumer<ListOperationsRequest.Builder> listOperationsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.listOperationsPaginator((ListOperationsRequest)((Object)((ListOperationsRequest.Builder)ListOperationsRequest.builder().applyMutation(listOperationsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsmSapException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public PutResourcePermissionResponse putResourcePermission(PutResourcePermissionRequest putResourcePermissionRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public PutResourcePermissionResponse putResourcePermission(Consumer<PutResourcePermissionRequest.Builder> putResourcePermissionRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.putResourcePermission((PutResourcePermissionRequest)((Object)((PutResourcePermissionRequest.Builder)PutResourcePermissionRequest.builder().applyMutation(putResourcePermissionRequest)).build()));
    }

    default public RegisterApplicationResponse registerApplication(RegisterApplicationRequest registerApplicationRequest) throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public RegisterApplicationResponse registerApplication(Consumer<RegisterApplicationRequest.Builder> registerApplicationRequest) throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.registerApplication((RegisterApplicationRequest)((Object)((RegisterApplicationRequest.Builder)RegisterApplicationRequest.builder().applyMutation(registerApplicationRequest)).build()));
    }

    default public StartApplicationRefreshResponse startApplicationRefresh(StartApplicationRefreshRequest startApplicationRefreshRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public StartApplicationRefreshResponse startApplicationRefresh(Consumer<StartApplicationRefreshRequest.Builder> startApplicationRefreshRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.startApplicationRefresh((StartApplicationRefreshRequest)((Object)((StartApplicationRefreshRequest.Builder)StartApplicationRefreshRequest.builder().applyMutation(startApplicationRefreshRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsmSapException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsmSapException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateApplicationSettingsResponse updateApplicationSettings(UpdateApplicationSettingsRequest updateApplicationSettingsRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        throw new UnsupportedOperationException();
    }

    default public UpdateApplicationSettingsResponse updateApplicationSettings(Consumer<UpdateApplicationSettingsRequest.Builder> updateApplicationSettingsRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, SsmSapException {
        return this.updateApplicationSettings((UpdateApplicationSettingsRequest)((Object)((UpdateApplicationSettingsRequest.Builder)UpdateApplicationSettingsRequest.builder().applyMutation(updateApplicationSettingsRequest)).build()));
    }

    public static SsmSapClient create() {
        return (SsmSapClient)SsmSapClient.builder().build();
    }

    public static SsmSapClientBuilder builder() {
        return new DefaultSsmSapClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"ssm-sap");
    }

    default public SsmSapServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

