/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDatabaseRequest extends SsmSapRequest implements
        ToCopyableBuilder<GetDatabaseRequest.Builder, GetDatabaseRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(GetDatabaseRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentId").getter(getter(GetDatabaseRequest::componentId)).setter(setter(Builder::componentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentId").build()).build();

    private static final SdkField<String> DATABASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseId").getter(getter(GetDatabaseRequest::databaseId)).setter(setter(Builder::databaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseId").build()).build();

    private static final SdkField<String> DATABASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseArn").getter(getter(GetDatabaseRequest::databaseArn)).setter(setter(Builder::databaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            COMPONENT_ID_FIELD, DATABASE_ID_FIELD, DATABASE_ARN_FIELD));

    private final String applicationId;

    private final String componentId;

    private final String databaseId;

    private final String databaseArn;

    private GetDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.componentId = builder.componentId;
        this.databaseId = builder.databaseId;
        this.databaseArn = builder.databaseArn;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The ID of the component.
     * </p>
     * 
     * @return The ID of the component.
     */
    public final String componentId() {
        return componentId;
    }

    /**
     * <p>
     * The ID of the database.
     * </p>
     * 
     * @return The ID of the database.
     */
    public final String databaseId() {
        return databaseId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the database.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the database.
     */
    public final String databaseArn() {
        return databaseArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(componentId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatabaseRequest)) {
            return false;
        }
        GetDatabaseRequest other = (GetDatabaseRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(componentId(), other.componentId())
                && Objects.equals(databaseId(), other.databaseId()) && Objects.equals(databaseArn(), other.databaseArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDatabaseRequest").add("ApplicationId", applicationId()).add("ComponentId", componentId())
                .add("DatabaseId", databaseId()).add("DatabaseArn", databaseArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ComponentId":
            return Optional.ofNullable(clazz.cast(componentId()));
        case "DatabaseId":
            return Optional.ofNullable(clazz.cast(databaseId()));
        case "DatabaseArn":
            return Optional.ofNullable(clazz.cast(databaseArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDatabaseRequest, T> g) {
        return obj -> g.apply((GetDatabaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmSapRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDatabaseRequest> {
        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The ID of the component.
         * </p>
         * 
         * @param componentId
         *        The ID of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentId(String componentId);

        /**
         * <p>
         * The ID of the database.
         * </p>
         * 
         * @param databaseId
         *        The ID of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseId(String databaseId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the database.
         * </p>
         * 
         * @param databaseArn
         *        The Amazon Resource Name (ARN) of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseArn(String databaseArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmSapRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String componentId;

        private String databaseId;

        private String databaseArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatabaseRequest model) {
            super(model);
            applicationId(model.applicationId);
            componentId(model.componentId);
            databaseId(model.databaseId);
            databaseArn(model.databaseArn);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getComponentId() {
            return componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final String getDatabaseId() {
            return databaseId;
        }

        public final void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public final Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public final String getDatabaseArn() {
            return databaseArn;
        }

        public final void setDatabaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
        }

        @Override
        public final Builder databaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDatabaseRequest build() {
            return new GetDatabaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
