/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about rotations that recur weekly.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WeeklySetting implements SdkPojo, Serializable, ToCopyableBuilder<WeeklySetting.Builder, WeeklySetting> {
    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DayOfWeek").getter(getter(WeeklySetting::dayOfWeekAsString)).setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()).build();

    private static final SdkField<HandOffTime> HAND_OFF_TIME_FIELD = SdkField.<HandOffTime> builder(MarshallingType.SDK_POJO)
            .memberName("HandOffTime").getter(getter(WeeklySetting::handOffTime)).setter(setter(Builder::handOffTime))
            .constructor(HandOffTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HandOffTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_OF_WEEK_FIELD,
            HAND_OFF_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dayOfWeek;

    private final HandOffTime handOffTime;

    private WeeklySetting(BuilderImpl builder) {
        this.dayOfWeek = builder.dayOfWeek;
        this.handOffTime = builder.handOffTime;
    }

    /**
     * <p>
     * The day of the week when weekly recurring on-call shift rotations begins.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of the week when weekly recurring on-call shift rotations begins.
     * @see DayOfWeek
     */
    public final DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(dayOfWeek);
    }

    /**
     * <p>
     * The day of the week when weekly recurring on-call shift rotations begins.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of the week when weekly recurring on-call shift rotations begins.
     * @see DayOfWeek
     */
    public final String dayOfWeekAsString() {
        return dayOfWeek;
    }

    /**
     * <p>
     * The time of day when a weekly recurring on-call shift rotation begins.
     * </p>
     * 
     * @return The time of day when a weekly recurring on-call shift rotation begins.
     */
    public final HandOffTime handOffTime() {
        return handOffTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(handOffTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklySetting)) {
            return false;
        }
        WeeklySetting other = (WeeklySetting) obj;
        return Objects.equals(dayOfWeekAsString(), other.dayOfWeekAsString())
                && Objects.equals(handOffTime(), other.handOffTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WeeklySetting").add("DayOfWeek", dayOfWeekAsString()).add("HandOffTime", handOffTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeekAsString()));
        case "HandOffTime":
            return Optional.ofNullable(clazz.cast(handOffTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WeeklySetting, T> g) {
        return obj -> g.apply((WeeklySetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WeeklySetting> {
        /**
         * <p>
         * The day of the week when weekly recurring on-call shift rotations begins.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week when weekly recurring on-call shift rotations begins.
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(String dayOfWeek);

        /**
         * <p>
         * The day of the week when weekly recurring on-call shift rotations begins.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week when weekly recurring on-call shift rotations begins.
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(DayOfWeek dayOfWeek);

        /**
         * <p>
         * The time of day when a weekly recurring on-call shift rotation begins.
         * </p>
         * 
         * @param handOffTime
         *        The time of day when a weekly recurring on-call shift rotation begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handOffTime(HandOffTime handOffTime);

        /**
         * <p>
         * The time of day when a weekly recurring on-call shift rotation begins.
         * </p>
         * This is a convenience method that creates an instance of the {@link HandOffTime.Builder} avoiding the need to
         * create one manually via {@link HandOffTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HandOffTime.Builder#build()} is called immediately and its result
         * is passed to {@link #handOffTime(HandOffTime)}.
         * 
         * @param handOffTime
         *        a consumer that will call methods on {@link HandOffTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #handOffTime(HandOffTime)
         */
        default Builder handOffTime(Consumer<HandOffTime.Builder> handOffTime) {
            return handOffTime(HandOffTime.builder().applyMutation(handOffTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dayOfWeek;

        private HandOffTime handOffTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WeeklySetting model) {
            dayOfWeek(model.dayOfWeek);
            handOffTime(model.handOffTime);
        }

        public final String getDayOfWeek() {
            return dayOfWeek;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek == null ? null : dayOfWeek.toString());
            return this;
        }

        public final HandOffTime.Builder getHandOffTime() {
            return handOffTime != null ? handOffTime.toBuilder() : null;
        }

        public final void setHandOffTime(HandOffTime.BuilderImpl handOffTime) {
            this.handOffTime = handOffTime != null ? handOffTime.build() : null;
        }

        @Override
        public final Builder handOffTime(HandOffTime handOffTime) {
            this.handOffTime = handOffTime;
            return this;
        }

        @Override
        public WeeklySetting build() {
            return new WeeklySetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
