/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContactRequest extends SsmContactsRequest implements
        ToCopyableBuilder<UpdateContactRequest.Builder, UpdateContactRequest> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(UpdateContactRequest::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateContactRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<Plan> PLAN_FIELD = SdkField.<Plan> builder(MarshallingType.SDK_POJO).memberName("Plan")
            .getter(getter(UpdateContactRequest::plan)).setter(setter(Builder::plan)).constructor(Plan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Plan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            DISPLAY_NAME_FIELD, PLAN_FIELD));

    private final String contactId;

    private final String displayName;

    private final Plan plan;

    private UpdateContactRequest(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.displayName = builder.displayName;
        this.plan = builder.plan;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The full name of the contact or escalation plan.
     * </p>
     * 
     * @return The full name of the contact or escalation plan.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A list of stages. A contact has an engagement plan with stages for specified contact channels. An escalation plan
     * uses these stages to contact specified contacts.
     * </p>
     * 
     * @return A list of stages. A contact has an engagement plan with stages for specified contact channels. An
     *         escalation plan uses these stages to contact specified contacts.
     */
    public final Plan plan() {
        return plan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(plan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactRequest)) {
            return false;
        }
        UpdateContactRequest other = (UpdateContactRequest) obj;
        return Objects.equals(contactId(), other.contactId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(plan(), other.plan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContactRequest").add("ContactId", contactId()).add("DisplayName", displayName())
                .add("Plan", plan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Plan":
            return Optional.ofNullable(clazz.cast(plan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactRequest, T> g) {
        return obj -> g.apply((UpdateContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContactRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.
         * </p>
         * 
         * @param contactId
         *        The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The full name of the contact or escalation plan.
         * </p>
         * 
         * @param displayName
         *        The full name of the contact or escalation plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A list of stages. A contact has an engagement plan with stages for specified contact channels. An escalation
         * plan uses these stages to contact specified contacts.
         * </p>
         * 
         * @param plan
         *        A list of stages. A contact has an engagement plan with stages for specified contact channels. An
         *        escalation plan uses these stages to contact specified contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plan(Plan plan);

        /**
         * <p>
         * A list of stages. A contact has an engagement plan with stages for specified contact channels. An escalation
         * plan uses these stages to contact specified contacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link Plan.Builder} avoiding the need to create
         * one manually via {@link Plan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Plan.Builder#build()} is called immediately and its result is
         * passed to {@link #plan(Plan)}.
         * 
         * @param plan
         *        a consumer that will call methods on {@link Plan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #plan(Plan)
         */
        default Builder plan(Consumer<Plan.Builder> plan) {
            return plan(Plan.builder().applyMutation(plan).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String contactId;

        private String displayName;

        private Plan plan;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactRequest model) {
            super(model);
            contactId(model.contactId);
            displayName(model.displayName);
            plan(model.plan);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Plan.Builder getPlan() {
            return plan != null ? plan.toBuilder() : null;
        }

        public final void setPlan(Plan.BuilderImpl plan) {
            this.plan = plan != null ? plan.build() : null;
        }

        @Override
        public final Builder plan(Plan plan) {
            this.plan = plan;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactRequest build() {
            return new UpdateContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
