/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.Receipt;

public class ListPageReceiptsIterable
implements SdkIterable<ListPageReceiptsResponse> {
    private final SsmContactsClient client;
    private final ListPageReceiptsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPageReceiptsIterable(SsmContactsClient client, ListPageReceiptsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPageReceiptsResponseFetcher();
    }

    public Iterator<ListPageReceiptsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Receipt> receipts() {
        Function<ListPageReceiptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.receipts() != null) {
                return response.receipts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPageReceiptsResponseFetcher
    implements SyncPageFetcher<ListPageReceiptsResponse> {
        private ListPageReceiptsResponseFetcher() {
        }

        public boolean hasNextPage(ListPageReceiptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPageReceiptsResponse nextPage(ListPageReceiptsResponse previousPage) {
            if (previousPage == null) {
                return ListPageReceiptsIterable.this.client.listPageReceipts(ListPageReceiptsIterable.this.firstRequest);
            }
            return ListPageReceiptsIterable.this.client.listPageReceipts((ListPageReceiptsRequest)((Object)ListPageReceiptsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

