/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncOrganizationalUnit;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncOrganizationalUnitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDataSyncAwsOrganizationsSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDataSyncAwsOrganizationsSource> {
    private static final SdkField<String> ORGANIZATION_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationSourceType").getter(ResourceDataSyncAwsOrganizationsSource.getter(ResourceDataSyncAwsOrganizationsSource::organizationSourceType)).setter(ResourceDataSyncAwsOrganizationsSource.setter(Builder::organizationSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationSourceType").build()}).build();
    private static final SdkField<List<ResourceDataSyncOrganizationalUnit>> ORGANIZATIONAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationalUnits").getter(ResourceDataSyncAwsOrganizationsSource.getter(ResourceDataSyncAwsOrganizationsSource::organizationalUnits)).setter(ResourceDataSyncAwsOrganizationsSource.setter(Builder::organizationalUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceDataSyncOrganizationalUnit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_SOURCE_TYPE_FIELD, ORGANIZATIONAL_UNITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String organizationSourceType;
    private final List<ResourceDataSyncOrganizationalUnit> organizationalUnits;

    private ResourceDataSyncAwsOrganizationsSource(BuilderImpl builder) {
        this.organizationSourceType = builder.organizationSourceType;
        this.organizationalUnits = builder.organizationalUnits;
    }

    public final String organizationSourceType() {
        return this.organizationSourceType;
    }

    public final boolean hasOrganizationalUnits() {
        return this.organizationalUnits != null && !(this.organizationalUnits instanceof SdkAutoConstructList);
    }

    public final List<ResourceDataSyncOrganizationalUnit> organizationalUnits() {
        return this.organizationalUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationSourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnits() ? this.organizationalUnits() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDataSyncAwsOrganizationsSource)) {
            return false;
        }
        ResourceDataSyncAwsOrganizationsSource other = (ResourceDataSyncAwsOrganizationsSource)obj;
        return Objects.equals(this.organizationSourceType(), other.organizationSourceType()) && this.hasOrganizationalUnits() == other.hasOrganizationalUnits() && Objects.equals(this.organizationalUnits(), other.organizationalUnits());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceDataSyncAwsOrganizationsSource").add("OrganizationSourceType", (Object)this.organizationSourceType()).add("OrganizationalUnits", this.hasOrganizationalUnits() ? this.organizationalUnits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationSourceType": {
                return Optional.ofNullable(clazz.cast(this.organizationSourceType()));
            }
            case "OrganizationalUnits": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDataSyncAwsOrganizationsSource, T> g) {
        return obj -> g.apply((ResourceDataSyncAwsOrganizationsSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String organizationSourceType;
        private List<ResourceDataSyncOrganizationalUnit> organizationalUnits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataSyncAwsOrganizationsSource model) {
            this.organizationSourceType(model.organizationSourceType);
            this.organizationalUnits(model.organizationalUnits);
        }

        public final String getOrganizationSourceType() {
            return this.organizationSourceType;
        }

        public final void setOrganizationSourceType(String organizationSourceType) {
            this.organizationSourceType = organizationSourceType;
        }

        @Override
        public final Builder organizationSourceType(String organizationSourceType) {
            this.organizationSourceType = organizationSourceType;
            return this;
        }

        public final List<ResourceDataSyncOrganizationalUnit.Builder> getOrganizationalUnits() {
            List<ResourceDataSyncOrganizationalUnit.Builder> result = ResourceDataSyncOrganizationalUnitListCopier.copyToBuilder(this.organizationalUnits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationalUnits(Collection<ResourceDataSyncOrganizationalUnit.BuilderImpl> organizationalUnits) {
            this.organizationalUnits = ResourceDataSyncOrganizationalUnitListCopier.copyFromBuilder(organizationalUnits);
        }

        @Override
        public final Builder organizationalUnits(Collection<ResourceDataSyncOrganizationalUnit> organizationalUnits) {
            this.organizationalUnits = ResourceDataSyncOrganizationalUnitListCopier.copy(organizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(ResourceDataSyncOrganizationalUnit ... organizationalUnits) {
            this.organizationalUnits(Arrays.asList(organizationalUnits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(Consumer<ResourceDataSyncOrganizationalUnit.Builder> ... organizationalUnits) {
            this.organizationalUnits(Stream.of(organizationalUnits).map(c -> (ResourceDataSyncOrganizationalUnit)((ResourceDataSyncOrganizationalUnit.Builder)ResourceDataSyncOrganizationalUnit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResourceDataSyncAwsOrganizationsSource build() {
            return new ResourceDataSyncAwsOrganizationsSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDataSyncAwsOrganizationsSource> {
        public Builder organizationSourceType(String var1);

        public Builder organizationalUnits(Collection<ResourceDataSyncOrganizationalUnit> var1);

        public Builder organizationalUnits(ResourceDataSyncOrganizationalUnit ... var1);

        public Builder organizationalUnits(Consumer<ResourceDataSyncOrganizationalUnit.Builder> ... var1);
    }
}

