/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request caused OpsItems to exceed one or more quotas.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpsItemLimitExceededException extends SsmException implements
        ToCopyableBuilder<OpsItemLimitExceededException.Builder, OpsItemLimitExceededException> {
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(OpsItemLimitExceededException::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(OpsItemLimitExceededException::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> LIMIT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LimitType").getter(getter(OpsItemLimitExceededException::limitType)).setter(setter(Builder::limitType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPES_FIELD,
            LIMIT_FIELD, LIMIT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> resourceTypes;

    private final Integer limit;

    private final String limitType;

    private OpsItemLimitExceededException(BuilderImpl builder) {
        super(builder);
        this.resourceTypes = builder.resourceTypes;
        this.limit = builder.limit;
        this.limitType = builder.limitType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ResourceTypes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The value of the ResourceTypes property for this object.
     */
    public List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * Returns the value of the Limit property for this object.
     * 
     * @return The value of the Limit property for this object.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * Returns the value of the LimitType property for this object.
     * 
     * @return The value of the LimitType property for this object.
     */
    public String limitType() {
        return limitType;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpsItemLimitExceededException, T> g) {
        return obj -> g.apply((OpsItemLimitExceededException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpsItemLimitExceededException>, SsmException.Builder {
        /**
         * Sets the value of the ResourceTypes property for this object.
         *
         * @param resourceTypes
         *        The new value for the ResourceTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * Sets the value of the ResourceTypes property for this object.
         *
         * @param resourceTypes
         *        The new value for the ResourceTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * Sets the value of the Limit property for this object.
         *
         * @param limit
         *        The new value for the Limit property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * Sets the value of the LimitType property for this object.
         *
         * @param limitType
         *        The new value for the LimitType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitType(String limitType);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends SsmException.BuilderImpl implements Builder {
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String limitType;

        private BuilderImpl() {
        }

        private BuilderImpl(OpsItemLimitExceededException model) {
            super(model);
            resourceTypes(model.resourceTypes);
            limit(model.limit);
            limitType(model.limitType);
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = OpsItemParameterNamesListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = OpsItemParameterNamesListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getLimitType() {
            return limitType;
        }

        public final void setLimitType(String limitType) {
            this.limitType = limitType;
        }

        @Override
        public final Builder limitType(String limitType) {
            this.limitType = limitType;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public OpsItemLimitExceededException build() {
            return new OpsItemLimitExceededException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
