/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource policy helps you to define the IAM entity (for example, an Amazon Web Services account) that can manage
 * your Systems Manager resources. Currently, <code>OpsItemGroup</code> is the only resource that supports Systems
 * Manager resource policies. The resource policy for <code>OpsItemGroup</code> enables Amazon Web Services accounts to
 * view and interact with OpsCenter operational work items (OpsItems).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcePoliciesResponseEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<GetResourcePoliciesResponseEntry.Builder, GetResourcePoliciesResponseEntry> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(GetResourcePoliciesResponseEntry::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> POLICY_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyHash").getter(getter(GetResourcePoliciesResponseEntry::policyHash))
            .setter(setter(Builder::policyHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyHash").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Policy")
            .getter(getter(GetResourcePoliciesResponseEntry::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            POLICY_HASH_FIELD, POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyId;

    private final String policyHash;

    private final String policy;

    private GetResourcePoliciesResponseEntry(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.policyHash = builder.policyHash;
        this.policy = builder.policy;
    }

    /**
     * <p>
     * A policy ID.
     * </p>
     * 
     * @return A policy ID.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * ID of the current policy version. The hash helps to prevent a situation where multiple users attempt to overwrite
     * a policy. You must provide this hash when updating or deleting a policy.
     * </p>
     * 
     * @return ID of the current policy version. The hash helps to prevent a situation where multiple users attempt to
     *         overwrite a policy. You must provide this hash when updating or deleting a policy.
     */
    public final String policyHash() {
        return policyHash;
    }

    /**
     * <p>
     * A resource policy helps you to define the IAM entity (for example, an Amazon Web Services account) that can
     * manage your Systems Manager resources. Currently, <code>OpsItemGroup</code> is the only resource that supports
     * Systems Manager resource policies. The resource policy for <code>OpsItemGroup</code> enables Amazon Web Services
     * accounts to view and interact with OpsCenter operational work items (OpsItems).
     * </p>
     * 
     * @return A resource policy helps you to define the IAM entity (for example, an Amazon Web Services account) that
     *         can manage your Systems Manager resources. Currently, <code>OpsItemGroup</code> is the only resource that
     *         supports Systems Manager resource policies. The resource policy for <code>OpsItemGroup</code> enables
     *         Amazon Web Services accounts to view and interact with OpsCenter operational work items (OpsItems).
     */
    public final String policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(policyHash());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePoliciesResponseEntry)) {
            return false;
        }
        GetResourcePoliciesResponseEntry other = (GetResourcePoliciesResponseEntry) obj;
        return Objects.equals(policyId(), other.policyId()) && Objects.equals(policyHash(), other.policyHash())
                && Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourcePoliciesResponseEntry").add("PolicyId", policyId()).add("PolicyHash", policyHash())
                .add("Policy", policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "PolicyHash":
            return Optional.ofNullable(clazz.cast(policyHash()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcePoliciesResponseEntry, T> g) {
        return obj -> g.apply((GetResourcePoliciesResponseEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetResourcePoliciesResponseEntry> {
        /**
         * <p>
         * A policy ID.
         * </p>
         * 
         * @param policyId
         *        A policy ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * ID of the current policy version. The hash helps to prevent a situation where multiple users attempt to
         * overwrite a policy. You must provide this hash when updating or deleting a policy.
         * </p>
         * 
         * @param policyHash
         *        ID of the current policy version. The hash helps to prevent a situation where multiple users attempt
         *        to overwrite a policy. You must provide this hash when updating or deleting a policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyHash(String policyHash);

        /**
         * <p>
         * A resource policy helps you to define the IAM entity (for example, an Amazon Web Services account) that can
         * manage your Systems Manager resources. Currently, <code>OpsItemGroup</code> is the only resource that
         * supports Systems Manager resource policies. The resource policy for <code>OpsItemGroup</code> enables Amazon
         * Web Services accounts to view and interact with OpsCenter operational work items (OpsItems).
         * </p>
         * 
         * @param policy
         *        A resource policy helps you to define the IAM entity (for example, an Amazon Web Services account)
         *        that can manage your Systems Manager resources. Currently, <code>OpsItemGroup</code> is the only
         *        resource that supports Systems Manager resource policies. The resource policy for
         *        <code>OpsItemGroup</code> enables Amazon Web Services accounts to view and interact with OpsCenter
         *        operational work items (OpsItems).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);
    }

    static final class BuilderImpl implements Builder {
        private String policyId;

        private String policyHash;

        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePoliciesResponseEntry model) {
            policyId(model.policyId);
            policyHash(model.policyHash);
            policy(model.policy);
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getPolicyHash() {
            return policyHash;
        }

        public final void setPolicyHash(String policyHash) {
            this.policyHash = policyHash;
        }

        @Override
        public final Builder policyHash(String policyHash) {
            this.policyHash = policyHash;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public GetResourcePoliciesResponseEntry build() {
            return new GetResourcePoliciesResponseEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
