/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssociationVersionsResponse extends SsmResponse implements
        ToCopyableBuilder<ListAssociationVersionsResponse.Builder, ListAssociationVersionsResponse> {
    private static final SdkField<List<AssociationVersionInfo>> ASSOCIATION_VERSIONS_FIELD = SdkField
            .<List<AssociationVersionInfo>> builder(MarshallingType.LIST)
            .memberName("AssociationVersions")
            .getter(getter(ListAssociationVersionsResponse::associationVersions))
            .setter(setter(Builder::associationVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociationVersionInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociationVersionInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAssociationVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AssociationVersionInfo> associationVersions;

    private final String nextToken;

    private ListAssociationVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.associationVersions = builder.associationVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociationVersions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociationVersions() {
        return associationVersions != null && !(associationVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about all versions of the association for the specified association ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociationVersions} method.
     * </p>
     * 
     * @return Information about all versions of the association for the specified association ID.
     */
    public final List<AssociationVersionInfo> associationVersions() {
        return associationVersions;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociationVersions() ? associationVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationVersionsResponse)) {
            return false;
        }
        ListAssociationVersionsResponse other = (ListAssociationVersionsResponse) obj;
        return hasAssociationVersions() == other.hasAssociationVersions()
                && Objects.equals(associationVersions(), other.associationVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssociationVersionsResponse")
                .add("AssociationVersions", hasAssociationVersions() ? associationVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationVersions":
            return Optional.ofNullable(clazz.cast(associationVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociationVersionsResponse, T> g) {
        return obj -> g.apply((ListAssociationVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAssociationVersionsResponse> {
        /**
         * <p>
         * Information about all versions of the association for the specified association ID.
         * </p>
         * 
         * @param associationVersions
         *        Information about all versions of the association for the specified association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationVersions(Collection<AssociationVersionInfo> associationVersions);

        /**
         * <p>
         * Information about all versions of the association for the specified association ID.
         * </p>
         * 
         * @param associationVersions
         *        Information about all versions of the association for the specified association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationVersions(AssociationVersionInfo... associationVersions);

        /**
         * <p>
         * Information about all versions of the association for the specified association ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.AssociationVersionInfo.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssm.model.AssociationVersionInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.AssociationVersionInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #associationVersions(List<AssociationVersionInfo>)}.
         * 
         * @param associationVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.AssociationVersionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationVersions(java.util.Collection<AssociationVersionInfo>)
         */
        Builder associationVersions(Consumer<AssociationVersionInfo.Builder>... associationVersions);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<AssociationVersionInfo> associationVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociationVersionsResponse model) {
            super(model);
            associationVersions(model.associationVersions);
            nextToken(model.nextToken);
        }

        public final List<AssociationVersionInfo.Builder> getAssociationVersions() {
            List<AssociationVersionInfo.Builder> result = AssociationVersionListCopier.copyToBuilder(this.associationVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociationVersions(Collection<AssociationVersionInfo.BuilderImpl> associationVersions) {
            this.associationVersions = AssociationVersionListCopier.copyFromBuilder(associationVersions);
        }

        @Override
        public final Builder associationVersions(Collection<AssociationVersionInfo> associationVersions) {
            this.associationVersions = AssociationVersionListCopier.copy(associationVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationVersions(AssociationVersionInfo... associationVersions) {
            associationVersions(Arrays.asList(associationVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationVersions(Consumer<AssociationVersionInfo.Builder>... associationVersions) {
            associationVersions(Stream.of(associationVersions)
                    .map(c -> AssociationVersionInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssociationVersionsResponse build() {
            return new ListAssociationVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
