/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.InstanceAssociation;

public class DescribeEffectiveInstanceAssociationsIterable
implements SdkIterable<DescribeEffectiveInstanceAssociationsResponse> {
    private final SsmClient client;
    private final DescribeEffectiveInstanceAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEffectiveInstanceAssociationsIterable(SsmClient client, DescribeEffectiveInstanceAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEffectiveInstanceAssociationsResponseFetcher();
    }

    public Iterator<DescribeEffectiveInstanceAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceAssociation> associations() {
        Function<DescribeEffectiveInstanceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associations() != null) {
                return response.associations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEffectiveInstanceAssociationsResponseFetcher
    implements SyncPageFetcher<DescribeEffectiveInstanceAssociationsResponse> {
        private DescribeEffectiveInstanceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEffectiveInstanceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeEffectiveInstanceAssociationsResponse nextPage(DescribeEffectiveInstanceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEffectiveInstanceAssociationsIterable.this.client.describeEffectiveInstanceAssociations(DescribeEffectiveInstanceAssociationsIterable.this.firstRequest);
            }
            return DescribeEffectiveInstanceAssociationsIterable.this.client.describeEffectiveInstanceAssociations((DescribeEffectiveInstanceAssociationsRequest)((Object)DescribeEffectiveInstanceAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

