/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse;
import software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemSummary;

public class ListOpsItemRelatedItemsIterable
implements SdkIterable<ListOpsItemRelatedItemsResponse> {
    private final SsmClient client;
    private final ListOpsItemRelatedItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOpsItemRelatedItemsIterable(SsmClient client, ListOpsItemRelatedItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOpsItemRelatedItemsResponseFetcher();
    }

    public Iterator<ListOpsItemRelatedItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OpsItemRelatedItemSummary> summaries() {
        Function<ListOpsItemRelatedItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOpsItemRelatedItemsResponseFetcher
    implements SyncPageFetcher<ListOpsItemRelatedItemsResponse> {
        private ListOpsItemRelatedItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListOpsItemRelatedItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOpsItemRelatedItemsResponse nextPage(ListOpsItemRelatedItemsResponse previousPage) {
            if (previousPage == null) {
                return ListOpsItemRelatedItemsIterable.this.client.listOpsItemRelatedItems(ListOpsItemRelatedItemsIterable.this.firstRequest);
            }
            return ListOpsItemRelatedItemsIterable.this.client.listOpsItemRelatedItems((ListOpsItemRelatedItemsRequest)((Object)ListOpsItemRelatedItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

