/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class IdentifiableMessage<MessageT> {
    private final String id;
    private final MessageT message;

    public IdentifiableMessage(String id, MessageT message) {
        this.id = (String)Validate.notNull((Object)id, (String)"ID cannot be null", (Object[])new Object[0]);
        this.message = Validate.notNull(message, (String)"Message cannot be null", (Object[])new Object[0]);
    }

    public String id() {
        return this.id;
    }

    public MessageT message() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifiableMessage that = (IdentifiableMessage)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.message.equals(that.message);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.message.hashCode();
        return result;
    }
}

