/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sns.model.LanguageCodeString;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSmsSandboxPhoneNumberRequest
extends SnsRequest
implements ToCopyableBuilder<Builder, CreateSmsSandboxPhoneNumberRequest> {
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(CreateSmsSandboxPhoneNumberRequest.getter(CreateSmsSandboxPhoneNumberRequest::phoneNumber)).setter(CreateSmsSandboxPhoneNumberRequest.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(CreateSmsSandboxPhoneNumberRequest.getter(CreateSmsSandboxPhoneNumberRequest::languageCodeAsString)).setter(CreateSmsSandboxPhoneNumberRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_FIELD, LANGUAGE_CODE_FIELD));
    private final String phoneNumber;
    private final String languageCode;

    private CreateSmsSandboxPhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumber = builder.phoneNumber;
        this.languageCode = builder.languageCode;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final LanguageCodeString languageCode() {
        return LanguageCodeString.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSmsSandboxPhoneNumberRequest)) {
            return false;
        }
        CreateSmsSandboxPhoneNumberRequest other = (CreateSmsSandboxPhoneNumberRequest)((Object)obj);
        return Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSmsSandboxPhoneNumberRequest").add("PhoneNumber", (Object)(this.phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("LanguageCode", (Object)this.languageCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSmsSandboxPhoneNumberRequest, T> g) {
        return obj -> g.apply((CreateSmsSandboxPhoneNumberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsRequest.BuilderImpl
    implements Builder {
        private String phoneNumber;
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSmsSandboxPhoneNumberRequest model) {
            super(model);
            this.phoneNumber(model.phoneNumber);
            this.languageCode(model.languageCode);
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCodeString languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSmsSandboxPhoneNumberRequest build() {
            return new CreateSmsSandboxPhoneNumberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSmsSandboxPhoneNumberRequest> {
        public Builder phoneNumber(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCodeString var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

