/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TaskState {
    IN_PROGRESS("IN_PROGRESS"),
    CANCELED("CANCELED"),
    COMPLETED("COMPLETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TaskState> VALUE_MAP;
    private final String value;

    private TaskState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskState> knownValues() {
        EnumSet<TaskState> knownValues = EnumSet.allOf(TaskState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TaskState.class, TaskState::toString);
    }
}

