/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.snowdevicemanagement.SnowDeviceManagementAsyncClient;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.TaskSummary;

public class ListTasksPublisher
implements SdkPublisher<ListTasksResponse> {
    private final SnowDeviceManagementAsyncClient client;
    private final ListTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTasksPublisher(SnowDeviceManagementAsyncClient client, ListTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTasksPublisher(SnowDeviceManagementAsyncClient client, ListTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TaskSummary> tasks() {
        Function<ListTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTasksResponseFetcher
    implements AsyncPageFetcher<ListTasksResponse> {
        private ListTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTasksResponse> nextPage(ListTasksResponse previousPage) {
            if (previousPage == null) {
                return ListTasksPublisher.this.client.listTasks(ListTasksPublisher.this.firstRequest);
            }
            return ListTasksPublisher.this.client.listTasks((ListTasksRequest)((Object)ListTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

