/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the device configuration for an Snowcone job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowconeDeviceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowconeDeviceConfiguration.Builder, SnowconeDeviceConfiguration> {
    private static final SdkField<WirelessConnection> WIRELESS_CONNECTION_FIELD = SdkField
            .<WirelessConnection> builder(MarshallingType.SDK_POJO).memberName("WirelessConnection")
            .getter(getter(SnowconeDeviceConfiguration::wirelessConnection)).setter(setter(Builder::wirelessConnection))
            .constructor(WirelessConnection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessConnection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIRELESS_CONNECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final WirelessConnection wirelessConnection;

    private SnowconeDeviceConfiguration(BuilderImpl builder) {
        this.wirelessConnection = builder.wirelessConnection;
    }

    /**
     * <p>
     * Configures the wireless connection for the Snowcone device.
     * </p>
     * 
     * @return Configures the wireless connection for the Snowcone device.
     */
    public final WirelessConnection wirelessConnection() {
        return wirelessConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wirelessConnection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowconeDeviceConfiguration)) {
            return false;
        }
        SnowconeDeviceConfiguration other = (SnowconeDeviceConfiguration) obj;
        return Objects.equals(wirelessConnection(), other.wirelessConnection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowconeDeviceConfiguration").add("WirelessConnection", wirelessConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WirelessConnection":
            return Optional.ofNullable(clazz.cast(wirelessConnection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnowconeDeviceConfiguration, T> g) {
        return obj -> g.apply((SnowconeDeviceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowconeDeviceConfiguration> {
        /**
         * <p>
         * Configures the wireless connection for the Snowcone device.
         * </p>
         * 
         * @param wirelessConnection
         *        Configures the wireless connection for the Snowcone device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessConnection(WirelessConnection wirelessConnection);

        /**
         * <p>
         * Configures the wireless connection for the Snowcone device.
         * </p>
         * This is a convenience method that creates an instance of the {@link WirelessConnection.Builder} avoiding the
         * need to create one manually via {@link WirelessConnection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WirelessConnection.Builder#build()} is called immediately and its
         * result is passed to {@link #wirelessConnection(WirelessConnection)}.
         * 
         * @param wirelessConnection
         *        a consumer that will call methods on {@link WirelessConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wirelessConnection(WirelessConnection)
         */
        default Builder wirelessConnection(Consumer<WirelessConnection.Builder> wirelessConnection) {
            return wirelessConnection(WirelessConnection.builder().applyMutation(wirelessConnection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WirelessConnection wirelessConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowconeDeviceConfiguration model) {
            wirelessConnection(model.wirelessConnection);
        }

        public final WirelessConnection.Builder getWirelessConnection() {
            return wirelessConnection != null ? wirelessConnection.toBuilder() : null;
        }

        public final void setWirelessConnection(WirelessConnection.BuilderImpl wirelessConnection) {
            this.wirelessConnection = wirelessConnection != null ? wirelessConnection.build() : null;
        }

        @Override
        public final Builder wirelessConnection(WirelessConnection wirelessConnection) {
            this.wirelessConnection = wirelessConnection;
            return this;
        }

        @Override
        public SnowconeDeviceConfiguration build() {
            return new SnowconeDeviceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
