/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.snowball.SnowballClient;
import software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest;
import software.amazon.awssdk.services.snowball.model.ListLongTermPricingResponse;
import software.amazon.awssdk.services.snowball.model.LongTermPricingListEntry;

public class ListLongTermPricingIterable
implements SdkIterable<ListLongTermPricingResponse> {
    private final SnowballClient client;
    private final ListLongTermPricingRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLongTermPricingIterable(SnowballClient client, ListLongTermPricingRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLongTermPricingResponseFetcher();
    }

    public Iterator<ListLongTermPricingResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LongTermPricingListEntry> longTermPricingEntries() {
        Function<ListLongTermPricingResponse, Iterator> getIterator = response -> {
            if (response != null && response.longTermPricingEntries() != null) {
                return response.longTermPricingEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLongTermPricingResponseFetcher
    implements SyncPageFetcher<ListLongTermPricingResponse> {
        private ListLongTermPricingResponseFetcher() {
        }

        public boolean hasNextPage(ListLongTermPricingResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLongTermPricingResponse nextPage(ListLongTermPricingResponse previousPage) {
            if (previousPage == null) {
                return ListLongTermPricingIterable.this.client.listLongTermPricing(ListLongTermPricingIterable.this.firstRequest);
            }
            return ListLongTermPricingIterable.this.client.listLongTermPricing((ListLongTermPricingRequest)((Object)ListLongTermPricingIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

