/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.NFSOnDeviceServiceConfiguration;
import software.amazon.awssdk.services.snowball.model.TGWOnDeviceServiceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OnDeviceServiceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OnDeviceServiceConfiguration> {
    private static final SdkField<NFSOnDeviceServiceConfiguration> NFS_ON_DEVICE_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NFSOnDeviceService").getter(OnDeviceServiceConfiguration.getter(OnDeviceServiceConfiguration::nfsOnDeviceService)).setter(OnDeviceServiceConfiguration.setter(Builder::nfsOnDeviceService)).constructor(NFSOnDeviceServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFSOnDeviceService").build()}).build();
    private static final SdkField<TGWOnDeviceServiceConfiguration> TGW_ON_DEVICE_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TGWOnDeviceService").getter(OnDeviceServiceConfiguration.getter(OnDeviceServiceConfiguration::tgwOnDeviceService)).setter(OnDeviceServiceConfiguration.setter(Builder::tgwOnDeviceService)).constructor(TGWOnDeviceServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TGWOnDeviceService").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NFS_ON_DEVICE_SERVICE_FIELD, TGW_ON_DEVICE_SERVICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final NFSOnDeviceServiceConfiguration nfsOnDeviceService;
    private final TGWOnDeviceServiceConfiguration tgwOnDeviceService;

    private OnDeviceServiceConfiguration(BuilderImpl builder) {
        this.nfsOnDeviceService = builder.nfsOnDeviceService;
        this.tgwOnDeviceService = builder.tgwOnDeviceService;
    }

    public final NFSOnDeviceServiceConfiguration nfsOnDeviceService() {
        return this.nfsOnDeviceService;
    }

    public final TGWOnDeviceServiceConfiguration tgwOnDeviceService() {
        return this.tgwOnDeviceService;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nfsOnDeviceService());
        hashCode = 31 * hashCode + Objects.hashCode(this.tgwOnDeviceService());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDeviceServiceConfiguration)) {
            return false;
        }
        OnDeviceServiceConfiguration other = (OnDeviceServiceConfiguration)obj;
        return Objects.equals(this.nfsOnDeviceService(), other.nfsOnDeviceService()) && Objects.equals(this.tgwOnDeviceService(), other.tgwOnDeviceService());
    }

    public final String toString() {
        return ToString.builder((String)"OnDeviceServiceConfiguration").add("NFSOnDeviceService", (Object)this.nfsOnDeviceService()).add("TGWOnDeviceService", (Object)this.tgwOnDeviceService()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NFSOnDeviceService": {
                return Optional.ofNullable(clazz.cast(this.nfsOnDeviceService()));
            }
            case "TGWOnDeviceService": {
                return Optional.ofNullable(clazz.cast(this.tgwOnDeviceService()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnDeviceServiceConfiguration, T> g) {
        return obj -> g.apply((OnDeviceServiceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NFSOnDeviceServiceConfiguration nfsOnDeviceService;
        private TGWOnDeviceServiceConfiguration tgwOnDeviceService;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDeviceServiceConfiguration model) {
            this.nfsOnDeviceService(model.nfsOnDeviceService);
            this.tgwOnDeviceService(model.tgwOnDeviceService);
        }

        public final NFSOnDeviceServiceConfiguration.Builder getNfsOnDeviceService() {
            return this.nfsOnDeviceService != null ? this.nfsOnDeviceService.toBuilder() : null;
        }

        public final void setNfsOnDeviceService(NFSOnDeviceServiceConfiguration.BuilderImpl nfsOnDeviceService) {
            this.nfsOnDeviceService = nfsOnDeviceService != null ? nfsOnDeviceService.build() : null;
        }

        @Override
        public final Builder nfsOnDeviceService(NFSOnDeviceServiceConfiguration nfsOnDeviceService) {
            this.nfsOnDeviceService = nfsOnDeviceService;
            return this;
        }

        public final TGWOnDeviceServiceConfiguration.Builder getTgwOnDeviceService() {
            return this.tgwOnDeviceService != null ? this.tgwOnDeviceService.toBuilder() : null;
        }

        public final void setTgwOnDeviceService(TGWOnDeviceServiceConfiguration.BuilderImpl tgwOnDeviceService) {
            this.tgwOnDeviceService = tgwOnDeviceService != null ? tgwOnDeviceService.build() : null;
        }

        @Override
        public final Builder tgwOnDeviceService(TGWOnDeviceServiceConfiguration tgwOnDeviceService) {
            this.tgwOnDeviceService = tgwOnDeviceService;
            return this;
        }

        public OnDeviceServiceConfiguration build() {
            return new OnDeviceServiceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OnDeviceServiceConfiguration> {
        public Builder nfsOnDeviceService(NFSOnDeviceServiceConfiguration var1);

        default public Builder nfsOnDeviceService(Consumer<NFSOnDeviceServiceConfiguration.Builder> nfsOnDeviceService) {
            return this.nfsOnDeviceService((NFSOnDeviceServiceConfiguration)((NFSOnDeviceServiceConfiguration.Builder)NFSOnDeviceServiceConfiguration.builder().applyMutation(nfsOnDeviceService)).build());
        }

        public Builder tgwOnDeviceService(TGWOnDeviceServiceConfiguration var1);

        default public Builder tgwOnDeviceService(Consumer<TGWOnDeviceServiceConfiguration.Builder> tgwOnDeviceService) {
            return this.tgwOnDeviceService((TGWOnDeviceServiceConfiguration)((TGWOnDeviceServiceConfiguration.Builder)TGWOnDeviceServiceConfiguration.builder().applyMutation(tgwOnDeviceService)).build());
        }
    }
}

