/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectorCapability {
    VSPHERE("VSPHERE"),
    SCVMM("SCVMM"),
    HYPERV_MANAGER("HYPERV-MANAGER"),
    SNAPSHOT_BATCHING("SNAPSHOT_BATCHING"),
    SMS_OPTIMIZED("SMS_OPTIMIZED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectorCapability> VALUE_MAP;
    private final String value;

    private ConnectorCapability(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorCapability fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorCapability> knownValues() {
        EnumSet<ConnectorCapability> knownValues = EnumSet.allOf(ConnectorCapability.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectorCapability.class, ConnectorCapability::toString);
    }
}

