/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of additional state information, such as domain and clock configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LiveSimulationState implements SdkPojo, Serializable,
        ToCopyableBuilder<LiveSimulationState.Builder, LiveSimulationState> {
    private static final SdkField<List<SimulationClock>> CLOCKS_FIELD = SdkField
            .<List<SimulationClock>> builder(MarshallingType.LIST)
            .memberName("Clocks")
            .getter(getter(LiveSimulationState::clocks))
            .setter(setter(Builder::clocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Clocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimulationClock> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimulationClock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Domain>> DOMAINS_FIELD = SdkField
            .<List<Domain>> builder(MarshallingType.LIST)
            .memberName("Domains")
            .getter(getter(LiveSimulationState::domains))
            .setter(setter(Builder::domains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Domain> builder(MarshallingType.SDK_POJO)
                                            .constructor(Domain::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOCKS_FIELD, DOMAINS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SimulationClock> clocks;

    private final List<Domain> domains;

    private LiveSimulationState(BuilderImpl builder) {
        this.clocks = builder.clocks;
        this.domains = builder.domains;
    }

    /**
     * For responses, this returns true if the service returned a value for the Clocks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClocks() {
        return clocks != null && !(clocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of simulation clocks.
     * </p>
     * <note>
     * <p>
     * At this time, a simulation has only one clock.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClocks} method.
     * </p>
     * 
     * @return A list of simulation clocks.</p> <note>
     *         <p>
     *         At this time, a simulation has only one clock.
     *         </p>
     */
    public final List<SimulationClock> clocks() {
        return clocks;
    }

    /**
     * For responses, this returns true if the service returned a value for the Domains property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDomains() {
        return domains != null && !(domains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of domains for the simulation. For more information about domains, see <a href=
     * "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains"
     * >Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomains} method.
     * </p>
     * 
     * @return A list of domains for the simulation. For more information about domains, see <a href=
     *         "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains"
     *         >Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.
     */
    public final List<Domain> domains() {
        return domains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasClocks() ? clocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDomains() ? domains() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveSimulationState)) {
            return false;
        }
        LiveSimulationState other = (LiveSimulationState) obj;
        return hasClocks() == other.hasClocks() && Objects.equals(clocks(), other.clocks()) && hasDomains() == other.hasDomains()
                && Objects.equals(domains(), other.domains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LiveSimulationState").add("Clocks", hasClocks() ? clocks() : null)
                .add("Domains", hasDomains() ? domains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Clocks":
            return Optional.ofNullable(clazz.cast(clocks()));
        case "Domains":
            return Optional.ofNullable(clazz.cast(domains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LiveSimulationState, T> g) {
        return obj -> g.apply((LiveSimulationState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LiveSimulationState> {
        /**
         * <p>
         * A list of simulation clocks.
         * </p>
         * <note>
         * <p>
         * At this time, a simulation has only one clock.
         * </p>
         * </note>
         * 
         * @param clocks
         *        A list of simulation clocks.</p> <note>
         *        <p>
         *        At this time, a simulation has only one clock.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clocks(Collection<SimulationClock> clocks);

        /**
         * <p>
         * A list of simulation clocks.
         * </p>
         * <note>
         * <p>
         * At this time, a simulation has only one clock.
         * </p>
         * </note>
         * 
         * @param clocks
         *        A list of simulation clocks.</p> <note>
         *        <p>
         *        At this time, a simulation has only one clock.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clocks(SimulationClock... clocks);

        /**
         * <p>
         * A list of simulation clocks.
         * </p>
         * <note>
         * <p>
         * At this time, a simulation has only one clock.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.simspaceweaver.model.SimulationClock.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.simspaceweaver.model.SimulationClock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.simspaceweaver.model.SimulationClock.Builder#build()} is called
         * immediately and its result is passed to {@link #clocks(List<SimulationClock>)}.
         * 
         * @param clocks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.simspaceweaver.model.SimulationClock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clocks(java.util.Collection<SimulationClock>)
         */
        Builder clocks(Consumer<SimulationClock.Builder>... clocks);

        /**
         * <p>
         * A list of domains for the simulation. For more information about domains, see <a href=
         * "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains"
         * >Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.
         * </p>
         * 
         * @param domains
         *        A list of domains for the simulation. For more information about domains, see <a href=
         *        "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains"
         *        >Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<Domain> domains);

        /**
         * <p>
         * A list of domains for the simulation. For more information about domains, see <a href=
         * "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains"
         * >Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.
         * </p>
         * 
         * @param domains
         *        A list of domains for the simulation. For more information about domains, see <a href=
         *        "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains"
         *        >Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Domain... domains);

        /**
         * <p>
         * A list of domains for the simulation. For more information about domains, see <a href=
         * "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains"
         * >Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.simspaceweaver.model.Domain.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.simspaceweaver.model.Domain#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.simspaceweaver.model.Domain.Builder#build()} is called immediately and
         * its result is passed to {@link #domains(List<Domain>)}.
         * 
         * @param domains
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.simspaceweaver.model.Domain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domains(java.util.Collection<Domain>)
         */
        Builder domains(Consumer<Domain.Builder>... domains);
    }

    static final class BuilderImpl implements Builder {
        private List<SimulationClock> clocks = DefaultSdkAutoConstructList.getInstance();

        private List<Domain> domains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LiveSimulationState model) {
            clocks(model.clocks);
            domains(model.domains);
        }

        public final List<SimulationClock.Builder> getClocks() {
            List<SimulationClock.Builder> result = SimulationClockListCopier.copyToBuilder(this.clocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClocks(Collection<SimulationClock.BuilderImpl> clocks) {
            this.clocks = SimulationClockListCopier.copyFromBuilder(clocks);
        }

        @Override
        public final Builder clocks(Collection<SimulationClock> clocks) {
            this.clocks = SimulationClockListCopier.copy(clocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clocks(SimulationClock... clocks) {
            clocks(Arrays.asList(clocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clocks(Consumer<SimulationClock.Builder>... clocks) {
            clocks(Stream.of(clocks).map(c -> SimulationClock.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Domain.Builder> getDomains() {
            List<Domain.Builder> result = DomainListCopier.copyToBuilder(this.domains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomains(Collection<Domain.BuilderImpl> domains) {
            this.domains = DomainListCopier.copyFromBuilder(domains);
        }

        @Override
        public final Builder domains(Collection<Domain> domains) {
            this.domains = DomainListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Domain... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Consumer<Domain.Builder>... domains) {
            domains(Stream.of(domains).map(c -> Domain.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public LiveSimulationState build() {
            return new LiveSimulationState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
