/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.simspaceweaver.DefaultSimSpaceWeaverBaseClientBuilder;
import software.amazon.awssdk.services.simspaceweaver.DefaultSimSpaceWeaverClient;
import software.amazon.awssdk.services.simspaceweaver.SimSpaceWeaverClient;
import software.amazon.awssdk.services.simspaceweaver.SimSpaceWeaverClientBuilder;
import software.amazon.awssdk.services.simspaceweaver.SimSpaceWeaverServiceClientConfiguration;
import software.amazon.awssdk.services.simspaceweaver.endpoints.SimSpaceWeaverEndpointProvider;

@SdkInternalApi
final class DefaultSimSpaceWeaverClientBuilder
extends DefaultSimSpaceWeaverBaseClientBuilder<SimSpaceWeaverClientBuilder, SimSpaceWeaverClient>
implements SimSpaceWeaverClientBuilder {
    DefaultSimSpaceWeaverClientBuilder() {
    }

    @Override
    public DefaultSimSpaceWeaverClientBuilder endpointProvider(SimSpaceWeaverEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SimSpaceWeaverClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSimSpaceWeaverClientBuilder.validateClientOptions(clientConfiguration);
        SimSpaceWeaverServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSimSpaceWeaverClient client = new DefaultSimSpaceWeaverClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SimSpaceWeaverServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SimSpaceWeaverServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

