/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignPayloadRequest extends SignerRequest implements
        ToCopyableBuilder<SignPayloadRequest.Builder, SignPayloadRequest> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileName").getter(getter(SignPayloadRequest::profileName)).setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileName").build()).build();

    private static final SdkField<String> PROFILE_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileOwner").getter(getter(SignPayloadRequest::profileOwner)).setter(setter(Builder::profileOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileOwner").build()).build();

    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("payload").getter(getter(SignPayloadRequest::payload)).setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final SdkField<String> PAYLOAD_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("payloadFormat").getter(getter(SignPayloadRequest::payloadFormat)).setter(setter(Builder::payloadFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD,
            PROFILE_OWNER_FIELD, PAYLOAD_FIELD, PAYLOAD_FORMAT_FIELD));

    private final String profileName;

    private final String profileOwner;

    private final SdkBytes payload;

    private final String payloadFormat;

    private SignPayloadRequest(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.profileOwner = builder.profileOwner;
        this.payload = builder.payload;
        this.payloadFormat = builder.payloadFormat;
    }

    /**
     * <p>
     * The name of the signing profile.
     * </p>
     * 
     * @return The name of the signing profile.
     */
    public final String profileName() {
        return profileName;
    }

    /**
     * <p>
     * The AWS account ID of the profile owner.
     * </p>
     * 
     * @return The AWS account ID of the profile owner.
     */
    public final String profileOwner() {
        return profileOwner;
    }

    /**
     * <p>
     * Specifies the object digest (hash) to sign.
     * </p>
     * 
     * @return Specifies the object digest (hash) to sign.
     */
    public final SdkBytes payload() {
        return payload;
    }

    /**
     * <p>
     * Payload content type
     * </p>
     * 
     * @return Payload content type
     */
    public final String payloadFormat() {
        return payloadFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(profileOwner());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(payloadFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignPayloadRequest)) {
            return false;
        }
        SignPayloadRequest other = (SignPayloadRequest) obj;
        return Objects.equals(profileName(), other.profileName()) && Objects.equals(profileOwner(), other.profileOwner())
                && Objects.equals(payload(), other.payload()) && Objects.equals(payloadFormat(), other.payloadFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignPayloadRequest").add("ProfileName", profileName()).add("ProfileOwner", profileOwner())
                .add("Payload", payload()).add("PayloadFormat", payloadFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "profileOwner":
            return Optional.ofNullable(clazz.cast(profileOwner()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "payloadFormat":
            return Optional.ofNullable(clazz.cast(payloadFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignPayloadRequest, T> g) {
        return obj -> g.apply((SignPayloadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SignerRequest.Builder, SdkPojo, CopyableBuilder<Builder, SignPayloadRequest> {
        /**
         * <p>
         * The name of the signing profile.
         * </p>
         * 
         * @param profileName
         *        The name of the signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * The AWS account ID of the profile owner.
         * </p>
         * 
         * @param profileOwner
         *        The AWS account ID of the profile owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileOwner(String profileOwner);

        /**
         * <p>
         * Specifies the object digest (hash) to sign.
         * </p>
         * 
         * @param payload
         *        Specifies the object digest (hash) to sign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(SdkBytes payload);

        /**
         * <p>
         * Payload content type
         * </p>
         * 
         * @param payloadFormat
         *        Payload content type
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadFormat(String payloadFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SignerRequest.BuilderImpl implements Builder {
        private String profileName;

        private String profileOwner;

        private SdkBytes payload;

        private String payloadFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(SignPayloadRequest model) {
            super(model);
            profileName(model.profileName);
            profileOwner(model.profileOwner);
            payload(model.payload);
            payloadFormat(model.payloadFormat);
        }

        public final String getProfileName() {
            return profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileOwner() {
            return profileOwner;
        }

        public final void setProfileOwner(String profileOwner) {
            this.profileOwner = profileOwner;
        }

        @Override
        public final Builder profileOwner(String profileOwner) {
            this.profileOwner = profileOwner;
            return this;
        }

        public final ByteBuffer getPayload() {
            return payload == null ? null : payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            payload(payload == null ? null : SdkBytes.fromByteBuffer(payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public final String getPayloadFormat() {
            return payloadFormat;
        }

        public final void setPayloadFormat(String payloadFormat) {
            this.payloadFormat = payloadFormat;
        }

        @Override
        public final Builder payloadFormat(String payloadFormat) {
            this.payloadFormat = payloadFormat;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SignPayloadRequest build() {
            return new SignPayloadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
