/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Limits settings by pattern type in the protection groups for your subscription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectionGroupPatternTypeLimits implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectionGroupPatternTypeLimits.Builder, ProtectionGroupPatternTypeLimits> {
    private static final SdkField<ProtectionGroupArbitraryPatternLimits> ARBITRARY_PATTERN_LIMITS_FIELD = SdkField
            .<ProtectionGroupArbitraryPatternLimits> builder(MarshallingType.SDK_POJO).memberName("ArbitraryPatternLimits")
            .getter(getter(ProtectionGroupPatternTypeLimits::arbitraryPatternLimits))
            .setter(setter(Builder::arbitraryPatternLimits)).constructor(ProtectionGroupArbitraryPatternLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArbitraryPatternLimits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ARBITRARY_PATTERN_LIMITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ProtectionGroupArbitraryPatternLimits arbitraryPatternLimits;

    private ProtectionGroupPatternTypeLimits(BuilderImpl builder) {
        this.arbitraryPatternLimits = builder.arbitraryPatternLimits;
    }

    /**
     * <p>
     * Limits settings on protection groups with arbitrary pattern type.
     * </p>
     * 
     * @return Limits settings on protection groups with arbitrary pattern type.
     */
    public final ProtectionGroupArbitraryPatternLimits arbitraryPatternLimits() {
        return arbitraryPatternLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arbitraryPatternLimits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectionGroupPatternTypeLimits)) {
            return false;
        }
        ProtectionGroupPatternTypeLimits other = (ProtectionGroupPatternTypeLimits) obj;
        return Objects.equals(arbitraryPatternLimits(), other.arbitraryPatternLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectionGroupPatternTypeLimits").add("ArbitraryPatternLimits", arbitraryPatternLimits())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArbitraryPatternLimits":
            return Optional.ofNullable(clazz.cast(arbitraryPatternLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectionGroupPatternTypeLimits, T> g) {
        return obj -> g.apply((ProtectionGroupPatternTypeLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectionGroupPatternTypeLimits> {
        /**
         * <p>
         * Limits settings on protection groups with arbitrary pattern type.
         * </p>
         * 
         * @param arbitraryPatternLimits
         *        Limits settings on protection groups with arbitrary pattern type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arbitraryPatternLimits(ProtectionGroupArbitraryPatternLimits arbitraryPatternLimits);

        /**
         * <p>
         * Limits settings on protection groups with arbitrary pattern type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProtectionGroupArbitraryPatternLimits.Builder} avoiding the need to create one manually via
         * {@link ProtectionGroupArbitraryPatternLimits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectionGroupArbitraryPatternLimits.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #arbitraryPatternLimits(ProtectionGroupArbitraryPatternLimits)}.
         * 
         * @param arbitraryPatternLimits
         *        a consumer that will call methods on {@link ProtectionGroupArbitraryPatternLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arbitraryPatternLimits(ProtectionGroupArbitraryPatternLimits)
         */
        default Builder arbitraryPatternLimits(Consumer<ProtectionGroupArbitraryPatternLimits.Builder> arbitraryPatternLimits) {
            return arbitraryPatternLimits(ProtectionGroupArbitraryPatternLimits.builder().applyMutation(arbitraryPatternLimits)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProtectionGroupArbitraryPatternLimits arbitraryPatternLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectionGroupPatternTypeLimits model) {
            arbitraryPatternLimits(model.arbitraryPatternLimits);
        }

        public final ProtectionGroupArbitraryPatternLimits.Builder getArbitraryPatternLimits() {
            return arbitraryPatternLimits != null ? arbitraryPatternLimits.toBuilder() : null;
        }

        public final void setArbitraryPatternLimits(ProtectionGroupArbitraryPatternLimits.BuilderImpl arbitraryPatternLimits) {
            this.arbitraryPatternLimits = arbitraryPatternLimits != null ? arbitraryPatternLimits.build() : null;
        }

        @Override
        public final Builder arbitraryPatternLimits(ProtectionGroupArbitraryPatternLimits arbitraryPatternLimits) {
            this.arbitraryPatternLimits = arbitraryPatternLimits;
            return this;
        }

        @Override
        public ProtectionGroupPatternTypeLimits build() {
            return new ProtectionGroupPatternTypeLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
