/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetActivityTaskResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, GetActivityTaskResponse> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskToken").getter(GetActivityTaskResponse.getter(GetActivityTaskResponse::taskToken)).setter(GetActivityTaskResponse.setter(Builder::taskToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()}).build();
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("input").getter(GetActivityTaskResponse.getter(GetActivityTaskResponse::input)).setter(GetActivityTaskResponse.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TOKEN_FIELD, INPUT_FIELD));
    private final String taskToken;
    private final String input;

    private GetActivityTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.input = builder.input;
    }

    public final String taskToken() {
        return this.taskToken;
    }

    public final String input() {
        return this.input;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetActivityTaskResponse)) {
            return false;
        }
        GetActivityTaskResponse other = (GetActivityTaskResponse)((Object)obj);
        return Objects.equals(this.taskToken(), other.taskToken()) && Objects.equals(this.input(), other.input());
    }

    public final String toString() {
        return ToString.builder((String)"GetActivityTaskResponse").add("TaskToken", (Object)this.taskToken()).add("Input", (Object)(this.input() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskToken": {
                return Optional.ofNullable(clazz.cast(this.taskToken()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetActivityTaskResponse, T> g) {
        return obj -> g.apply((GetActivityTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String taskToken;
        private String input;

        private BuilderImpl() {
        }

        private BuilderImpl(GetActivityTaskResponse model) {
            super(model);
            this.taskToken(model.taskToken);
            this.input(model.input);
        }

        public final String getTaskToken() {
            return this.taskToken;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final String getInput() {
            return this.input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        @Override
        public GetActivityTaskResponse build() {
            return new GetActivityTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetActivityTaskResponse> {
        public Builder taskToken(String var1);

        public Builder input(String var1);
    }
}

