/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.sesv2.model.AccountSuspendedException;
import software.amazon.awssdk.services.sesv2.model.AlreadyExistsException;
import software.amazon.awssdk.services.sesv2.model.BadRequestException;
import software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataRequest;
import software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataResponse;
import software.amazon.awssdk.services.sesv2.model.CancelExportJobRequest;
import software.amazon.awssdk.services.sesv2.model.CancelExportJobResponse;
import software.amazon.awssdk.services.sesv2.model.ConcurrentModificationException;
import software.amazon.awssdk.services.sesv2.model.ConflictException;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.CreateContactListRequest;
import software.amazon.awssdk.services.sesv2.model.CreateContactListResponse;
import software.amazon.awssdk.services.sesv2.model.CreateContactRequest;
import software.amazon.awssdk.services.sesv2.model.CreateContactResponse;
import software.amazon.awssdk.services.sesv2.model.CreateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.CreateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.CreateExportJobRequest;
import software.amazon.awssdk.services.sesv2.model.CreateExportJobResponse;
import software.amazon.awssdk.services.sesv2.model.CreateImportJobRequest;
import software.amazon.awssdk.services.sesv2.model.CreateImportJobResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteContactListRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteContactListResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteContactRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteContactResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.GetAccountRequest;
import software.amazon.awssdk.services.sesv2.model.GetAccountResponse;
import software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest;
import software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsResponse;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsResponse;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.GetContactListRequest;
import software.amazon.awssdk.services.sesv2.model.GetContactListResponse;
import software.amazon.awssdk.services.sesv2.model.GetContactRequest;
import software.amazon.awssdk.services.sesv2.model.GetContactResponse;
import software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest;
import software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignResponse;
import software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest;
import software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.GetExportJobRequest;
import software.amazon.awssdk.services.sesv2.model.GetExportJobResponse;
import software.amazon.awssdk.services.sesv2.model.GetImportJobRequest;
import software.amazon.awssdk.services.sesv2.model.GetImportJobResponse;
import software.amazon.awssdk.services.sesv2.model.GetMessageInsightsRequest;
import software.amazon.awssdk.services.sesv2.model.GetMessageInsightsResponse;
import software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.InternalServiceErrorException;
import software.amazon.awssdk.services.sesv2.model.InvalidNextTokenException;
import software.amazon.awssdk.services.sesv2.model.LimitExceededException;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.sesv2.model.ListContactListsRequest;
import software.amazon.awssdk.services.sesv2.model.ListContactListsResponse;
import software.amazon.awssdk.services.sesv2.model.ListContactsRequest;
import software.amazon.awssdk.services.sesv2.model.ListContactsResponse;
import software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest;
import software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse;
import software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse;
import software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest;
import software.amazon.awssdk.services.sesv2.model.ListExportJobsResponse;
import software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest;
import software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse;
import software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse;
import software.amazon.awssdk.services.sesv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sesv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sesv2.model.MailFromDomainNotVerifiedException;
import software.amazon.awssdk.services.sesv2.model.MessageRejectedException;
import software.amazon.awssdk.services.sesv2.model.NotFoundException;
import software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountDetailsRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountDetailsResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountVdmAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountVdmAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest;
import software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.SendBulkEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendBulkEmailResponse;
import software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailResponse;
import software.amazon.awssdk.services.sesv2.model.SendEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendEmailResponse;
import software.amazon.awssdk.services.sesv2.model.SendingPausedException;
import software.amazon.awssdk.services.sesv2.model.SesV2Exception;
import software.amazon.awssdk.services.sesv2.model.TagResourceRequest;
import software.amazon.awssdk.services.sesv2.model.TagResourceResponse;
import software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.TooManyRequestsException;
import software.amazon.awssdk.services.sesv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.sesv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateContactListRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateContactListResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateContactRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateContactResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateResponse;
import software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListContactListsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListContactsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListCustomVerificationEmailTemplatesIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListEmailTemplatesIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListExportJobsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListImportJobsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListRecommendationsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsIterable;

/**
 * Service client for accessing Amazon SES V2. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon SES API v2</fullname>
 * <p>
 * <a href="http://aws.amazon.com/ses">Amazon SES</a> is an Amazon Web Services service that you can use to send email
 * messages to your customers.
 * </p>
 * <p>
 * If you're new to Amazon SES API v2, you might find it helpful to review the <a
 * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/">Amazon Simple Email Service Developer Guide</a>. The
 * <i>Amazon SES Developer Guide</i> provides information and code samples that demonstrate how to use Amazon SES API v2
 * features programmatically.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SesV2Client extends AwsClient {
    String SERVICE_NAME = "ses";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "email";

    /**
     * <p>
     * Retrieves batches of metric data collected based on your sending activity.
     * </p>
     * <p>
     * You can execute this operation no more than 16 times per second, and with at most 160 queries from the batches
     * per second (cumulative).
     * </p>
     *
     * @param batchGetMetricDataRequest
     *        Represents a request to retrieve a batch of metric data.
     * @return Result of the BatchGetMetricData operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws InternalServiceErrorException
     *         The request couldn't be processed because an error occurred with the Amazon SES API v2.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.BatchGetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/BatchGetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetMetricDataResponse batchGetMetricData(BatchGetMetricDataRequest batchGetMetricDataRequest)
            throws BadRequestException, InternalServiceErrorException, TooManyRequestsException, NotFoundException,
            AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves batches of metric data collected based on your sending activity.
     * </p>
     * <p>
     * You can execute this operation no more than 16 times per second, and with at most 160 queries from the batches
     * per second (cumulative).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetMetricDataRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetMetricDataRequest#builder()}
     * </p>
     *
     * @param batchGetMetricDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataRequest.Builder} to create a request.
     *        Represents a request to retrieve a batch of metric data.
     * @return Result of the BatchGetMetricData operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws InternalServiceErrorException
     *         The request couldn't be processed because an error occurred with the Amazon SES API v2.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.BatchGetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/BatchGetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetMetricDataResponse batchGetMetricData(Consumer<BatchGetMetricDataRequest.Builder> batchGetMetricDataRequest)
            throws BadRequestException, InternalServiceErrorException, TooManyRequestsException, NotFoundException,
            AwsServiceException, SdkClientException, SesV2Exception {
        return batchGetMetricData(BatchGetMetricDataRequest.builder().applyMutation(batchGetMetricDataRequest).build());
    }

    /**
     * <p>
     * Cancels an export job.
     * </p>
     *
     * @param cancelExportJobRequest
     *        Represents a request to cancel an export job using the export job ID.
     * @return Result of the CancelExportJob operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CancelExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CancelExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelExportJobResponse cancelExportJob(CancelExportJobRequest cancelExportJobRequest) throws NotFoundException,
            BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelExportJobRequest.Builder} avoiding the need
     * to create one manually via {@link CancelExportJobRequest#builder()}
     * </p>
     *
     * @param cancelExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CancelExportJobRequest.Builder} to create a request.
     *        Represents a request to cancel an export job using the export job ID.
     * @return Result of the CancelExportJob operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CancelExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CancelExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelExportJobResponse cancelExportJob(Consumer<CancelExportJobRequest.Builder> cancelExportJobRequest)
            throws NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return cancelExportJob(CancelExportJobRequest.builder().applyMutation(cancelExportJobRequest).build());
    }

    /**
     * <p>
     * Create a configuration set. <i>Configuration sets</i> are groups of rules that you can apply to the emails that
     * you send. You apply a configuration set to an email by specifying the name of the configuration set when you call
     * the Amazon SES API v2. When you apply a configuration set to an email, all of the rules in that configuration set
     * are applied to the email.
     * </p>
     *
     * @param createConfigurationSetRequest
     *        A request to create a configuration set.
     * @return Result of the CreateConfigurationSet operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateConfigurationSetResponse createConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest)
            throws AlreadyExistsException, NotFoundException, TooManyRequestsException, LimitExceededException,
            BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a configuration set. <i>Configuration sets</i> are groups of rules that you can apply to the emails that
     * you send. You apply a configuration set to an email by specifying the name of the configuration set when you call
     * the Amazon SES API v2. When you apply a configuration set to an email, all of the rules in that configuration set
     * are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfigurationSetRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest.Builder} to create a
     *        request. A request to create a configuration set.
     * @return Result of the CreateConfigurationSet operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateConfigurationSetResponse createConfigurationSet(
            Consumer<CreateConfigurationSetRequest.Builder> createConfigurationSetRequest) throws AlreadyExistsException,
            NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        return createConfigurationSet(CreateConfigurationSetRequest.builder().applyMutation(createConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Create an event destination. <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and
     * complaints. <i>Event destinations</i> are places that you can send information about these events to. For
     * example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints,
     * or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     * <p>
     * A single configuration set can include more than one event destination.
     * </p>
     *
     * @param createConfigurationSetEventDestinationRequest
     *        A request to add an event destination to a configuration set.
     * @return Result of the CreateConfigurationSetEventDestination operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestination(
            CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest)
            throws NotFoundException, AlreadyExistsException, LimitExceededException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an event destination. <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and
     * complaints. <i>Event destinations</i> are places that you can send information about these events to. For
     * example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints,
     * or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     * <p>
     * A single configuration set can include more than one event destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. A request to add an event destination to a configuration set.
     * @return Result of the CreateConfigurationSetEventDestination operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestination(
            Consumer<CreateConfigurationSetEventDestinationRequest.Builder> createConfigurationSetEventDestinationRequest)
            throws NotFoundException, AlreadyExistsException, LimitExceededException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest.builder()
                .applyMutation(createConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Creates a contact, which is an end-user who is receiving the email, and adds them to a contact list.
     * </p>
     *
     * @param createContactRequest
     * @return Result of the CreateContact operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateContactResponse createContact(CreateContactRequest createContactRequest) throws BadRequestException,
            TooManyRequestsException, NotFoundException, AlreadyExistsException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a contact, which is an end-user who is receiving the email, and adds them to a contact list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactRequest.Builder} avoiding the need to
     * create one manually via {@link CreateContactRequest#builder()}
     * </p>
     *
     * @param createContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateContactRequest.Builder} to create a request.
     * @return Result of the CreateContact operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateContactResponse createContact(Consumer<CreateContactRequest.Builder> createContactRequest)
            throws BadRequestException, TooManyRequestsException, NotFoundException, AlreadyExistsException, AwsServiceException,
            SdkClientException, SesV2Exception {
        return createContact(CreateContactRequest.builder().applyMutation(createContactRequest).build());
    }

    /**
     * <p>
     * Creates a contact list.
     * </p>
     *
     * @param createContactListRequest
     * @return Result of the CreateContactList operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateContactListResponse createContactList(CreateContactListRequest createContactListRequest)
            throws BadRequestException, TooManyRequestsException, AlreadyExistsException, LimitExceededException,
            AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a contact list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactListRequest.Builder} avoiding the need
     * to create one manually via {@link CreateContactListRequest#builder()}
     * </p>
     *
     * @param createContactListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateContactListRequest.Builder} to create a request.
     * @return Result of the CreateContactList operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateContactListResponse createContactList(Consumer<CreateContactListRequest.Builder> createContactListRequest)
            throws BadRequestException, TooManyRequestsException, AlreadyExistsException, LimitExceededException,
            AwsServiceException, SdkClientException, SesV2Exception {
        return createContactList(CreateContactListRequest.builder().applyMutation(createContactListRequest).build());
    }

    /**
     * <p>
     * Creates a new custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createCustomVerificationEmailTemplateRequest
     *        Represents a request to create a custom verification email template.
     * @return Result of the CreateCustomVerificationEmailTemplate operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomVerificationEmailTemplateResponse createCustomVerificationEmailTemplate(
            CreateCustomVerificationEmailTemplateRequest createCustomVerificationEmailTemplateRequest)
            throws BadRequestException, AlreadyExistsException, NotFoundException, TooManyRequestsException,
            LimitExceededException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateCustomVerificationEmailTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link CreateCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param createCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateCustomVerificationEmailTemplateRequest.Builder}
     *        to create a request. Represents a request to create a custom verification email template.
     * @return Result of the CreateCustomVerificationEmailTemplate operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomVerificationEmailTemplateResponse createCustomVerificationEmailTemplate(
            Consumer<CreateCustomVerificationEmailTemplateRequest.Builder> createCustomVerificationEmailTemplateRequest)
            throws BadRequestException, AlreadyExistsException, NotFoundException, TooManyRequestsException,
            LimitExceededException, AwsServiceException, SdkClientException, SesV2Exception {
        return createCustomVerificationEmailTemplate(CreateCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(createCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are
     * associated with your Amazon Web Services account. You can associate a pool with a configuration set. When you
     * send an email that uses that configuration set, the message is sent from one of the addresses in the associated
     * pool.
     * </p>
     *
     * @param createDedicatedIpPoolRequest
     *        A request to create a new dedicated IP pool.
     * @return Result of the CreateDedicatedIpPool operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDedicatedIpPoolResponse createDedicatedIpPool(CreateDedicatedIpPoolRequest createDedicatedIpPoolRequest)
            throws AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are
     * associated with your Amazon Web Services account. You can associate a pool with a configuration set. When you
     * send an email that uses that configuration set, the message is sent from one of the addresses in the associated
     * pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDedicatedIpPoolRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDedicatedIpPoolRequest#builder()}
     * </p>
     *
     * @param createDedicatedIpPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest.Builder} to create a
     *        request. A request to create a new dedicated IP pool.
     * @return Result of the CreateDedicatedIpPool operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDedicatedIpPoolResponse createDedicatedIpPool(
            Consumer<CreateDedicatedIpPoolRequest.Builder> createDedicatedIpPoolRequest) throws AlreadyExistsException,
            LimitExceededException, TooManyRequestsException, BadRequestException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, SesV2Exception {
        return createDedicatedIpPool(CreateDedicatedIpPoolRequest.builder().applyMutation(createDedicatedIpPoolRequest).build());
    }

    /**
     * <p>
     * Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your
     * messages will be handled by various email providers around the world. When you perform a predictive inbox
     * placement test, you provide a sample message that contains the content that you plan to send to your customers.
     * Amazon SES then sends that message to special email addresses spread across several major email providers. After
     * about 24 hours, the test is complete, and you can use the <code>GetDeliverabilityTestReport</code> operation to
     * view the results of the test.
     * </p>
     *
     * @param createDeliverabilityTestReportRequest
     *        A request to perform a predictive inbox placement test. Predictive inbox placement tests can help you
     *        predict how your messages will be handled by various email providers around the world. When you perform a
     *        predictive inbox placement test, you provide a sample message that contains the content that you plan to
     *        send to your customers. We send that message to special email addresses spread across several major email
     *        providers around the world. The test takes about 24 hours to complete. When the test is complete, you can
     *        use the <code>GetDeliverabilityTestReport</code> operation to view the results of the test.
     * @return Result of the CreateDeliverabilityTestReport operation returned by the service.
     * @throws AccountSuspendedException
     *         The message can't be sent because the account's ability to send email has been permanently restricted.
     * @throws SendingPausedException
     *         The message can't be sent because the account's ability to send email is currently paused.
     * @throws MessageRejectedException
     *         The message can't be sent because it contains invalid content.
     * @throws MailFromDomainNotVerifiedException
     *         The message can't be sent because the sending domain isn't verified.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateDeliverabilityTestReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeliverabilityTestReportResponse createDeliverabilityTestReport(
            CreateDeliverabilityTestReportRequest createDeliverabilityTestReportRequest) throws AccountSuspendedException,
            SendingPausedException, MessageRejectedException, MailFromDomainNotVerifiedException, NotFoundException,
            TooManyRequestsException, LimitExceededException, BadRequestException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your
     * messages will be handled by various email providers around the world. When you perform a predictive inbox
     * placement test, you provide a sample message that contains the content that you plan to send to your customers.
     * Amazon SES then sends that message to special email addresses spread across several major email providers. After
     * about 24 hours, the test is complete, and you can use the <code>GetDeliverabilityTestReport</code> operation to
     * view the results of the test.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeliverabilityTestReportRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDeliverabilityTestReportRequest#builder()}
     * </p>
     *
     * @param createDeliverabilityTestReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest.Builder} to
     *        create a request. A request to perform a predictive inbox placement test. Predictive inbox placement tests
     *        can help you predict how your messages will be handled by various email providers around the world. When
     *        you perform a predictive inbox placement test, you provide a sample message that contains the content that
     *        you plan to send to your customers. We send that message to special email addresses spread across several
     *        major email providers around the world. The test takes about 24 hours to complete. When the test is
     *        complete, you can use the <code>GetDeliverabilityTestReport</code> operation to view the results of the
     *        test.
     * @return Result of the CreateDeliverabilityTestReport operation returned by the service.
     * @throws AccountSuspendedException
     *         The message can't be sent because the account's ability to send email has been permanently restricted.
     * @throws SendingPausedException
     *         The message can't be sent because the account's ability to send email is currently paused.
     * @throws MessageRejectedException
     *         The message can't be sent because it contains invalid content.
     * @throws MailFromDomainNotVerifiedException
     *         The message can't be sent because the sending domain isn't verified.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateDeliverabilityTestReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeliverabilityTestReportResponse createDeliverabilityTestReport(
            Consumer<CreateDeliverabilityTestReportRequest.Builder> createDeliverabilityTestReportRequest)
            throws AccountSuspendedException, SendingPausedException, MessageRejectedException,
            MailFromDomainNotVerifiedException, NotFoundException, TooManyRequestsException, LimitExceededException,
            BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        return createDeliverabilityTestReport(CreateDeliverabilityTestReportRequest.builder()
                .applyMutation(createDeliverabilityTestReportRequest).build());
    }

    /**
     * <p>
     * Starts the process of verifying an email identity. An <i>identity</i> is an email address or domain that you use
     * when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an
     * identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2
     * permission to send email from the identity.
     * </p>
     * <p>
     * When you verify an email address, Amazon SES sends an email to the address. Your email address is verified as
     * soon as you follow the link in the verification email.
     * </p>
     * <p>
     * When you verify a domain without specifying the <code>DkimSigningAttributes</code> object, this operation
     * provides a set of DKIM tokens. You can convert these tokens into CNAME records, which you then add to the DNS
     * configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS
     * configuration for your domain. This verification method is known as <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
     * </p>
     * <p>
     * Alternatively, you can perform the verification process by providing your own public-private key pair. This
     * verification method is known as Bring Your Own DKIM (BYODKIM). To use BYODKIM, your call to the
     * <code>CreateEmailIdentity</code> operation has to include the <code>DkimSigningAttributes</code> object. When you
     * specify this object, you provide a selector (a component of the DNS record name that identifies the public key to
     * use for DKIM authentication) and a private key.
     * </p>
     * <p>
     * When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens.
     * You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon SES
     * detects these records in the DNS configuration for your domain. For some DNS providers, it can take 72 hours or
     * more to complete the domain verification process.
     * </p>
     * <p>
     * Additionally, you can associate an existing configuration set with the email identity that you're verifying.
     * </p>
     *
     * @param createEmailIdentityRequest
     *        A request to begin the verification process for an email identity (an email address or domain).
     * @return Result of the CreateEmailIdentity operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEmailIdentityResponse createEmailIdentity(CreateEmailIdentityRequest createEmailIdentityRequest)
            throws AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException,
            ConcurrentModificationException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the process of verifying an email identity. An <i>identity</i> is an email address or domain that you use
     * when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an
     * identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2
     * permission to send email from the identity.
     * </p>
     * <p>
     * When you verify an email address, Amazon SES sends an email to the address. Your email address is verified as
     * soon as you follow the link in the verification email.
     * </p>
     * <p>
     * When you verify a domain without specifying the <code>DkimSigningAttributes</code> object, this operation
     * provides a set of DKIM tokens. You can convert these tokens into CNAME records, which you then add to the DNS
     * configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS
     * configuration for your domain. This verification method is known as <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
     * </p>
     * <p>
     * Alternatively, you can perform the verification process by providing your own public-private key pair. This
     * verification method is known as Bring Your Own DKIM (BYODKIM). To use BYODKIM, your call to the
     * <code>CreateEmailIdentity</code> operation has to include the <code>DkimSigningAttributes</code> object. When you
     * specify this object, you provide a selector (a component of the DNS record name that identifies the public key to
     * use for DKIM authentication) and a private key.
     * </p>
     * <p>
     * When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens.
     * You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon SES
     * detects these records in the DNS configuration for your domain. For some DNS providers, it can take 72 hours or
     * more to complete the domain verification process.
     * </p>
     * <p>
     * Additionally, you can associate an existing configuration set with the email identity that you're verifying.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEmailIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEmailIdentityRequest#builder()}
     * </p>
     *
     * @param createEmailIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest.Builder} to create a
     *        request. A request to begin the verification process for an email identity (an email address or domain).
     * @return Result of the CreateEmailIdentity operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEmailIdentityResponse createEmailIdentity(
            Consumer<CreateEmailIdentityRequest.Builder> createEmailIdentityRequest) throws AlreadyExistsException,
            LimitExceededException, TooManyRequestsException, BadRequestException, ConcurrentModificationException,
            NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        return createEmailIdentity(CreateEmailIdentityRequest.builder().applyMutation(createEmailIdentityRequest).build());
    }

    /**
     * <p>
     * Creates the specified sending authorization policy for the given identity (an email address or a domain).
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createEmailIdentityPolicyRequest
     *        Represents a request to create a sending authorization policy for an identity. Sending authorization is an
     *        Amazon SES feature that enables you to authorize other senders to use your identities. For information,
     *        see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return Result of the CreateEmailIdentityPolicy operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEmailIdentityPolicyResponse createEmailIdentityPolicy(
            CreateEmailIdentityPolicyRequest createEmailIdentityPolicyRequest) throws NotFoundException, AlreadyExistsException,
            TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified sending authorization policy for the given identity (an email address or a domain).
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEmailIdentityPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEmailIdentityPolicyRequest#builder()}
     * </p>
     *
     * @param createEmailIdentityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyRequest.Builder} to create a
     *        request. Represents a request to create a sending authorization policy for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return Result of the CreateEmailIdentityPolicy operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEmailIdentityPolicyResponse createEmailIdentityPolicy(
            Consumer<CreateEmailIdentityPolicyRequest.Builder> createEmailIdentityPolicyRequest) throws NotFoundException,
            AlreadyExistsException, TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException,
            SdkClientException, SesV2Exception {
        return createEmailIdentityPolicy(CreateEmailIdentityPolicyRequest.builder()
                .applyMutation(createEmailIdentityPolicyRequest).build());
    }

    /**
     * <p>
     * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createEmailTemplateRequest
     *        Represents a request to create an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateEmailTemplate operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEmailTemplateResponse createEmailTemplate(CreateEmailTemplateRequest createEmailTemplateRequest)
            throws AlreadyExistsException, TooManyRequestsException, BadRequestException, LimitExceededException,
            AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEmailTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEmailTemplateRequest#builder()}
     * </p>
     *
     * @param createEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateEmailTemplateRequest.Builder} to create a
     *        request. Represents a request to create an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the CreateEmailTemplate operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEmailTemplateResponse createEmailTemplate(
            Consumer<CreateEmailTemplateRequest.Builder> createEmailTemplateRequest) throws AlreadyExistsException,
            TooManyRequestsException, BadRequestException, LimitExceededException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return createEmailTemplate(CreateEmailTemplateRequest.builder().applyMutation(createEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Creates an export job for a data source and destination.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createExportJobRequest
     *        Represents a request to create an export job from a data source to a data destination.
     * @return Result of the CreateExportJob operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateExportJobResponse createExportJob(CreateExportJobRequest createExportJobRequest) throws BadRequestException,
            TooManyRequestsException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an export job for a data source and destination.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExportJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateExportJobRequest#builder()}
     * </p>
     *
     * @param createExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateExportJobRequest.Builder} to create a request.
     *        Represents a request to create an export job from a data source to a data destination.
     * @return Result of the CreateExportJob operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateExportJobResponse createExportJob(Consumer<CreateExportJobRequest.Builder> createExportJobRequest)
            throws BadRequestException, TooManyRequestsException, NotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, SesV2Exception {
        return createExportJob(CreateExportJobRequest.builder().applyMutation(createExportJobRequest).build());
    }

    /**
     * <p>
     * Creates an import job for a data destination.
     * </p>
     *
     * @param createImportJobRequest
     *        Represents a request to create an import job from a data source for a data destination.
     * @return Result of the CreateImportJob operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateImportJobResponse createImportJob(CreateImportJobRequest createImportJobRequest) throws BadRequestException,
            LimitExceededException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an import job for a data destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImportJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateImportJobRequest#builder()}
     * </p>
     *
     * @param createImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.CreateImportJobRequest.Builder} to create a request.
     *        Represents a request to create an import job from a data source for a data destination.
     * @return Result of the CreateImportJob operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.CreateImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateImportJobResponse createImportJob(Consumer<CreateImportJobRequest.Builder> createImportJobRequest)
            throws BadRequestException, LimitExceededException, TooManyRequestsException, AwsServiceException,
            SdkClientException, SesV2Exception {
        return createImportJob(CreateImportJobRequest.builder().applyMutation(createImportJobRequest).build());
    }

    /**
     * <p>
     * Delete an existing configuration set.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        A request to delete a configuration set.
     * @return Result of the DeleteConfigurationSet operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConfigurationSetResponse deleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an existing configuration set.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConfigurationSetRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetRequest.Builder} to create a
     *        request. A request to delete a configuration set.
     * @return Result of the DeleteConfigurationSet operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConfigurationSetResponse deleteConfigurationSet(
            Consumer<DeleteConfigurationSetRequest.Builder> deleteConfigurationSetRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, SesV2Exception {
        return deleteConfigurationSet(DeleteConfigurationSetRequest.builder().applyMutation(deleteConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Delete an event destination.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     *
     * @param deleteConfigurationSetEventDestinationRequest
     *        A request to delete an event destination from a configuration set.
     * @return Result of the DeleteConfigurationSetEventDestination operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestination(
            DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an event destination.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. A request to delete an event destination from a configuration set.
     * @return Result of the DeleteConfigurationSetEventDestination operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestination(
            Consumer<DeleteConfigurationSetEventDestinationRequest.Builder> deleteConfigurationSetEventDestinationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest.builder()
                .applyMutation(deleteConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Removes a contact from a contact list.
     * </p>
     *
     * @param deleteContactRequest
     * @return Result of the DeleteContact operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteContact" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteContactResponse deleteContact(DeleteContactRequest deleteContactRequest) throws BadRequestException,
            TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a contact from a contact list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteContactRequest#builder()}
     * </p>
     *
     * @param deleteContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteContactRequest.Builder} to create a request.
     * @return Result of the DeleteContact operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteContact" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteContactResponse deleteContact(Consumer<DeleteContactRequest.Builder> deleteContactRequest)
            throws BadRequestException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return deleteContact(DeleteContactRequest.builder().applyMutation(deleteContactRequest).build());
    }

    /**
     * <p>
     * Deletes a contact list and all of the contacts on that list.
     * </p>
     *
     * @param deleteContactListRequest
     * @return Result of the DeleteContactList operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteContactListResponse deleteContactList(DeleteContactListRequest deleteContactListRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a contact list and all of the contacts on that list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactListRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteContactListRequest#builder()}
     * </p>
     *
     * @param deleteContactListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteContactListRequest.Builder} to create a request.
     * @return Result of the DeleteContactList operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteContactListResponse deleteContactList(Consumer<DeleteContactListRequest.Builder> deleteContactListRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, SesV2Exception {
        return deleteContactList(DeleteContactListRequest.builder().applyMutation(deleteContactListRequest).build());
    }

    /**
     * <p>
     * Deletes an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteCustomVerificationEmailTemplateRequest
     *        Represents a request to delete an existing custom verification email template.
     * @return Result of the DeleteCustomVerificationEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomVerificationEmailTemplateResponse deleteCustomVerificationEmailTemplate(
            DeleteCustomVerificationEmailTemplateRequest deleteCustomVerificationEmailTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteCustomVerificationEmailTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param deleteCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateRequest.Builder}
     *        to create a request. Represents a request to delete an existing custom verification email template.
     * @return Result of the DeleteCustomVerificationEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomVerificationEmailTemplateResponse deleteCustomVerificationEmailTemplate(
            Consumer<DeleteCustomVerificationEmailTemplateRequest.Builder> deleteCustomVerificationEmailTemplateRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return deleteCustomVerificationEmailTemplate(DeleteCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(deleteCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Delete a dedicated IP pool.
     * </p>
     *
     * @param deleteDedicatedIpPoolRequest
     *        A request to delete a dedicated IP pool.
     * @return Result of the DeleteDedicatedIpPool operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDedicatedIpPoolResponse deleteDedicatedIpPool(DeleteDedicatedIpPoolRequest deleteDedicatedIpPoolRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a dedicated IP pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDedicatedIpPoolRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDedicatedIpPoolRequest#builder()}
     * </p>
     *
     * @param deleteDedicatedIpPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest.Builder} to create a
     *        request. A request to delete a dedicated IP pool.
     * @return Result of the DeleteDedicatedIpPool operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDedicatedIpPoolResponse deleteDedicatedIpPool(
            Consumer<DeleteDedicatedIpPoolRequest.Builder> deleteDedicatedIpPoolRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, SesV2Exception {
        return deleteDedicatedIpPool(DeleteDedicatedIpPoolRequest.builder().applyMutation(deleteDedicatedIpPoolRequest).build());
    }

    /**
     * <p>
     * Deletes an email identity. An identity can be either an email address or a domain name.
     * </p>
     *
     * @param deleteEmailIdentityRequest
     *        A request to delete an existing email identity. When you delete an identity, you lose the ability to send
     *        email from that identity. You can restore your ability to send email by completing the verification
     *        process for the identity again.
     * @return Result of the DeleteEmailIdentity operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEmailIdentityResponse deleteEmailIdentity(DeleteEmailIdentityRequest deleteEmailIdentityRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an email identity. An identity can be either an email address or a domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEmailIdentityRequest#builder()}
     * </p>
     *
     * @param deleteEmailIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest.Builder} to create a
     *        request. A request to delete an existing email identity. When you delete an identity, you lose the ability
     *        to send email from that identity. You can restore your ability to send email by completing the
     *        verification process for the identity again.
     * @return Result of the DeleteEmailIdentity operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEmailIdentityResponse deleteEmailIdentity(
            Consumer<DeleteEmailIdentityRequest.Builder> deleteEmailIdentityRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, SesV2Exception {
        return deleteEmailIdentity(DeleteEmailIdentityRequest.builder().applyMutation(deleteEmailIdentityRequest).build());
    }

    /**
     * <p>
     * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteEmailIdentityPolicyRequest
     *        Represents a request to delete a sending authorization policy for an identity. Sending authorization is an
     *        Amazon SES feature that enables you to authorize other senders to use your identities. For information,
     *        see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return Result of the DeleteEmailIdentityPolicy operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEmailIdentityPolicyResponse deleteEmailIdentityPolicy(
            DeleteEmailIdentityPolicyRequest deleteEmailIdentityPolicyRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailIdentityPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEmailIdentityPolicyRequest#builder()}
     * </p>
     *
     * @param deleteEmailIdentityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyRequest.Builder} to create a
     *        request. Represents a request to delete a sending authorization policy for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return Result of the DeleteEmailIdentityPolicy operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEmailIdentityPolicyResponse deleteEmailIdentityPolicy(
            Consumer<DeleteEmailIdentityPolicyRequest.Builder> deleteEmailIdentityPolicyRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return deleteEmailIdentityPolicy(DeleteEmailIdentityPolicyRequest.builder()
                .applyMutation(deleteEmailIdentityPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an email template.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteEmailTemplateRequest
     *        Represents a request to delete an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEmailTemplateResponse deleteEmailTemplate(DeleteEmailTemplateRequest deleteEmailTemplateRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an email template.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEmailTemplateRequest#builder()}
     * </p>
     *
     * @param deleteEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteEmailTemplateRequest.Builder} to create a
     *        request. Represents a request to delete an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the DeleteEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEmailTemplateResponse deleteEmailTemplate(
            Consumer<DeleteEmailTemplateRequest.Builder> deleteEmailTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return deleteEmailTemplate(DeleteEmailTemplateRequest.builder().applyMutation(deleteEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Removes an email address from the suppression list for your account.
     * </p>
     *
     * @param deleteSuppressedDestinationRequest
     *        A request to remove an email address from the suppression list for your account.
     * @return Result of the DeleteSuppressedDestination operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSuppressedDestinationResponse deleteSuppressedDestination(
            DeleteSuppressedDestinationRequest deleteSuppressedDestinationRequest) throws NotFoundException, BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an email address from the suppression list for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSuppressedDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSuppressedDestinationRequest#builder()}
     * </p>
     *
     * @param deleteSuppressedDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationRequest.Builder} to create a
     *        request. A request to remove an email address from the suppression list for your account.
     * @return Result of the DeleteSuppressedDestination operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.DeleteSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSuppressedDestinationResponse deleteSuppressedDestination(
            Consumer<DeleteSuppressedDestinationRequest.Builder> deleteSuppressedDestinationRequest) throws NotFoundException,
            BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        return deleteSuppressedDestination(DeleteSuppressedDestinationRequest.builder()
                .applyMutation(deleteSuppressedDestinationRequest).build());
    }

    /**
     * <p>
     * Obtain information about the email-sending status and capabilities of your Amazon SES account in the current
     * Amazon Web Services Region.
     * </p>
     *
     * @param getAccountRequest
     *        A request to obtain information about the email-sending capabilities of your Amazon SES account.
     * @return Result of the GetAccount operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountResponse getAccount(GetAccountRequest getAccountRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtain information about the email-sending status and capabilities of your Amazon SES account in the current
     * Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccountRequest#builder()}
     * </p>
     *
     * @param getAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetAccountRequest.Builder} to create a request. A
     *        request to obtain information about the email-sending capabilities of your Amazon SES account.
     * @return Result of the GetAccount operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountResponse getAccount(Consumer<GetAccountRequest.Builder> getAccountRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return getAccount(GetAccountRequest.builder().applyMutation(getAccountRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * </p>
     *
     * @param getBlacklistReportsRequest
     *        A request to retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * @return Result of the GetBlacklistReports operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetBlacklistReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetBlacklistReports" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBlacklistReportsResponse getBlacklistReports(GetBlacklistReportsRequest getBlacklistReportsRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlacklistReportsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBlacklistReportsRequest#builder()}
     * </p>
     *
     * @param getBlacklistReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest.Builder} to create a
     *        request. A request to retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * @return Result of the GetBlacklistReports operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetBlacklistReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetBlacklistReports" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBlacklistReportsResponse getBlacklistReports(
            Consumer<GetBlacklistReportsRequest.Builder> getBlacklistReportsRequest) throws TooManyRequestsException,
            NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return getBlacklistReports(GetBlacklistReportsRequest.builder().applyMutation(getBlacklistReportsRequest).build());
    }

    /**
     * <p>
     * Get information about an existing configuration set, including the dedicated IP pool that it's associated with,
     * whether or not it's enabled for sending email, and more.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     *
     * @param getConfigurationSetRequest
     *        A request to obtain information about a configuration set.
     * @return Result of the GetConfigurationSet operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConfigurationSetResponse getConfigurationSet(GetConfigurationSetRequest getConfigurationSetRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about an existing configuration set, including the dedicated IP pool that it's associated with,
     * whether or not it's enabled for sending email, and more.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link GetConfigurationSetRequest#builder()}
     * </p>
     *
     * @param getConfigurationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest.Builder} to create a
     *        request. A request to obtain information about a configuration set.
     * @return Result of the GetConfigurationSet operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConfigurationSetResponse getConfigurationSet(
            Consumer<GetConfigurationSetRequest.Builder> getConfigurationSetRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return getConfigurationSet(GetConfigurationSetRequest.builder().applyMutation(getConfigurationSetRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of event destinations that are associated with a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     *
     * @param getConfigurationSetEventDestinationsRequest
     *        A request to obtain information about the event destinations for a configuration set.
     * @return Result of the GetConfigurationSetEventDestinations operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetConfigurationSetEventDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSetEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationSetEventDestinationsResponse getConfigurationSetEventDestinations(
            GetConfigurationSetEventDestinationsRequest getConfigurationSetEventDestinationsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of event destinations that are associated with a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetConfigurationSetEventDestinationsRequest.Builder} avoiding the need to create one manually via
     * {@link GetConfigurationSetEventDestinationsRequest#builder()}
     * </p>
     *
     * @param getConfigurationSetEventDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest.Builder} to
     *        create a request. A request to obtain information about the event destinations for a configuration set.
     * @return Result of the GetConfigurationSetEventDestinations operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetConfigurationSetEventDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSetEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationSetEventDestinationsResponse getConfigurationSetEventDestinations(
            Consumer<GetConfigurationSetEventDestinationsRequest.Builder> getConfigurationSetEventDestinationsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getConfigurationSetEventDestinations(GetConfigurationSetEventDestinationsRequest.builder()
                .applyMutation(getConfigurationSetEventDestinationsRequest).build());
    }

    /**
     * <p>
     * Returns a contact from a contact list.
     * </p>
     *
     * @param getContactRequest
     * @return Result of the GetContact operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetContact" target="_top">AWS API
     *      Documentation</a>
     */
    default GetContactResponse getContact(GetContactRequest getContactRequest) throws BadRequestException,
            TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a contact from a contact list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactRequest.Builder} avoiding the need to
     * create one manually via {@link GetContactRequest#builder()}
     * </p>
     *
     * @param getContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetContactRequest.Builder} to create a request.
     * @return Result of the GetContact operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetContact" target="_top">AWS API
     *      Documentation</a>
     */
    default GetContactResponse getContact(Consumer<GetContactRequest.Builder> getContactRequest) throws BadRequestException,
            TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        return getContact(GetContactRequest.builder().applyMutation(getContactRequest).build());
    }

    /**
     * <p>
     * Returns contact list metadata. It does not return any information about the contacts present in the list.
     * </p>
     *
     * @param getContactListRequest
     * @return Result of the GetContactList operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default GetContactListResponse getContactList(GetContactListRequest getContactListRequest) throws TooManyRequestsException,
            NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns contact list metadata. It does not return any information about the contacts present in the list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactListRequest.Builder} avoiding the need to
     * create one manually via {@link GetContactListRequest#builder()}
     * </p>
     *
     * @param getContactListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetContactListRequest.Builder} to create a request.
     * @return Result of the GetContactList operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default GetContactListResponse getContactList(Consumer<GetContactListRequest.Builder> getContactListRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getContactList(GetContactListRequest.builder().applyMutation(getContactListRequest).build());
    }

    /**
     * <p>
     * Returns the custom email verification template for the template name you specify.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getCustomVerificationEmailTemplateRequest
     *        Represents a request to retrieve an existing custom verification email template.
     * @return Result of the GetCustomVerificationEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomVerificationEmailTemplateResponse getCustomVerificationEmailTemplate(
            GetCustomVerificationEmailTemplateRequest getCustomVerificationEmailTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the custom email verification template for the template name you specify.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomVerificationEmailTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link GetCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param getCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetCustomVerificationEmailTemplateRequest.Builder} to
     *        create a request. Represents a request to retrieve an existing custom verification email template.
     * @return Result of the GetCustomVerificationEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomVerificationEmailTemplateResponse getCustomVerificationEmailTemplate(
            Consumer<GetCustomVerificationEmailTemplateRequest.Builder> getCustomVerificationEmailTemplateRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getCustomVerificationEmailTemplate(GetCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(getCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated
     * with, as well information about the automatic warm-up process for the address.
     * </p>
     *
     * @param getDedicatedIpRequest
     *        A request to obtain more information about a dedicated IP address.
     * @return Result of the GetDedicatedIp operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDedicatedIp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIp" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDedicatedIpResponse getDedicatedIp(GetDedicatedIpRequest getDedicatedIpRequest) throws TooManyRequestsException,
            NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated
     * with, as well information about the automatic warm-up process for the address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDedicatedIpRequest.Builder} avoiding the need to
     * create one manually via {@link GetDedicatedIpRequest#builder()}
     * </p>
     *
     * @param getDedicatedIpRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDedicatedIpRequest.Builder} to create a request. A
     *        request to obtain more information about a dedicated IP address.
     * @return Result of the GetDedicatedIp operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDedicatedIp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIp" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDedicatedIpResponse getDedicatedIp(Consumer<GetDedicatedIpRequest.Builder> getDedicatedIpRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getDedicatedIp(GetDedicatedIpRequest.builder().applyMutation(getDedicatedIpRequest).build());
    }

    /**
     * <p>
     * Retrieve information about the dedicated pool.
     * </p>
     *
     * @param getDedicatedIpPoolRequest
     *        A request to obtain more information about a dedicated IP pool.
     * @return Result of the GetDedicatedIpPool operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIpPool" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDedicatedIpPoolResponse getDedicatedIpPool(GetDedicatedIpPoolRequest getDedicatedIpPoolRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve information about the dedicated pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDedicatedIpPoolRequest.Builder} avoiding the
     * need to create one manually via {@link GetDedicatedIpPoolRequest#builder()}
     * </p>
     *
     * @param getDedicatedIpPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolRequest.Builder} to create a request.
     *        A request to obtain more information about a dedicated IP pool.
     * @return Result of the GetDedicatedIpPool operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDedicatedIpPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIpPool" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDedicatedIpPoolResponse getDedicatedIpPool(Consumer<GetDedicatedIpPoolRequest.Builder> getDedicatedIpPoolRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getDedicatedIpPool(GetDedicatedIpPoolRequest.builder().applyMutation(getDedicatedIpPoolRequest).build());
    }

    /**
     * <p>
     * List the dedicated IP addresses that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A request to obtain more information about dedicated IP pools.
     * @return Result of the GetDedicatedIps operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDedicatedIps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDedicatedIpsResponse getDedicatedIps(GetDedicatedIpsRequest getDedicatedIpsRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the dedicated IP addresses that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDedicatedIpsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDedicatedIpsRequest#builder()}
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest.Builder} to create a request. A
     *        request to obtain more information about dedicated IP pools.
     * @return Result of the GetDedicatedIps operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDedicatedIps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDedicatedIpsResponse getDedicatedIps(Consumer<GetDedicatedIpsRequest.Builder> getDedicatedIpsRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getDedicatedIps(GetDedicatedIpsRequest.builder().applyMutation(getDedicatedIpsRequest).build());
    }

    /**
     * <p>
     * List the dedicated IP addresses that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getDedicatedIps(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsIterable responses = client.getDedicatedIpsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsIterable responses = client.getDedicatedIpsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsIterable responses = client.getDedicatedIpsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDedicatedIps(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest)} operation.</b>
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A request to obtain more information about dedicated IP pools.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDedicatedIps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDedicatedIpsIterable getDedicatedIpsPaginator(GetDedicatedIpsRequest getDedicatedIpsRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return new GetDedicatedIpsIterable(this, getDedicatedIpsRequest);
    }

    /**
     * <p>
     * List the dedicated IP addresses that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getDedicatedIps(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsIterable responses = client.getDedicatedIpsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsIterable responses = client.getDedicatedIpsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsIterable responses = client.getDedicatedIpsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDedicatedIps(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDedicatedIpsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDedicatedIpsRequest#builder()}
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest.Builder} to create a request. A
     *        request to obtain more information about dedicated IP pools.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDedicatedIps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDedicatedIpsIterable getDedicatedIpsPaginator(Consumer<GetDedicatedIpsRequest.Builder> getDedicatedIpsRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getDedicatedIpsPaginator(GetDedicatedIpsRequest.builder().applyMutation(getDedicatedIpsRequest).build());
    }

    /**
     * <p>
     * Retrieve information about the status of the Deliverability dashboard for your account. When the Deliverability
     * dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you
     * use to send email. You also gain the ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the
     * features and cost of a Deliverability dashboard subscription, see <a
     * href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.
     * </p>
     *
     * @param getDeliverabilityDashboardOptionsRequest
     *        Retrieve information about the status of the Deliverability dashboard for your Amazon Web Services
     *        account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and
     *        other metrics for your domains. You also gain the ability to perform predictive inbox placement tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information
     *        about the features and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return Result of the GetDeliverabilityDashboardOptions operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDeliverabilityDashboardOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityDashboardOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeliverabilityDashboardOptionsResponse getDeliverabilityDashboardOptions(
            GetDeliverabilityDashboardOptionsRequest getDeliverabilityDashboardOptionsRequest) throws TooManyRequestsException,
            LimitExceededException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve information about the status of the Deliverability dashboard for your account. When the Deliverability
     * dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you
     * use to send email. You also gain the ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the
     * features and cost of a Deliverability dashboard subscription, see <a
     * href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeliverabilityDashboardOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link GetDeliverabilityDashboardOptionsRequest#builder()}
     * </p>
     *
     * @param getDeliverabilityDashboardOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsRequest.Builder} to
     *        create a request. Retrieve information about the status of the Deliverability dashboard for your Amazon
     *        Web Services account. When the Deliverability dashboard is enabled, you gain access to reputation,
     *        deliverability, and other metrics for your domains. You also gain the ability to perform predictive inbox
     *        placement tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information
     *        about the features and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return Result of the GetDeliverabilityDashboardOptions operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDeliverabilityDashboardOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityDashboardOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeliverabilityDashboardOptionsResponse getDeliverabilityDashboardOptions(
            Consumer<GetDeliverabilityDashboardOptionsRequest.Builder> getDeliverabilityDashboardOptionsRequest)
            throws TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException,
            SdkClientException, SesV2Exception {
        return getDeliverabilityDashboardOptions(GetDeliverabilityDashboardOptionsRequest.builder()
                .applyMutation(getDeliverabilityDashboardOptionsRequest).build());
    }

    /**
     * <p>
     * Retrieve the results of a predictive inbox placement test.
     * </p>
     *
     * @param getDeliverabilityTestReportRequest
     *        A request to retrieve the results of a predictive inbox placement test.
     * @return Result of the GetDeliverabilityTestReport operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDeliverabilityTestReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeliverabilityTestReportResponse getDeliverabilityTestReport(
            GetDeliverabilityTestReportRequest getDeliverabilityTestReportRequest) throws TooManyRequestsException,
            NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the results of a predictive inbox placement test.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeliverabilityTestReportRequest.Builder}
     * avoiding the need to create one manually via {@link GetDeliverabilityTestReportRequest#builder()}
     * </p>
     *
     * @param getDeliverabilityTestReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportRequest.Builder} to create a
     *        request. A request to retrieve the results of a predictive inbox placement test.
     * @return Result of the GetDeliverabilityTestReport operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDeliverabilityTestReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeliverabilityTestReportResponse getDeliverabilityTestReport(
            Consumer<GetDeliverabilityTestReportRequest.Builder> getDeliverabilityTestReportRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getDeliverabilityTestReport(GetDeliverabilityTestReportRequest.builder()
                .applyMutation(getDeliverabilityTestReportRequest).build());
    }

    /**
     * <p>
     * Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the
     * campaign sent email by using a domain that the Deliverability dashboard is enabled for.
     * </p>
     *
     * @param getDomainDeliverabilityCampaignRequest
     *        Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only
     *        if the campaign sent email by using a domain that the Deliverability dashboard is enabled for (
     *        <code>PutDeliverabilityDashboardOption</code> operation).
     * @return Result of the GetDomainDeliverabilityCampaign operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDomainDeliverabilityCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainDeliverabilityCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDomainDeliverabilityCampaignResponse getDomainDeliverabilityCampaign(
            GetDomainDeliverabilityCampaignRequest getDomainDeliverabilityCampaignRequest) throws TooManyRequestsException,
            BadRequestException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the
     * campaign sent email by using a domain that the Deliverability dashboard is enabled for.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainDeliverabilityCampaignRequest.Builder}
     * avoiding the need to create one manually via {@link GetDomainDeliverabilityCampaignRequest#builder()}
     * </p>
     *
     * @param getDomainDeliverabilityCampaignRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest.Builder} to
     *        create a request. Retrieve all the deliverability data for a specific campaign. This data is available for
     *        a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled
     *        for (<code>PutDeliverabilityDashboardOption</code> operation).
     * @return Result of the GetDomainDeliverabilityCampaign operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDomainDeliverabilityCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainDeliverabilityCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDomainDeliverabilityCampaignResponse getDomainDeliverabilityCampaign(
            Consumer<GetDomainDeliverabilityCampaignRequest.Builder> getDomainDeliverabilityCampaignRequest)
            throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getDomainDeliverabilityCampaign(GetDomainDeliverabilityCampaignRequest.builder()
                .applyMutation(getDomainDeliverabilityCampaignRequest).build());
    }

    /**
     * <p>
     * Retrieve inbox placement and engagement rates for the domains that you use to send email.
     * </p>
     *
     * @param getDomainStatisticsReportRequest
     *        A request to obtain deliverability metrics for a domain.
     * @return Result of the GetDomainStatisticsReport operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDomainStatisticsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainStatisticsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDomainStatisticsReportResponse getDomainStatisticsReport(
            GetDomainStatisticsReportRequest getDomainStatisticsReportRequest) throws TooManyRequestsException,
            NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve inbox placement and engagement rates for the domains that you use to send email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainStatisticsReportRequest.Builder} avoiding
     * the need to create one manually via {@link GetDomainStatisticsReportRequest#builder()}
     * </p>
     *
     * @param getDomainStatisticsReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest.Builder} to create a
     *        request. A request to obtain deliverability metrics for a domain.
     * @return Result of the GetDomainStatisticsReport operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetDomainStatisticsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainStatisticsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDomainStatisticsReportResponse getDomainStatisticsReport(
            Consumer<GetDomainStatisticsReportRequest.Builder> getDomainStatisticsReportRequest) throws TooManyRequestsException,
            NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return getDomainStatisticsReport(GetDomainStatisticsReportRequest.builder()
                .applyMutation(getDomainStatisticsReportRequest).build());
    }

    /**
     * <p>
     * Provides information about a specific identity, including the identity's verification status, sending
     * authorization policies, its DKIM authentication status, and its custom Mail-From settings.
     * </p>
     *
     * @param getEmailIdentityRequest
     *        A request to return details about an email identity.
     * @return Result of the GetEmailIdentity operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEmailIdentityResponse getEmailIdentity(GetEmailIdentityRequest getEmailIdentityRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a specific identity, including the identity's verification status, sending
     * authorization policies, its DKIM authentication status, and its custom Mail-From settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEmailIdentityRequest.Builder} avoiding the need
     * to create one manually via {@link GetEmailIdentityRequest#builder()}
     * </p>
     *
     * @param getEmailIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest.Builder} to create a request. A
     *        request to return details about an email identity.
     * @return Result of the GetEmailIdentity operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetEmailIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEmailIdentityResponse getEmailIdentity(Consumer<GetEmailIdentityRequest.Builder> getEmailIdentityRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getEmailIdentity(GetEmailIdentityRequest.builder().applyMutation(getEmailIdentityRequest).build());
    }

    /**
     * <p>
     * Returns the requested sending authorization policies for the given identity (an email address or a domain). The
     * policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a
     * time.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getEmailIdentityPoliciesRequest
     *        A request to return the policies of an email identity.
     * @return Result of the GetEmailIdentityPolicies operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetEmailIdentityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEmailIdentityPoliciesResponse getEmailIdentityPolicies(
            GetEmailIdentityPoliciesRequest getEmailIdentityPoliciesRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the requested sending authorization policies for the given identity (an email address or a domain). The
     * policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a
     * time.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEmailIdentityPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link GetEmailIdentityPoliciesRequest#builder()}
     * </p>
     *
     * @param getEmailIdentityPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesRequest.Builder} to create a
     *        request. A request to return the policies of an email identity.
     * @return Result of the GetEmailIdentityPolicies operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetEmailIdentityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEmailIdentityPoliciesResponse getEmailIdentityPolicies(
            Consumer<GetEmailIdentityPoliciesRequest.Builder> getEmailIdentityPoliciesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return getEmailIdentityPolicies(GetEmailIdentityPoliciesRequest.builder().applyMutation(getEmailIdentityPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Displays the template object (which includes the subject line, HTML part and text part) for the template you
     * specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getEmailTemplateRequest
     *        Represents a request to display the template object (which includes the subject line, HTML part and text
     *        part) for the template you specify.
     * @return Result of the GetEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEmailTemplateResponse getEmailTemplate(GetEmailTemplateRequest getEmailTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the template object (which includes the subject line, HTML part and text part) for the template you
     * specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEmailTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetEmailTemplateRequest#builder()}
     * </p>
     *
     * @param getEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetEmailTemplateRequest.Builder} to create a request.
     *        Represents a request to display the template object (which includes the subject line, HTML part and text
     *        part) for the template you specify.
     * @return Result of the GetEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEmailTemplateResponse getEmailTemplate(Consumer<GetEmailTemplateRequest.Builder> getEmailTemplateRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getEmailTemplate(GetEmailTemplateRequest.builder().applyMutation(getEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Provides information about an export job.
     * </p>
     *
     * @param getExportJobRequest
     *        Represents a request to retrieve information about an export job using the export job ID.
     * @return Result of the GetExportJob operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExportJobResponse getExportJob(GetExportJobRequest getExportJobRequest) throws BadRequestException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about an export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExportJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetExportJobRequest#builder()}
     * </p>
     *
     * @param getExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetExportJobRequest.Builder} to create a request.
     *        Represents a request to retrieve information about an export job using the export job ID.
     * @return Result of the GetExportJob operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExportJobResponse getExportJob(Consumer<GetExportJobRequest.Builder> getExportJobRequest)
            throws BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getExportJob(GetExportJobRequest.builder().applyMutation(getExportJobRequest).build());
    }

    /**
     * <p>
     * Provides information about an import job.
     * </p>
     *
     * @param getImportJobRequest
     *        Represents a request for information about an import job using the import job ID.
     * @return Result of the GetImportJob operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetImportJobResponse getImportJob(GetImportJobRequest getImportJobRequest) throws BadRequestException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about an import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetImportJobRequest#builder()}
     * </p>
     *
     * @param getImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetImportJobRequest.Builder} to create a request.
     *        Represents a request for information about an import job using the import job ID.
     * @return Result of the GetImportJob operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetImportJobResponse getImportJob(Consumer<GetImportJobRequest.Builder> getImportJobRequest)
            throws BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getImportJob(GetImportJobRequest.builder().applyMutation(getImportJobRequest).build());
    }

    /**
     * <p>
     * Provides information about a specific message, including the from address, the subject, the recipient address,
     * email tags, as well as events associated with the message.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getMessageInsightsRequest
     *        A request to return information about a message.
     * @return Result of the GetMessageInsights operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetMessageInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetMessageInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMessageInsightsResponse getMessageInsights(GetMessageInsightsRequest getMessageInsightsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a specific message, including the from address, the subject, the recipient address,
     * email tags, as well as events associated with the message.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMessageInsightsRequest.Builder} avoiding the
     * need to create one manually via {@link GetMessageInsightsRequest#builder()}
     * </p>
     *
     * @param getMessageInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetMessageInsightsRequest.Builder} to create a request.
     *        A request to return information about a message.
     * @return Result of the GetMessageInsights operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetMessageInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetMessageInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMessageInsightsResponse getMessageInsights(Consumer<GetMessageInsightsRequest.Builder> getMessageInsightsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return getMessageInsights(GetMessageInsightsRequest.builder().applyMutation(getMessageInsightsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific email address that's on the suppression list for your account.
     * </p>
     *
     * @param getSuppressedDestinationRequest
     *        A request to retrieve information about an email address that's on the suppression list for your account.
     * @return Result of the GetSuppressedDestination operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSuppressedDestinationResponse getSuppressedDestination(
            GetSuppressedDestinationRequest getSuppressedDestinationRequest) throws BadRequestException,
            TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific email address that's on the suppression list for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSuppressedDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link GetSuppressedDestinationRequest#builder()}
     * </p>
     *
     * @param getSuppressedDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationRequest.Builder} to create a
     *        request. A request to retrieve information about an email address that's on the suppression list for your
     *        account.
     * @return Result of the GetSuppressedDestination operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.GetSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSuppressedDestinationResponse getSuppressedDestination(
            Consumer<GetSuppressedDestinationRequest.Builder> getSuppressedDestinationRequest) throws BadRequestException,
            TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        return getSuppressedDestination(GetSuppressedDestinationRequest.builder().applyMutation(getSuppressedDestinationRequest)
                .build());
    }

    /**
     * <p>
     * List all of the configuration sets associated with your account in the current region.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A request to obtain a list of configuration sets for your Amazon SES account in the current Amazon Web
     *        Services Region.
     * @return Result of the ListConfigurationSets operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationSetsResponse listConfigurationSets(ListConfigurationSetsRequest listConfigurationSetsRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the configuration sets associated with your account in the current region.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest.Builder} to create a
     *        request. A request to obtain a list of configuration sets for your Amazon SES account in the current
     *        Amazon Web Services Region.
     * @return Result of the ListConfigurationSets operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationSetsResponse listConfigurationSets(
            Consumer<ListConfigurationSetsRequest.Builder> listConfigurationSetsRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listConfigurationSets(ListConfigurationSetsRequest.builder().applyMutation(listConfigurationSetsRequest).build());
    }

    /**
     * <p>
     * List all of the configuration sets associated with your account in the current region.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConfigurationSets(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsIterable responses = client.listConfigurationSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsIterable responses = client
     *             .listConfigurationSetsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsIterable responses = client.listConfigurationSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationSets(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A request to obtain a list of configuration sets for your Amazon SES account in the current Amazon Web
     *        Services Region.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationSetsIterable listConfigurationSetsPaginator(ListConfigurationSetsRequest listConfigurationSetsRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListConfigurationSetsIterable(this, listConfigurationSetsRequest);
    }

    /**
     * <p>
     * List all of the configuration sets associated with your account in the current region.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConfigurationSets(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsIterable responses = client.listConfigurationSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsIterable responses = client
     *             .listConfigurationSetsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsIterable responses = client.listConfigurationSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationSets(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest.Builder} to create a
     *        request. A request to obtain a list of configuration sets for your Amazon SES account in the current
     *        Amazon Web Services Region.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationSetsIterable listConfigurationSetsPaginator(
            Consumer<ListConfigurationSetsRequest.Builder> listConfigurationSetsRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listConfigurationSetsPaginator(ListConfigurationSetsRequest.builder().applyMutation(listConfigurationSetsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all of the contact lists available.
     * </p>
     *
     * @param listContactListsRequest
     * @return Result of the ListContactLists operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListContactLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContactLists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactListsResponse listContactLists(ListContactListsRequest listContactListsRequest)
            throws BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the contact lists available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactListsRequest.Builder} avoiding the need
     * to create one manually via {@link ListContactListsRequest#builder()}
     * </p>
     *
     * @param listContactListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListContactListsRequest.Builder} to create a request.
     * @return Result of the ListContactLists operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListContactLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContactLists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactListsResponse listContactLists(Consumer<ListContactListsRequest.Builder> listContactListsRequest)
            throws BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        return listContactLists(ListContactListsRequest.builder().applyMutation(listContactListsRequest).build());
    }

    /**
     * <p>
     * Lists all of the contact lists available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContactLists(software.amazon.awssdk.services.sesv2.model.ListContactListsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactListsIterable responses = client.listContactListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListContactListsIterable responses = client
     *             .listContactListsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListContactListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactListsIterable responses = client.listContactListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactLists(software.amazon.awssdk.services.sesv2.model.ListContactListsRequest)} operation.</b>
     * </p>
     *
     * @param listContactListsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListContactLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContactLists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactListsIterable listContactListsPaginator(ListContactListsRequest listContactListsRequest)
            throws BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListContactListsIterable(this, listContactListsRequest);
    }

    /**
     * <p>
     * Lists all of the contact lists available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContactLists(software.amazon.awssdk.services.sesv2.model.ListContactListsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactListsIterable responses = client.listContactListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListContactListsIterable responses = client
     *             .listContactListsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListContactListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactListsIterable responses = client.listContactListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactLists(software.amazon.awssdk.services.sesv2.model.ListContactListsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactListsRequest.Builder} avoiding the need
     * to create one manually via {@link ListContactListsRequest#builder()}
     * </p>
     *
     * @param listContactListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListContactListsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListContactLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContactLists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactListsIterable listContactListsPaginator(Consumer<ListContactListsRequest.Builder> listContactListsRequest)
            throws BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        return listContactListsPaginator(ListContactListsRequest.builder().applyMutation(listContactListsRequest).build());
    }

    /**
     * <p>
     * Lists the contacts present in a specific contact list.
     * </p>
     *
     * @param listContactsRequest
     * @return Result of the ListContacts operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactsResponse listContacts(ListContactsRequest listContactsRequest) throws BadRequestException,
            TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the contacts present in a specific contact list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContactsRequest#builder()}
     * </p>
     *
     * @param listContactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListContactsRequest.Builder} to create a request.
     * @return Result of the ListContacts operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactsResponse listContacts(Consumer<ListContactsRequest.Builder> listContactsRequest)
            throws BadRequestException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return listContacts(ListContactsRequest.builder().applyMutation(listContactsRequest).build());
    }

    /**
     * <p>
     * Lists the contacts present in a specific contact list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listContacts(software.amazon.awssdk.services.sesv2.model.ListContactsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactsIterable responses = client.listContactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListContactsIterable responses = client.listContactsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListContactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactsIterable responses = client.listContactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContacts(software.amazon.awssdk.services.sesv2.model.ListContactsRequest)} operation.</b>
     * </p>
     *
     * @param listContactsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactsIterable listContactsPaginator(ListContactsRequest listContactsRequest) throws BadRequestException,
            TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListContactsIterable(this, listContactsRequest);
    }

    /**
     * <p>
     * Lists the contacts present in a specific contact list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listContacts(software.amazon.awssdk.services.sesv2.model.ListContactsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactsIterable responses = client.listContactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListContactsIterable responses = client.listContactsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListContactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListContactsIterable responses = client.listContactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContacts(software.amazon.awssdk.services.sesv2.model.ListContactsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContactsRequest#builder()}
     * </p>
     *
     * @param listContactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListContactsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactsIterable listContactsPaginator(Consumer<ListContactsRequest.Builder> listContactsRequest)
            throws BadRequestException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return listContactsPaginator(ListContactsRequest.builder().applyMutation(listContactsRequest).build());
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current Amazon Web Services
     * Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        Represents a request to list the existing custom verification email templates for your account.
     * @return Result of the ListCustomVerificationEmailTemplates operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListCustomVerificationEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesResponse listCustomVerificationEmailTemplates(
            ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current Amazon Web Services
     * Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomVerificationEmailTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link ListCustomVerificationEmailTemplatesRequest#builder()}
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest.Builder} to
     *        create a request. Represents a request to list the existing custom verification email templates for your
     *        account.
     * @return Result of the ListCustomVerificationEmailTemplates operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListCustomVerificationEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesResponse listCustomVerificationEmailTemplates(
            Consumer<ListCustomVerificationEmailTemplatesRequest.Builder> listCustomVerificationEmailTemplatesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesRequest.builder()
                .applyMutation(listCustomVerificationEmailTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current Amazon Web Services
     * Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListCustomVerificationEmailTemplatesIterable responses = client.listCustomVerificationEmailTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListCustomVerificationEmailTemplatesIterable responses = client
     *             .listCustomVerificationEmailTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListCustomVerificationEmailTemplatesIterable responses = client.listCustomVerificationEmailTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        Represents a request to list the existing custom verification email templates for your account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListCustomVerificationEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesIterable listCustomVerificationEmailTemplatesPaginator(
            ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListCustomVerificationEmailTemplatesIterable(this, listCustomVerificationEmailTemplatesRequest);
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current Amazon Web Services
     * Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListCustomVerificationEmailTemplatesIterable responses = client.listCustomVerificationEmailTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListCustomVerificationEmailTemplatesIterable responses = client
     *             .listCustomVerificationEmailTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListCustomVerificationEmailTemplatesIterable responses = client.listCustomVerificationEmailTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomVerificationEmailTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link ListCustomVerificationEmailTemplatesRequest#builder()}
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest.Builder} to
     *        create a request. Represents a request to list the existing custom verification email templates for your
     *        account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListCustomVerificationEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesIterable listCustomVerificationEmailTemplatesPaginator(
            Consumer<ListCustomVerificationEmailTemplatesRequest.Builder> listCustomVerificationEmailTemplatesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listCustomVerificationEmailTemplatesPaginator(ListCustomVerificationEmailTemplatesRequest.builder()
                .applyMutation(listCustomVerificationEmailTemplatesRequest).build());
    }

    /**
     * <p>
     * List all of the dedicated IP pools that exist in your Amazon Web Services account in the current Region.
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A request to obtain a list of dedicated IP pools.
     * @return Result of the ListDedicatedIpPools operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListDedicatedIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDedicatedIpPoolsResponse listDedicatedIpPools(ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the dedicated IP pools that exist in your Amazon Web Services account in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDedicatedIpPoolsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDedicatedIpPoolsRequest#builder()}
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest.Builder} to create a
     *        request. A request to obtain a list of dedicated IP pools.
     * @return Result of the ListDedicatedIpPools operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListDedicatedIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDedicatedIpPoolsResponse listDedicatedIpPools(
            Consumer<ListDedicatedIpPoolsRequest.Builder> listDedicatedIpPoolsRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listDedicatedIpPools(ListDedicatedIpPoolsRequest.builder().applyMutation(listDedicatedIpPoolsRequest).build());
    }

    /**
     * <p>
     * List all of the dedicated IP pools that exist in your Amazon Web Services account in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDedicatedIpPools(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsIterable responses = client.listDedicatedIpPoolsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsIterable responses = client
     *             .listDedicatedIpPoolsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsIterable responses = client.listDedicatedIpPoolsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDedicatedIpPools(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A request to obtain a list of dedicated IP pools.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListDedicatedIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDedicatedIpPoolsIterable listDedicatedIpPoolsPaginator(ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListDedicatedIpPoolsIterable(this, listDedicatedIpPoolsRequest);
    }

    /**
     * <p>
     * List all of the dedicated IP pools that exist in your Amazon Web Services account in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDedicatedIpPools(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsIterable responses = client.listDedicatedIpPoolsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsIterable responses = client
     *             .listDedicatedIpPoolsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsIterable responses = client.listDedicatedIpPoolsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDedicatedIpPools(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDedicatedIpPoolsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDedicatedIpPoolsRequest#builder()}
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest.Builder} to create a
     *        request. A request to obtain a list of dedicated IP pools.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListDedicatedIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDedicatedIpPoolsIterable listDedicatedIpPoolsPaginator(
            Consumer<ListDedicatedIpPoolsRequest.Builder> listDedicatedIpPoolsRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listDedicatedIpPoolsPaginator(ListDedicatedIpPoolsRequest.builder().applyMutation(listDedicatedIpPoolsRequest)
                .build());
    }

    /**
     * <p>
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For
     * predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results.
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A request to list all of the predictive inbox placement tests that you've performed.
     * @return Result of the ListDeliverabilityTestReports operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListDeliverabilityTestReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeliverabilityTestReportsResponse listDeliverabilityTestReports(
            ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) throws TooManyRequestsException,
            NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For
     * predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeliverabilityTestReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDeliverabilityTestReportsRequest#builder()}
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest.Builder} to create
     *        a request. A request to list all of the predictive inbox placement tests that you've performed.
     * @return Result of the ListDeliverabilityTestReports operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListDeliverabilityTestReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeliverabilityTestReportsResponse listDeliverabilityTestReports(
            Consumer<ListDeliverabilityTestReportsRequest.Builder> listDeliverabilityTestReportsRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return listDeliverabilityTestReports(ListDeliverabilityTestReportsRequest.builder()
                .applyMutation(listDeliverabilityTestReportsRequest).build());
    }

    /**
     * <p>
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For
     * predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeliverabilityTestReports(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsIterable responses = client.listDeliverabilityTestReportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsIterable responses = client
     *             .listDeliverabilityTestReportsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsIterable responses = client.listDeliverabilityTestReportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeliverabilityTestReports(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A request to list all of the predictive inbox placement tests that you've performed.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListDeliverabilityTestReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeliverabilityTestReportsIterable listDeliverabilityTestReportsPaginator(
            ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) throws TooManyRequestsException,
            NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListDeliverabilityTestReportsIterable(this, listDeliverabilityTestReportsRequest);
    }

    /**
     * <p>
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For
     * predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeliverabilityTestReports(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsIterable responses = client.listDeliverabilityTestReportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsIterable responses = client
     *             .listDeliverabilityTestReportsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsIterable responses = client.listDeliverabilityTestReportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeliverabilityTestReports(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeliverabilityTestReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDeliverabilityTestReportsRequest#builder()}
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest.Builder} to create
     *        a request. A request to list all of the predictive inbox placement tests that you've performed.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListDeliverabilityTestReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeliverabilityTestReportsIterable listDeliverabilityTestReportsPaginator(
            Consumer<ListDeliverabilityTestReportsRequest.Builder> listDeliverabilityTestReportsRequest)
            throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return listDeliverabilityTestReportsPaginator(ListDeliverabilityTestReportsRequest.builder()
                .applyMutation(listDeliverabilityTestReportsRequest).build());
    }

    /**
     * <p>
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified
     * time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        Retrieve deliverability data for all the campaigns that used a specific domain to send email during a
     *        specified time range. This data is available for a domain only if you enabled the Deliverability
     *        dashboard.
     * @return Result of the ListDomainDeliverabilityCampaigns operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListDomainDeliverabilityCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainDeliverabilityCampaignsResponse listDomainDeliverabilityCampaigns(
            ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) throws TooManyRequestsException,
            BadRequestException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified
     * time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainDeliverabilityCampaignsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDomainDeliverabilityCampaignsRequest#builder()}
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest.Builder} to
     *        create a request. Retrieve deliverability data for all the campaigns that used a specific domain to send
     *        email during a specified time range. This data is available for a domain only if you enabled the
     *        Deliverability dashboard.
     * @return Result of the ListDomainDeliverabilityCampaigns operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListDomainDeliverabilityCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainDeliverabilityCampaignsResponse listDomainDeliverabilityCampaigns(
            Consumer<ListDomainDeliverabilityCampaignsRequest.Builder> listDomainDeliverabilityCampaignsRequest)
            throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return listDomainDeliverabilityCampaigns(ListDomainDeliverabilityCampaignsRequest.builder()
                .applyMutation(listDomainDeliverabilityCampaignsRequest).build());
    }

    /**
     * <p>
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified
     * time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomainDeliverabilityCampaigns(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsIterable responses = client.listDomainDeliverabilityCampaignsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsIterable responses = client
     *             .listDomainDeliverabilityCampaignsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsIterable responses = client.listDomainDeliverabilityCampaignsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainDeliverabilityCampaigns(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        Retrieve deliverability data for all the campaigns that used a specific domain to send email during a
     *        specified time range. This data is available for a domain only if you enabled the Deliverability
     *        dashboard.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListDomainDeliverabilityCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainDeliverabilityCampaignsIterable listDomainDeliverabilityCampaignsPaginator(
            ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) throws TooManyRequestsException,
            BadRequestException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListDomainDeliverabilityCampaignsIterable(this, listDomainDeliverabilityCampaignsRequest);
    }

    /**
     * <p>
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified
     * time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomainDeliverabilityCampaigns(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsIterable responses = client.listDomainDeliverabilityCampaignsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsIterable responses = client
     *             .listDomainDeliverabilityCampaignsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsIterable responses = client.listDomainDeliverabilityCampaignsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainDeliverabilityCampaigns(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainDeliverabilityCampaignsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDomainDeliverabilityCampaignsRequest#builder()}
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest.Builder} to
     *        create a request. Retrieve deliverability data for all the campaigns that used a specific domain to send
     *        email during a specified time range. This data is available for a domain only if you enabled the
     *        Deliverability dashboard.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListDomainDeliverabilityCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainDeliverabilityCampaignsIterable listDomainDeliverabilityCampaignsPaginator(
            Consumer<ListDomainDeliverabilityCampaignsRequest.Builder> listDomainDeliverabilityCampaignsRequest)
            throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return listDomainDeliverabilityCampaignsPaginator(ListDomainDeliverabilityCampaignsRequest.builder()
                .applyMutation(listDomainDeliverabilityCampaignsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the email identities that are associated with your Amazon Web Services account. An
     * identity can be either an email address or a domain. This operation returns identities that are verified as well
     * as those that aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A request to list all of the email identities associated with your Amazon Web Services account. This list
     *        includes identities that you've already verified, identities that are unverified, and identities that were
     *        verified in the past, but are no longer verified.
     * @return Result of the ListEmailIdentities operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListEmailIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailIdentitiesResponse listEmailIdentities(ListEmailIdentitiesRequest listEmailIdentitiesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the email identities that are associated with your Amazon Web Services account. An
     * identity can be either an email address or a domain. This operation returns identities that are verified as well
     * as those that aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailIdentitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEmailIdentitiesRequest#builder()}
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest.Builder} to create a
     *        request. A request to list all of the email identities associated with your Amazon Web Services account.
     *        This list includes identities that you've already verified, identities that are unverified, and identities
     *        that were verified in the past, but are no longer verified.
     * @return Result of the ListEmailIdentities operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListEmailIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailIdentitiesResponse listEmailIdentities(
            Consumer<ListEmailIdentitiesRequest.Builder> listEmailIdentitiesRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listEmailIdentities(ListEmailIdentitiesRequest.builder().applyMutation(listEmailIdentitiesRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the email identities that are associated with your Amazon Web Services account. An
     * identity can be either an email address or a domain. This operation returns identities that are verified as well
     * as those that aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEmailIdentities(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesIterable responses = client.listEmailIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesIterable responses = client
     *             .listEmailIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesIterable responses = client.listEmailIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailIdentities(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A request to list all of the email identities associated with your Amazon Web Services account. This list
     *        includes identities that you've already verified, identities that are unverified, and identities that were
     *        verified in the past, but are no longer verified.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListEmailIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailIdentitiesIterable listEmailIdentitiesPaginator(ListEmailIdentitiesRequest listEmailIdentitiesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListEmailIdentitiesIterable(this, listEmailIdentitiesRequest);
    }

    /**
     * <p>
     * Returns a list of all of the email identities that are associated with your Amazon Web Services account. An
     * identity can be either an email address or a domain. This operation returns identities that are verified as well
     * as those that aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEmailIdentities(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesIterable responses = client.listEmailIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesIterable responses = client
     *             .listEmailIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesIterable responses = client.listEmailIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailIdentities(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailIdentitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEmailIdentitiesRequest#builder()}
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest.Builder} to create a
     *        request. A request to list all of the email identities associated with your Amazon Web Services account.
     *        This list includes identities that you've already verified, identities that are unverified, and identities
     *        that were verified in the past, but are no longer verified.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListEmailIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailIdentitiesIterable listEmailIdentitiesPaginator(
            Consumer<ListEmailIdentitiesRequest.Builder> listEmailIdentitiesRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listEmailIdentitiesPaginator(ListEmailIdentitiesRequest.builder().applyMutation(listEmailIdentitiesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listEmailTemplatesRequest
     *        Represents a request to list the email templates present in your Amazon SES account in the current Amazon
     *        Web Services Region. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the ListEmailTemplates operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailTemplatesResponse listEmailTemplates(ListEmailTemplatesRequest listEmailTemplatesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEmailTemplatesRequest#builder()}
     * </p>
     *
     * @param listEmailTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest.Builder} to create a request.
     *        Represents a request to list the email templates present in your Amazon SES account in the current Amazon
     *        Web Services Region. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the ListEmailTemplates operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailTemplatesResponse listEmailTemplates(Consumer<ListEmailTemplatesRequest.Builder> listEmailTemplatesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listEmailTemplates(ListEmailTemplatesRequest.builder().applyMutation(listEmailTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailTemplatesIterable responses = client.listEmailTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListEmailTemplatesIterable responses = client
     *             .listEmailTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailTemplatesIterable responses = client.listEmailTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest)} operation.</b>
     * </p>
     *
     * @param listEmailTemplatesRequest
     *        Represents a request to list the email templates present in your Amazon SES account in the current Amazon
     *        Web Services Region. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailTemplatesIterable listEmailTemplatesPaginator(ListEmailTemplatesRequest listEmailTemplatesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListEmailTemplatesIterable(this, listEmailTemplatesRequest);
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailTemplatesIterable responses = client.listEmailTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListEmailTemplatesIterable responses = client
     *             .listEmailTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailTemplatesIterable responses = client.listEmailTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailTemplates(software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEmailTemplatesRequest#builder()}
     * </p>
     *
     * @param listEmailTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesRequest.Builder} to create a request.
     *        Represents a request to list the email templates present in your Amazon SES account in the current Amazon
     *        Web Services Region. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListEmailTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailTemplatesIterable listEmailTemplatesPaginator(
            Consumer<ListEmailTemplatesRequest.Builder> listEmailTemplatesRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listEmailTemplatesPaginator(ListEmailTemplatesRequest.builder().applyMutation(listEmailTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all of the export jobs.
     * </p>
     *
     * @param listExportJobsRequest
     *        Represents a request to list all export jobs with filters.
     * @return Result of the ListExportJobs operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportJobsResponse listExportJobs(ListExportJobsRequest listExportJobsRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportJobsRequest#builder()}
     * </p>
     *
     * @param listExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest.Builder} to create a request.
     *        Represents a request to list all export jobs with filters.
     * @return Result of the ListExportJobs operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportJobsResponse listExportJobs(Consumer<ListExportJobsRequest.Builder> listExportJobsRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listExportJobs(ListExportJobsRequest.builder().applyMutation(listExportJobsRequest).build());
    }

    /**
     * <p>
     * Lists all of the export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExportJobs(software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListExportJobsIterable responses = client.listExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListExportJobsIterable responses = client.listExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListExportJobsIterable responses = client.listExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExportJobs(software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest)} operation.</b>
     * </p>
     *
     * @param listExportJobsRequest
     *        Represents a request to list all export jobs with filters.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportJobsIterable listExportJobsPaginator(ListExportJobsRequest listExportJobsRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListExportJobsIterable(this, listExportJobsRequest);
    }

    /**
     * <p>
     * Lists all of the export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExportJobs(software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListExportJobsIterable responses = client.listExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListExportJobsIterable responses = client.listExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListExportJobsIterable responses = client.listExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExportJobs(software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportJobsRequest#builder()}
     * </p>
     *
     * @param listExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest.Builder} to create a request.
     *        Represents a request to list all export jobs with filters.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportJobsIterable listExportJobsPaginator(Consumer<ListExportJobsRequest.Builder> listExportJobsRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listExportJobsPaginator(ListExportJobsRequest.builder().applyMutation(listExportJobsRequest).build());
    }

    /**
     * <p>
     * Lists all of the import jobs.
     * </p>
     *
     * @param listImportJobsRequest
     *        Represents a request to list all of the import jobs for a data destination within the specified maximum
     *        number of import jobs.
     * @return Result of the ListImportJobs operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportJobsResponse listImportJobs(ListImportJobsRequest listImportJobsRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportJobsRequest#builder()}
     * </p>
     *
     * @param listImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest.Builder} to create a request.
     *        Represents a request to list all of the import jobs for a data destination within the specified maximum
     *        number of import jobs.
     * @return Result of the ListImportJobs operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportJobsResponse listImportJobs(Consumer<ListImportJobsRequest.Builder> listImportJobsRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listImportJobs(ListImportJobsRequest.builder().applyMutation(listImportJobsRequest).build());
    }

    /**
     * <p>
     * Lists all of the import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImportJobs(software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListImportJobsIterable responses = client.listImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListImportJobsIterable responses = client.listImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListImportJobsIterable responses = client.listImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportJobs(software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest)} operation.</b>
     * </p>
     *
     * @param listImportJobsRequest
     *        Represents a request to list all of the import jobs for a data destination within the specified maximum
     *        number of import jobs.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportJobsIterable listImportJobsPaginator(ListImportJobsRequest listImportJobsRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListImportJobsIterable(this, listImportJobsRequest);
    }

    /**
     * <p>
     * Lists all of the import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImportJobs(software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListImportJobsIterable responses = client.listImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListImportJobsIterable responses = client.listImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListImportJobsIterable responses = client.listImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportJobs(software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportJobsRequest#builder()}
     * </p>
     *
     * @param listImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest.Builder} to create a request.
     *        Represents a request to list all of the import jobs for a data destination within the specified maximum
     *        number of import jobs.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportJobsIterable listImportJobsPaginator(Consumer<ListImportJobsRequest.Builder> listImportJobsRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return listImportJobsPaginator(ListImportJobsRequest.builder().applyMutation(listImportJobsRequest).build());
    }

    /**
     * <p>
     * Lists the recommendations present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listRecommendationsRequest
     *        Represents a request to list the existing recommendations for your account.
     * @return Result of the ListRecommendations operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecommendationsResponse listRecommendations(ListRecommendationsRequest listRecommendationsRequest)
            throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the recommendations present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest.Builder} to create a
     *        request. Represents a request to list the existing recommendations for your account.
     * @return Result of the ListRecommendations operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecommendationsResponse listRecommendations(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) throws TooManyRequestsException,
            BadRequestException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        return listRecommendations(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest).build());
    }

    /**
     * <p>
     * Lists the recommendations present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListRecommendationsIterable responses = client.listRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListRecommendationsIterable responses = client
     *             .listRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListRecommendationsIterable responses = client.listRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendationsRequest
     *        Represents a request to list the existing recommendations for your account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecommendationsIterable listRecommendationsPaginator(ListRecommendationsRequest listRecommendationsRequest)
            throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return new ListRecommendationsIterable(this, listRecommendationsRequest);
    }

    /**
     * <p>
     * Lists the recommendations present in your Amazon SES account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListRecommendationsIterable responses = client.listRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListRecommendationsIterable responses = client
     *             .listRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListRecommendationsIterable responses = client.listRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest.Builder} to create a
     *        request. Represents a request to list the existing recommendations for your account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecommendationsIterable listRecommendationsPaginator(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) throws TooManyRequestsException,
            BadRequestException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        return listRecommendationsPaginator(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of email addresses that are on the suppression list for your account.
     * </p>
     *
     * @param listSuppressedDestinationsRequest
     *        A request to obtain a list of email destinations that are on the suppression list for your account.
     * @return Result of the ListSuppressedDestinations operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws InvalidNextTokenException
     *         The specified request includes an invalid or expired token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListSuppressedDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListSuppressedDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuppressedDestinationsResponse listSuppressedDestinations(
            ListSuppressedDestinationsRequest listSuppressedDestinationsRequest) throws BadRequestException,
            TooManyRequestsException, InvalidNextTokenException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of email addresses that are on the suppression list for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuppressedDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSuppressedDestinationsRequest#builder()}
     * </p>
     *
     * @param listSuppressedDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest.Builder} to create a
     *        request. A request to obtain a list of email destinations that are on the suppression list for your
     *        account.
     * @return Result of the ListSuppressedDestinations operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws InvalidNextTokenException
     *         The specified request includes an invalid or expired token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListSuppressedDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListSuppressedDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuppressedDestinationsResponse listSuppressedDestinations(
            Consumer<ListSuppressedDestinationsRequest.Builder> listSuppressedDestinationsRequest) throws BadRequestException,
            TooManyRequestsException, InvalidNextTokenException, AwsServiceException, SdkClientException, SesV2Exception {
        return listSuppressedDestinations(ListSuppressedDestinationsRequest.builder()
                .applyMutation(listSuppressedDestinationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of email addresses that are on the suppression list for your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSuppressedDestinations(software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsIterable responses = client.listSuppressedDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsIterable responses = client
     *             .listSuppressedDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsIterable responses = client.listSuppressedDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuppressedDestinations(software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSuppressedDestinationsRequest
     *        A request to obtain a list of email destinations that are on the suppression list for your account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws InvalidNextTokenException
     *         The specified request includes an invalid or expired token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListSuppressedDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListSuppressedDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuppressedDestinationsIterable listSuppressedDestinationsPaginator(
            ListSuppressedDestinationsRequest listSuppressedDestinationsRequest) throws BadRequestException,
            TooManyRequestsException, InvalidNextTokenException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListSuppressedDestinationsIterable(this, listSuppressedDestinationsRequest);
    }

    /**
     * <p>
     * Retrieves a list of email addresses that are on the suppression list for your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSuppressedDestinations(software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsIterable responses = client.listSuppressedDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsIterable responses = client
     *             .listSuppressedDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsIterable responses = client.listSuppressedDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuppressedDestinations(software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuppressedDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSuppressedDestinationsRequest#builder()}
     * </p>
     *
     * @param listSuppressedDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest.Builder} to create a
     *        request. A request to obtain a list of email destinations that are on the suppression list for your
     *        account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws InvalidNextTokenException
     *         The specified request includes an invalid or expired token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListSuppressedDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListSuppressedDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuppressedDestinationsIterable listSuppressedDestinationsPaginator(
            Consumer<ListSuppressedDestinationsRequest.Builder> listSuppressedDestinationsRequest) throws BadRequestException,
            TooManyRequestsException, InvalidNextTokenException, AwsServiceException, SdkClientException, SesV2Exception {
        return listSuppressedDestinationsPaginator(ListSuppressedDestinationsRequest.builder()
                .applyMutation(listSuppressedDestinationsRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of the tags (keys and values) that are associated with a specified resource. A <i>tag</i> is a
     * label that you optionally define and associate with a resource. Each tag consists of a required <i>tag
     * key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for
     * more specific tag values. A tag value acts as a descriptor within a tag key.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of the tags (keys and values) that are associated with a specified resource. A <i>tag</i> is a
     * label that you optionally define and associate with a resource. Each tag consists of a required <i>tag
     * key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for
     * more specific tag values. A tag value acts as a descriptor within a tag key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Enable or disable the automatic warm-up feature for dedicated IP addresses.
     * </p>
     *
     * @param putAccountDedicatedIpWarmupAttributesRequest
     *        A request to enable or disable the automatic IP address warm-up feature.
     * @return Result of the PutAccountDedicatedIpWarmupAttributes operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutAccountDedicatedIpWarmupAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAccountDedicatedIpWarmupAttributesResponse putAccountDedicatedIpWarmupAttributes(
            PutAccountDedicatedIpWarmupAttributesRequest putAccountDedicatedIpWarmupAttributesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable the automatic warm-up feature for dedicated IP addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutAccountDedicatedIpWarmupAttributesRequest.Builder} avoiding the need to create one manually via
     * {@link PutAccountDedicatedIpWarmupAttributesRequest#builder()}
     * </p>
     *
     * @param putAccountDedicatedIpWarmupAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesRequest.Builder}
     *        to create a request. A request to enable or disable the automatic IP address warm-up feature.
     * @return Result of the PutAccountDedicatedIpWarmupAttributes operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutAccountDedicatedIpWarmupAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAccountDedicatedIpWarmupAttributesResponse putAccountDedicatedIpWarmupAttributes(
            Consumer<PutAccountDedicatedIpWarmupAttributesRequest.Builder> putAccountDedicatedIpWarmupAttributesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return putAccountDedicatedIpWarmupAttributes(PutAccountDedicatedIpWarmupAttributesRequest.builder()
                .applyMutation(putAccountDedicatedIpWarmupAttributesRequest).build());
    }

    /**
     * <p>
     * Update your Amazon SES account details.
     * </p>
     *
     * @param putAccountDetailsRequest
     *        A request to submit new account details.
     * @return Result of the PutAccountDetails operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConflictException
     *         If there is already an ongoing account details update under review.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutAccountDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDetails" target="_top">AWS API
     *      Documentation</a>
     */
    default PutAccountDetailsResponse putAccountDetails(PutAccountDetailsRequest putAccountDetailsRequest)
            throws TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update your Amazon SES account details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountDetailsRequest.Builder} avoiding the need
     * to create one manually via {@link PutAccountDetailsRequest#builder()}
     * </p>
     *
     * @param putAccountDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutAccountDetailsRequest.Builder} to create a request.
     *        A request to submit new account details.
     * @return Result of the PutAccountDetails operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConflictException
     *         If there is already an ongoing account details update under review.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutAccountDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDetails" target="_top">AWS API
     *      Documentation</a>
     */
    default PutAccountDetailsResponse putAccountDetails(Consumer<PutAccountDetailsRequest.Builder> putAccountDetailsRequest)
            throws TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putAccountDetails(PutAccountDetailsRequest.builder().applyMutation(putAccountDetailsRequest).build());
    }

    /**
     * <p>
     * Enable or disable the ability of your account to send email.
     * </p>
     *
     * @param putAccountSendingAttributesRequest
     *        A request to change the ability of your account to send email.
     * @return Result of the PutAccountSendingAttributes operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutAccountSendingAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSendingAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAccountSendingAttributesResponse putAccountSendingAttributes(
            PutAccountSendingAttributesRequest putAccountSendingAttributesRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable the ability of your account to send email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountSendingAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutAccountSendingAttributesRequest#builder()}
     * </p>
     *
     * @param putAccountSendingAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest.Builder} to create a
     *        request. A request to change the ability of your account to send email.
     * @return Result of the PutAccountSendingAttributes operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutAccountSendingAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSendingAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAccountSendingAttributesResponse putAccountSendingAttributes(
            Consumer<PutAccountSendingAttributesRequest.Builder> putAccountSendingAttributesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return putAccountSendingAttributes(PutAccountSendingAttributesRequest.builder()
                .applyMutation(putAccountSendingAttributesRequest).build());
    }

    /**
     * <p>
     * Change the settings for the account-level suppression list.
     * </p>
     *
     * @param putAccountSuppressionAttributesRequest
     *        A request to change your account's suppression preferences.
     * @return Result of the PutAccountSuppressionAttributes operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutAccountSuppressionAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSuppressionAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAccountSuppressionAttributesResponse putAccountSuppressionAttributes(
            PutAccountSuppressionAttributesRequest putAccountSuppressionAttributesRequest) throws TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Change the settings for the account-level suppression list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountSuppressionAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutAccountSuppressionAttributesRequest#builder()}
     * </p>
     *
     * @param putAccountSuppressionAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesRequest.Builder} to
     *        create a request. A request to change your account's suppression preferences.
     * @return Result of the PutAccountSuppressionAttributes operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutAccountSuppressionAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSuppressionAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAccountSuppressionAttributesResponse putAccountSuppressionAttributes(
            Consumer<PutAccountSuppressionAttributesRequest.Builder> putAccountSuppressionAttributesRequest)
            throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return putAccountSuppressionAttributes(PutAccountSuppressionAttributesRequest.builder()
                .applyMutation(putAccountSuppressionAttributesRequest).build());
    }

    /**
     * <p>
     * Update your Amazon SES account VDM attributes.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param putAccountVdmAttributesRequest
     *        A request to submit new account VDM attributes.
     * @return Result of the PutAccountVdmAttributes operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutAccountVdmAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountVdmAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default PutAccountVdmAttributesResponse putAccountVdmAttributes(PutAccountVdmAttributesRequest putAccountVdmAttributesRequest)
            throws BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update your Amazon SES account VDM attributes.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountVdmAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link PutAccountVdmAttributesRequest#builder()}
     * </p>
     *
     * @param putAccountVdmAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutAccountVdmAttributesRequest.Builder} to create a
     *        request. A request to submit new account VDM attributes.
     * @return Result of the PutAccountVdmAttributes operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutAccountVdmAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountVdmAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default PutAccountVdmAttributesResponse putAccountVdmAttributes(
            Consumer<PutAccountVdmAttributesRequest.Builder> putAccountVdmAttributesRequest) throws BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        return putAccountVdmAttributes(PutAccountVdmAttributesRequest.builder().applyMutation(putAccountVdmAttributesRequest)
                .build());
    }

    /**
     * <p>
     * Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of
     * dedicated IP addresses for sending specific types of email.
     * </p>
     *
     * @param putConfigurationSetDeliveryOptionsRequest
     *        A request to associate a configuration set with a dedicated IP pool.
     * @return Result of the PutConfigurationSetDeliveryOptions operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutConfigurationSetDeliveryOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetDeliveryOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationSetDeliveryOptionsResponse putConfigurationSetDeliveryOptions(
            PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of
     * dedicated IP addresses for sending specific types of email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetDeliveryOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetDeliveryOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetDeliveryOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest.Builder} to
     *        create a request. A request to associate a configuration set with a dedicated IP pool.
     * @return Result of the PutConfigurationSetDeliveryOptions operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutConfigurationSetDeliveryOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetDeliveryOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationSetDeliveryOptionsResponse putConfigurationSetDeliveryOptions(
            Consumer<PutConfigurationSetDeliveryOptionsRequest.Builder> putConfigurationSetDeliveryOptionsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putConfigurationSetDeliveryOptions(PutConfigurationSetDeliveryOptionsRequest.builder()
                .applyMutation(putConfigurationSetDeliveryOptionsRequest).build());
    }

    /**
     * <p>
     * Enable or disable collection of reputation metrics for emails that you send using a particular configuration set
     * in a specific Amazon Web Services Region.
     * </p>
     *
     * @param putConfigurationSetReputationOptionsRequest
     *        A request to enable or disable tracking of reputation metrics for a configuration set.
     * @return Result of the PutConfigurationSetReputationOptions operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutConfigurationSetReputationOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetReputationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationSetReputationOptionsResponse putConfigurationSetReputationOptions(
            PutConfigurationSetReputationOptionsRequest putConfigurationSetReputationOptionsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable collection of reputation metrics for emails that you send using a particular configuration set
     * in a specific Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutConfigurationSetReputationOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link PutConfigurationSetReputationOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetReputationOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest.Builder} to
     *        create a request. A request to enable or disable tracking of reputation metrics for a configuration set.
     * @return Result of the PutConfigurationSetReputationOptions operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutConfigurationSetReputationOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetReputationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationSetReputationOptionsResponse putConfigurationSetReputationOptions(
            Consumer<PutConfigurationSetReputationOptionsRequest.Builder> putConfigurationSetReputationOptionsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putConfigurationSetReputationOptions(PutConfigurationSetReputationOptionsRequest.builder()
                .applyMutation(putConfigurationSetReputationOptionsRequest).build());
    }

    /**
     * <p>
     * Enable or disable email sending for messages that use a particular configuration set in a specific Amazon Web
     * Services Region.
     * </p>
     *
     * @param putConfigurationSetSendingOptionsRequest
     *        A request to enable or disable the ability of Amazon SES to send emails that use a specific configuration
     *        set.
     * @return Result of the PutConfigurationSetSendingOptions operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutConfigurationSetSendingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSendingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationSetSendingOptionsResponse putConfigurationSetSendingOptions(
            PutConfigurationSetSendingOptionsRequest putConfigurationSetSendingOptionsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable email sending for messages that use a particular configuration set in a specific Amazon Web
     * Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetSendingOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetSendingOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetSendingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest.Builder} to
     *        create a request. A request to enable or disable the ability of Amazon SES to send emails that use a
     *        specific configuration set.
     * @return Result of the PutConfigurationSetSendingOptions operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutConfigurationSetSendingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSendingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationSetSendingOptionsResponse putConfigurationSetSendingOptions(
            Consumer<PutConfigurationSetSendingOptionsRequest.Builder> putConfigurationSetSendingOptionsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putConfigurationSetSendingOptions(PutConfigurationSetSendingOptionsRequest.builder()
                .applyMutation(putConfigurationSetSendingOptionsRequest).build());
    }

    /**
     * <p>
     * Specify the account suppression list preferences for a configuration set.
     * </p>
     *
     * @param putConfigurationSetSuppressionOptionsRequest
     *        A request to change the account suppression list preferences for a specific configuration set.
     * @return Result of the PutConfigurationSetSuppressionOptions operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutConfigurationSetSuppressionOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSuppressionOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationSetSuppressionOptionsResponse putConfigurationSetSuppressionOptions(
            PutConfigurationSetSuppressionOptionsRequest putConfigurationSetSuppressionOptionsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify the account suppression list preferences for a configuration set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutConfigurationSetSuppressionOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link PutConfigurationSetSuppressionOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetSuppressionOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest.Builder}
     *        to create a request. A request to change the account suppression list preferences for a specific
     *        configuration set.
     * @return Result of the PutConfigurationSetSuppressionOptions operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutConfigurationSetSuppressionOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSuppressionOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationSetSuppressionOptionsResponse putConfigurationSetSuppressionOptions(
            Consumer<PutConfigurationSetSuppressionOptionsRequest.Builder> putConfigurationSetSuppressionOptionsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putConfigurationSetSuppressionOptions(PutConfigurationSetSuppressionOptionsRequest.builder()
                .applyMutation(putConfigurationSetSuppressionOptionsRequest).build());
    }

    /**
     * <p>
     * Specify a custom domain to use for open and click tracking elements in email that you send.
     * </p>
     *
     * @param putConfigurationSetTrackingOptionsRequest
     *        A request to add a custom domain for tracking open and click events to a configuration set.
     * @return Result of the PutConfigurationSetTrackingOptions operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutConfigurationSetTrackingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationSetTrackingOptionsResponse putConfigurationSetTrackingOptions(
            PutConfigurationSetTrackingOptionsRequest putConfigurationSetTrackingOptionsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify a custom domain to use for open and click tracking elements in email that you send.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetTrackingOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetTrackingOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetTrackingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest.Builder} to
     *        create a request. A request to add a custom domain for tracking open and click events to a configuration
     *        set.
     * @return Result of the PutConfigurationSetTrackingOptions operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutConfigurationSetTrackingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationSetTrackingOptionsResponse putConfigurationSetTrackingOptions(
            Consumer<PutConfigurationSetTrackingOptionsRequest.Builder> putConfigurationSetTrackingOptionsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putConfigurationSetTrackingOptions(PutConfigurationSetTrackingOptionsRequest.builder()
                .applyMutation(putConfigurationSetTrackingOptionsRequest).build());
    }

    /**
     * <p>
     * Specify VDM preferences for email that you send using the configuration set.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param putConfigurationSetVdmOptionsRequest
     *        A request to add specific VDM settings to a configuration set.
     * @return Result of the PutConfigurationSetVdmOptions operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutConfigurationSetVdmOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetVdmOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationSetVdmOptionsResponse putConfigurationSetVdmOptions(
            PutConfigurationSetVdmOptionsRequest putConfigurationSetVdmOptionsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify VDM preferences for email that you send using the configuration set.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetVdmOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetVdmOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetVdmOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsRequest.Builder} to create
     *        a request. A request to add specific VDM settings to a configuration set.
     * @return Result of the PutConfigurationSetVdmOptions operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutConfigurationSetVdmOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetVdmOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationSetVdmOptionsResponse putConfigurationSetVdmOptions(
            Consumer<PutConfigurationSetVdmOptionsRequest.Builder> putConfigurationSetVdmOptionsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putConfigurationSetVdmOptions(PutConfigurationSetVdmOptionsRequest.builder()
                .applyMutation(putConfigurationSetVdmOptionsRequest).build());
    }

    /**
     * <p>
     * Move a dedicated IP address to an existing dedicated IP pool.
     * </p>
     * <note>
     * <p>
     * The dedicated IP address that you specify must already exist, and must be associated with your Amazon Web
     * Services account.
     * </p>
     * <p>
     * The dedicated IP pool you specify must already exist. You can create a new pool by using the
     * <code>CreateDedicatedIpPool</code> operation.
     * </p>
     * </note>
     *
     * @param putDedicatedIpInPoolRequest
     *        A request to move a dedicated IP address to a dedicated IP pool.
     * @return Result of the PutDedicatedIpInPool operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutDedicatedIpInPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpInPool" target="_top">AWS
     *      API Documentation</a>
     */
    default PutDedicatedIpInPoolResponse putDedicatedIpInPool(PutDedicatedIpInPoolRequest putDedicatedIpInPoolRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Move a dedicated IP address to an existing dedicated IP pool.
     * </p>
     * <note>
     * <p>
     * The dedicated IP address that you specify must already exist, and must be associated with your Amazon Web
     * Services account.
     * </p>
     * <p>
     * The dedicated IP pool you specify must already exist. You can create a new pool by using the
     * <code>CreateDedicatedIpPool</code> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDedicatedIpInPoolRequest.Builder} avoiding the
     * need to create one manually via {@link PutDedicatedIpInPoolRequest#builder()}
     * </p>
     *
     * @param putDedicatedIpInPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolRequest.Builder} to create a
     *        request. A request to move a dedicated IP address to a dedicated IP pool.
     * @return Result of the PutDedicatedIpInPool operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutDedicatedIpInPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpInPool" target="_top">AWS
     *      API Documentation</a>
     */
    default PutDedicatedIpInPoolResponse putDedicatedIpInPool(
            Consumer<PutDedicatedIpInPoolRequest.Builder> putDedicatedIpInPoolRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return putDedicatedIpInPool(PutDedicatedIpInPoolRequest.builder().applyMutation(putDedicatedIpInPoolRequest).build());
    }

    /**
     * <p>
     * Used to convert a dedicated IP pool to a different scaling mode.
     * </p>
     * <note>
     * <p>
     * <code>MANAGED</code> pools cannot be converted to <code>STANDARD</code> scaling mode.
     * </p>
     * </note>
     *
     * @param putDedicatedIpPoolScalingAttributesRequest
     *        A request to convert a dedicated IP pool to a different scaling mode.
     * @return Result of the PutDedicatedIpPoolScalingAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutDedicatedIpPoolScalingAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpPoolScalingAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDedicatedIpPoolScalingAttributesResponse putDedicatedIpPoolScalingAttributes(
            PutDedicatedIpPoolScalingAttributesRequest putDedicatedIpPoolScalingAttributesRequest) throws NotFoundException,
            ConcurrentModificationException, TooManyRequestsException, BadRequestException, AwsServiceException,
            SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to convert a dedicated IP pool to a different scaling mode.
     * </p>
     * <note>
     * <p>
     * <code>MANAGED</code> pools cannot be converted to <code>STANDARD</code> scaling mode.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDedicatedIpPoolScalingAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutDedicatedIpPoolScalingAttributesRequest#builder()}
     * </p>
     *
     * @param putDedicatedIpPoolScalingAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest.Builder} to
     *        create a request. A request to convert a dedicated IP pool to a different scaling mode.
     * @return Result of the PutDedicatedIpPoolScalingAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutDedicatedIpPoolScalingAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpPoolScalingAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDedicatedIpPoolScalingAttributesResponse putDedicatedIpPoolScalingAttributes(
            Consumer<PutDedicatedIpPoolScalingAttributesRequest.Builder> putDedicatedIpPoolScalingAttributesRequest)
            throws NotFoundException, ConcurrentModificationException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, SesV2Exception {
        return putDedicatedIpPoolScalingAttributes(PutDedicatedIpPoolScalingAttributesRequest.builder()
                .applyMutation(putDedicatedIpPoolScalingAttributesRequest).build());
    }

    /**
     * <p/>
     *
     * @param putDedicatedIpWarmupAttributesRequest
     *        A request to change the warm-up attributes for a dedicated IP address. This operation is useful when you
     *        want to resume the warm-up process for an existing IP address.
     * @return Result of the PutDedicatedIpWarmupAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutDedicatedIpWarmupAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDedicatedIpWarmupAttributesResponse putDedicatedIpWarmupAttributes(
            PutDedicatedIpWarmupAttributesRequest putDedicatedIpWarmupAttributesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDedicatedIpWarmupAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutDedicatedIpWarmupAttributesRequest#builder()}
     * </p>
     *
     * @param putDedicatedIpWarmupAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest.Builder} to
     *        create a request. A request to change the warm-up attributes for a dedicated IP address. This operation is
     *        useful when you want to resume the warm-up process for an existing IP address.
     * @return Result of the PutDedicatedIpWarmupAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutDedicatedIpWarmupAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDedicatedIpWarmupAttributesResponse putDedicatedIpWarmupAttributes(
            Consumer<PutDedicatedIpWarmupAttributesRequest.Builder> putDedicatedIpWarmupAttributesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putDedicatedIpWarmupAttributes(PutDedicatedIpWarmupAttributesRequest.builder()
                .applyMutation(putDedicatedIpWarmupAttributesRequest).build());
    }

    /**
     * <p>
     * Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to
     * reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the
     * ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the
     * features and cost of a Deliverability dashboard subscription, see <a
     * href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.
     * </p>
     *
     * @param putDeliverabilityDashboardOptionRequest
     *        Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain
     *        access to reputation, deliverability, and other metrics for the domains that you use to send email using
     *        Amazon SES API v2. You also gain the ability to perform predictive inbox placement tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information
     *        about the features and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return Result of the PutDeliverabilityDashboardOption operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutDeliverabilityDashboardOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDeliverabilityDashboardOption"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDeliverabilityDashboardOptionResponse putDeliverabilityDashboardOption(
            PutDeliverabilityDashboardOptionRequest putDeliverabilityDashboardOptionRequest) throws AlreadyExistsException,
            NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException,
            SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to
     * reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the
     * ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the
     * features and cost of a Deliverability dashboard subscription, see <a
     * href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDeliverabilityDashboardOptionRequest.Builder}
     * avoiding the need to create one manually via {@link PutDeliverabilityDashboardOptionRequest#builder()}
     * </p>
     *
     * @param putDeliverabilityDashboardOptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest.Builder} to
     *        create a request. Enable or disable the Deliverability dashboard. When you enable the Deliverability
     *        dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use
     *        to send email using Amazon SES API v2. You also gain the ability to perform predictive inbox placement
     *        tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information
     *        about the features and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return Result of the PutDeliverabilityDashboardOption operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource specified in your request already exists.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutDeliverabilityDashboardOption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDeliverabilityDashboardOption"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDeliverabilityDashboardOptionResponse putDeliverabilityDashboardOption(
            Consumer<PutDeliverabilityDashboardOptionRequest.Builder> putDeliverabilityDashboardOptionRequest)
            throws AlreadyExistsException, NotFoundException, TooManyRequestsException, LimitExceededException,
            BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return putDeliverabilityDashboardOption(PutDeliverabilityDashboardOptionRequest.builder()
                .applyMutation(putDeliverabilityDashboardOptionRequest).build());
    }

    /**
     * <p>
     * Used to associate a configuration set with an email identity.
     * </p>
     *
     * @param putEmailIdentityConfigurationSetAttributesRequest
     *        A request to associate a configuration set with an email identity.
     * @return Result of the PutEmailIdentityConfigurationSetAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutEmailIdentityConfigurationSetAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityConfigurationSetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEmailIdentityConfigurationSetAttributesResponse putEmailIdentityConfigurationSetAttributes(
            PutEmailIdentityConfigurationSetAttributesRequest putEmailIdentityConfigurationSetAttributesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to associate a configuration set with an email identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutEmailIdentityConfigurationSetAttributesRequest.Builder} avoiding the need to create one manually via
     * {@link PutEmailIdentityConfigurationSetAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityConfigurationSetAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest.Builder}
     *        to create a request. A request to associate a configuration set with an email identity.
     * @return Result of the PutEmailIdentityConfigurationSetAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutEmailIdentityConfigurationSetAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityConfigurationSetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEmailIdentityConfigurationSetAttributesResponse putEmailIdentityConfigurationSetAttributes(
            Consumer<PutEmailIdentityConfigurationSetAttributesRequest.Builder> putEmailIdentityConfigurationSetAttributesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putEmailIdentityConfigurationSetAttributes(PutEmailIdentityConfigurationSetAttributesRequest.builder()
                .applyMutation(putEmailIdentityConfigurationSetAttributesRequest).build());
    }

    /**
     * <p>
     * Used to enable or disable DKIM authentication for an email identity.
     * </p>
     *
     * @param putEmailIdentityDkimAttributesRequest
     *        A request to enable or disable DKIM signing of email that you send from an email identity.
     * @return Result of the PutEmailIdentityDkimAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutEmailIdentityDkimAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEmailIdentityDkimAttributesResponse putEmailIdentityDkimAttributes(
            PutEmailIdentityDkimAttributesRequest putEmailIdentityDkimAttributesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to enable or disable DKIM authentication for an email identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEmailIdentityDkimAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutEmailIdentityDkimAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityDkimAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest.Builder} to
     *        create a request. A request to enable or disable DKIM signing of email that you send from an email
     *        identity.
     * @return Result of the PutEmailIdentityDkimAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutEmailIdentityDkimAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEmailIdentityDkimAttributesResponse putEmailIdentityDkimAttributes(
            Consumer<PutEmailIdentityDkimAttributesRequest.Builder> putEmailIdentityDkimAttributesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putEmailIdentityDkimAttributes(PutEmailIdentityDkimAttributesRequest.builder()
                .applyMutation(putEmailIdentityDkimAttributesRequest).build());
    }

    /**
     * <p>
     * Used to configure or change the DKIM authentication settings for an email domain identity. You can use this
     * operation to do any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Update the signing attributes for an identity that uses Bring Your Own DKIM (BYODKIM).
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the key length that should be used for Easy DKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using no DKIM authentication to using Easy DKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using no DKIM authentication to using BYODKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using Easy DKIM to using BYODKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using BYODKIM to using Easy DKIM.
     * </p>
     * </li>
     * </ul>
     *
     * @param putEmailIdentityDkimSigningAttributesRequest
     *        A request to change the DKIM attributes for an email identity.
     * @return Result of the PutEmailIdentityDkimSigningAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutEmailIdentityDkimSigningAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimSigningAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEmailIdentityDkimSigningAttributesResponse putEmailIdentityDkimSigningAttributes(
            PutEmailIdentityDkimSigningAttributesRequest putEmailIdentityDkimSigningAttributesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to configure or change the DKIM authentication settings for an email domain identity. You can use this
     * operation to do any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Update the signing attributes for an identity that uses Bring Your Own DKIM (BYODKIM).
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the key length that should be used for Easy DKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using no DKIM authentication to using Easy DKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using no DKIM authentication to using BYODKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using Easy DKIM to using BYODKIM.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change from using BYODKIM to using Easy DKIM.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutEmailIdentityDkimSigningAttributesRequest.Builder} avoiding the need to create one manually via
     * {@link PutEmailIdentityDkimSigningAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityDkimSigningAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest.Builder}
     *        to create a request. A request to change the DKIM attributes for an email identity.
     * @return Result of the PutEmailIdentityDkimSigningAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutEmailIdentityDkimSigningAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimSigningAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEmailIdentityDkimSigningAttributesResponse putEmailIdentityDkimSigningAttributes(
            Consumer<PutEmailIdentityDkimSigningAttributesRequest.Builder> putEmailIdentityDkimSigningAttributesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putEmailIdentityDkimSigningAttributes(PutEmailIdentityDkimSigningAttributesRequest.builder()
                .applyMutation(putEmailIdentityDkimSigningAttributesRequest).build());
    }

    /**
     * <p>
     * Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an
     * identity is used to send an email that results in a bounce or complaint event.
     * </p>
     * <p>
     * If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These
     * notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original
     * email.
     * </p>
     * <p>
     * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for
     * receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an
     * email notification when these events occur (even if this setting is disabled).
     * </p>
     *
     * @param putEmailIdentityFeedbackAttributesRequest
     *        A request to set the attributes that control how bounce and complaint events are processed.
     * @return Result of the PutEmailIdentityFeedbackAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutEmailIdentityFeedbackAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityFeedbackAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEmailIdentityFeedbackAttributesResponse putEmailIdentityFeedbackAttributes(
            PutEmailIdentityFeedbackAttributesRequest putEmailIdentityFeedbackAttributesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an
     * identity is used to send an email that results in a bounce or complaint event.
     * </p>
     * <p>
     * If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These
     * notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original
     * email.
     * </p>
     * <p>
     * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for
     * receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an
     * email notification when these events occur (even if this setting is disabled).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEmailIdentityFeedbackAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutEmailIdentityFeedbackAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityFeedbackAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest.Builder} to
     *        create a request. A request to set the attributes that control how bounce and complaint events are
     *        processed.
     * @return Result of the PutEmailIdentityFeedbackAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutEmailIdentityFeedbackAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityFeedbackAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEmailIdentityFeedbackAttributesResponse putEmailIdentityFeedbackAttributes(
            Consumer<PutEmailIdentityFeedbackAttributesRequest.Builder> putEmailIdentityFeedbackAttributesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putEmailIdentityFeedbackAttributes(PutEmailIdentityFeedbackAttributesRequest.builder()
                .applyMutation(putEmailIdentityFeedbackAttributesRequest).build());
    }

    /**
     * <p>
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     * </p>
     *
     * @param putEmailIdentityMailFromAttributesRequest
     *        A request to configure the custom MAIL FROM domain for a verified identity.
     * @return Result of the PutEmailIdentityMailFromAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutEmailIdentityMailFromAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityMailFromAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEmailIdentityMailFromAttributesResponse putEmailIdentityMailFromAttributes(
            PutEmailIdentityMailFromAttributesRequest putEmailIdentityMailFromAttributesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEmailIdentityMailFromAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutEmailIdentityMailFromAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityMailFromAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest.Builder} to
     *        create a request. A request to configure the custom MAIL FROM domain for a verified identity.
     * @return Result of the PutEmailIdentityMailFromAttributes operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutEmailIdentityMailFromAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityMailFromAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEmailIdentityMailFromAttributesResponse putEmailIdentityMailFromAttributes(
            Consumer<PutEmailIdentityMailFromAttributesRequest.Builder> putEmailIdentityMailFromAttributesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return putEmailIdentityMailFromAttributes(PutEmailIdentityMailFromAttributesRequest.builder()
                .applyMutation(putEmailIdentityMailFromAttributesRequest).build());
    }

    /**
     * <p>
     * Adds an email address to the suppression list for your account.
     * </p>
     *
     * @param putSuppressedDestinationRequest
     *        A request to add an email destination to the suppression list for your account.
     * @return Result of the PutSuppressedDestination operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default PutSuppressedDestinationResponse putSuppressedDestination(
            PutSuppressedDestinationRequest putSuppressedDestinationRequest) throws BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an email address to the suppression list for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSuppressedDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link PutSuppressedDestinationRequest#builder()}
     * </p>
     *
     * @param putSuppressedDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationRequest.Builder} to create a
     *        request. A request to add an email destination to the suppression list for your account.
     * @return Result of the PutSuppressedDestination operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.PutSuppressedDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutSuppressedDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default PutSuppressedDestinationResponse putSuppressedDestination(
            Consumer<PutSuppressedDestinationRequest.Builder> putSuppressedDestinationRequest) throws BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        return putSuppressedDestination(PutSuppressedDestinationRequest.builder().applyMutation(putSuppressedDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Composes an email message to multiple destinations.
     * </p>
     *
     * @param sendBulkEmailRequest
     *        Represents a request to send email messages to multiple destinations using Amazon SES. For more
     *        information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SendBulkEmail operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws AccountSuspendedException
     *         The message can't be sent because the account's ability to send email has been permanently restricted.
     * @throws SendingPausedException
     *         The message can't be sent because the account's ability to send email is currently paused.
     * @throws MessageRejectedException
     *         The message can't be sent because it contains invalid content.
     * @throws MailFromDomainNotVerifiedException
     *         The message can't be sent because the sending domain isn't verified.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.SendBulkEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendBulkEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default SendBulkEmailResponse sendBulkEmail(SendBulkEmailRequest sendBulkEmailRequest) throws TooManyRequestsException,
            LimitExceededException, AccountSuspendedException, SendingPausedException, MessageRejectedException,
            MailFromDomainNotVerifiedException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Composes an email message to multiple destinations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendBulkEmailRequest.Builder} avoiding the need to
     * create one manually via {@link SendBulkEmailRequest#builder()}
     * </p>
     *
     * @param sendBulkEmailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.SendBulkEmailRequest.Builder} to create a request.
     *        Represents a request to send email messages to multiple destinations using Amazon SES. For more
     *        information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SendBulkEmail operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws AccountSuspendedException
     *         The message can't be sent because the account's ability to send email has been permanently restricted.
     * @throws SendingPausedException
     *         The message can't be sent because the account's ability to send email is currently paused.
     * @throws MessageRejectedException
     *         The message can't be sent because it contains invalid content.
     * @throws MailFromDomainNotVerifiedException
     *         The message can't be sent because the sending domain isn't verified.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.SendBulkEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendBulkEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default SendBulkEmailResponse sendBulkEmail(Consumer<SendBulkEmailRequest.Builder> sendBulkEmailRequest)
            throws TooManyRequestsException, LimitExceededException, AccountSuspendedException, SendingPausedException,
            MessageRejectedException, MailFromDomainNotVerifiedException, NotFoundException, BadRequestException,
            AwsServiceException, SdkClientException, SesV2Exception {
        return sendBulkEmail(SendBulkEmailRequest.builder().applyMutation(sendBulkEmailRequest).build());
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services
     * Region and attempts to verify it. As a result of executing this operation, a customized verification email is
     * sent to the specified address.
     * </p>
     * <p>
     * To use this operation, you must first create a custom verification email template. For more information about
     * creating and using custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param sendCustomVerificationEmailRequest
     *        Represents a request to send a custom verification email to a specified recipient.
     * @return Result of the SendCustomVerificationEmail operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws MessageRejectedException
     *         The message can't be sent because it contains invalid content.
     * @throws SendingPausedException
     *         The message can't be sent because the account's ability to send email is currently paused.
     * @throws MailFromDomainNotVerifiedException
     *         The message can't be sent because the sending domain isn't verified.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.SendCustomVerificationEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendCustomVerificationEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default SendCustomVerificationEmailResponse sendCustomVerificationEmail(
            SendCustomVerificationEmailRequest sendCustomVerificationEmailRequest) throws TooManyRequestsException,
            LimitExceededException, MessageRejectedException, SendingPausedException, MailFromDomainNotVerifiedException,
            NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services
     * Region and attempts to verify it. As a result of executing this operation, a customized verification email is
     * sent to the specified address.
     * </p>
     * <p>
     * To use this operation, you must first create a custom verification email template. For more information about
     * creating and using custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendCustomVerificationEmailRequest.Builder}
     * avoiding the need to create one manually via {@link SendCustomVerificationEmailRequest#builder()}
     * </p>
     *
     * @param sendCustomVerificationEmailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailRequest.Builder} to create a
     *        request. Represents a request to send a custom verification email to a specified recipient.
     * @return Result of the SendCustomVerificationEmail operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws MessageRejectedException
     *         The message can't be sent because it contains invalid content.
     * @throws SendingPausedException
     *         The message can't be sent because the account's ability to send email is currently paused.
     * @throws MailFromDomainNotVerifiedException
     *         The message can't be sent because the sending domain isn't verified.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.SendCustomVerificationEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendCustomVerificationEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default SendCustomVerificationEmailResponse sendCustomVerificationEmail(
            Consumer<SendCustomVerificationEmailRequest.Builder> sendCustomVerificationEmailRequest)
            throws TooManyRequestsException, LimitExceededException, MessageRejectedException, SendingPausedException,
            MailFromDomainNotVerifiedException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return sendCustomVerificationEmail(SendCustomVerificationEmailRequest.builder()
                .applyMutation(sendCustomVerificationEmailRequest).build());
    }

    /**
     * <p>
     * Sends an email message. You can use the Amazon SES API v2 to send the following types of messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Simple</b> – A standard email message. When you create this type of message, you specify the sender, the
     * recipient, and the message body, and Amazon SES assembles the message for you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Raw</b> – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of
     * the message headers, as well as the message body. You can use this message type to send messages that contain
     * attachments. The message that you specify has to be a valid MIME message.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Templated</b> – A message that contains personalization tags. When you send this type of email, Amazon SES API
     * v2 automatically replaces the tags with values that you specify.
     * </p>
     * </li>
     * </ul>
     *
     * @param sendEmailRequest
     *        Represents a request to send a single formatted email using Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SendEmail operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws AccountSuspendedException
     *         The message can't be sent because the account's ability to send email has been permanently restricted.
     * @throws SendingPausedException
     *         The message can't be sent because the account's ability to send email is currently paused.
     * @throws MessageRejectedException
     *         The message can't be sent because it contains invalid content.
     * @throws MailFromDomainNotVerifiedException
     *         The message can't be sent because the sending domain isn't verified.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.SendEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default SendEmailResponse sendEmail(SendEmailRequest sendEmailRequest) throws TooManyRequestsException,
            LimitExceededException, AccountSuspendedException, SendingPausedException, MessageRejectedException,
            MailFromDomainNotVerifiedException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends an email message. You can use the Amazon SES API v2 to send the following types of messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Simple</b> – A standard email message. When you create this type of message, you specify the sender, the
     * recipient, and the message body, and Amazon SES assembles the message for you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Raw</b> – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of
     * the message headers, as well as the message body. You can use this message type to send messages that contain
     * attachments. The message that you specify has to be a valid MIME message.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Templated</b> – A message that contains personalization tags. When you send this type of email, Amazon SES API
     * v2 automatically replaces the tags with values that you specify.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendEmailRequest.Builder} avoiding the need to
     * create one manually via {@link SendEmailRequest#builder()}
     * </p>
     *
     * @param sendEmailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.SendEmailRequest.Builder} to create a request.
     *        Represents a request to send a single formatted email using Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the SendEmail operation returned by the service.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws LimitExceededException
     *         There are too many instances of the specified resource type.
     * @throws AccountSuspendedException
     *         The message can't be sent because the account's ability to send email has been permanently restricted.
     * @throws SendingPausedException
     *         The message can't be sent because the account's ability to send email is currently paused.
     * @throws MessageRejectedException
     *         The message can't be sent because it contains invalid content.
     * @throws MailFromDomainNotVerifiedException
     *         The message can't be sent because the sending domain isn't verified.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.SendEmail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default SendEmailResponse sendEmail(Consumer<SendEmailRequest.Builder> sendEmailRequest) throws TooManyRequestsException,
            LimitExceededException, AccountSuspendedException, SendingPausedException, MessageRejectedException,
            MailFromDomainNotVerifiedException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return sendEmail(SendEmailRequest.builder().applyMutation(sendEmailRequest).build());
    }

    /**
     * <p>
     * Add one or more tags (keys and values) to a specified resource. A <i>tag</i> is a label that you optionally
     * define and associate with a resource. Tags can help you categorize and manage resources in different ways, such
     * as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.
     * </p>
     * <p>
     * Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A
     * tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor
     * within a tag key.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add one or more tags (keys and values) to a specified resource. A <i>tag</i> is a label that you optionally
     * define and associate with a resource. Tags can help you categorize and manage resources in different ways, such
     * as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.
     * </p>
     * <p>
     * Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A
     * tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor
     * within a tag key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, SesV2Exception {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param testRenderEmailTemplateRequest
     *        &gt;Represents a request to create a preview of the MIME content of an email when provided with a template
     *        and a set of replacement data.
     * @return Result of the TestRenderEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.TestRenderEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TestRenderEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default TestRenderEmailTemplateResponse testRenderEmailTemplate(TestRenderEmailTemplateRequest testRenderEmailTemplateRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestRenderEmailTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link TestRenderEmailTemplateRequest#builder()}
     * </p>
     *
     * @param testRenderEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateRequest.Builder} to create a
     *        request. &gt;Represents a request to create a preview of the MIME content of an email when provided with a
     *        template and a set of replacement data.
     * @return Result of the TestRenderEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.TestRenderEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TestRenderEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default TestRenderEmailTemplateResponse testRenderEmailTemplate(
            Consumer<TestRenderEmailTemplateRequest.Builder> testRenderEmailTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return testRenderEmailTemplate(TestRenderEmailTemplateRequest.builder().applyMutation(testRenderEmailTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, SesV2Exception {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update the configuration of an event destination for a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        A request to change the settings for an event destination for a configuration set.
     * @return Result of the UpdateConfigurationSetEventDestination operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UpdateConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestination(
            UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the configuration of an event destination for a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. A request to change the settings for an event destination for a configuration set.
     * @return Result of the UpdateConfigurationSetEventDestination operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UpdateConfigurationSetEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestination(
            Consumer<UpdateConfigurationSetEventDestinationRequest.Builder> updateConfigurationSetEventDestinationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest.builder()
                .applyMutation(updateConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Updates a contact's preferences for a list. It is not necessary to specify all existing topic preferences in the
     * TopicPreferences object, just the ones that need updating.
     * </p>
     *
     * @param updateContactRequest
     * @return Result of the UpdateContact operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UpdateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateContact" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateContactResponse updateContact(UpdateContactRequest updateContactRequest) throws BadRequestException,
            TooManyRequestsException, NotFoundException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a contact's preferences for a list. It is not necessary to specify all existing topic preferences in the
     * TopicPreferences object, just the ones that need updating.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateContactRequest#builder()}
     * </p>
     *
     * @param updateContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateContactRequest.Builder} to create a request.
     * @return Result of the UpdateContact operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UpdateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateContact" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateContactResponse updateContact(Consumer<UpdateContactRequest.Builder> updateContactRequest)
            throws BadRequestException, TooManyRequestsException, NotFoundException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, SesV2Exception {
        return updateContact(UpdateContactRequest.builder().applyMutation(updateContactRequest).build());
    }

    /**
     * <p>
     * Updates contact list metadata. This operation does a complete replacement.
     * </p>
     *
     * @param updateContactListRequest
     * @return Result of the UpdateContactList operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UpdateContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateContactListResponse updateContactList(UpdateContactListRequest updateContactListRequest)
            throws BadRequestException, TooManyRequestsException, NotFoundException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates contact list metadata. This operation does a complete replacement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactListRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateContactListRequest#builder()}
     * </p>
     *
     * @param updateContactListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateContactListRequest.Builder} to create a request.
     * @return Result of the UpdateContactList operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws ConcurrentModificationException
     *         The resource is being modified by another operation or thread.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UpdateContactList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateContactList" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateContactListResponse updateContactList(Consumer<UpdateContactListRequest.Builder> updateContactListRequest)
            throws BadRequestException, TooManyRequestsException, NotFoundException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, SesV2Exception {
        return updateContactList(UpdateContactListRequest.builder().applyMutation(updateContactListRequest).build());
    }

    /**
     * <p>
     * Updates an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateCustomVerificationEmailTemplateRequest
     *        Represents a request to update an existing custom verification email template.
     * @return Result of the UpdateCustomVerificationEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UpdateCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomVerificationEmailTemplateResponse updateCustomVerificationEmailTemplate(
            UpdateCustomVerificationEmailTemplateRequest updateCustomVerificationEmailTemplateRequest) throws NotFoundException,
            BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom">Using
     * custom verification email templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateCustomVerificationEmailTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param updateCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateRequest.Builder}
     *        to create a request. Represents a request to update an existing custom verification email template.
     * @return Result of the UpdateCustomVerificationEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UpdateCustomVerificationEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomVerificationEmailTemplateResponse updateCustomVerificationEmailTemplate(
            Consumer<UpdateCustomVerificationEmailTemplateRequest.Builder> updateCustomVerificationEmailTemplateRequest)
            throws NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            SesV2Exception {
        return updateCustomVerificationEmailTemplate(UpdateCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(updateCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Updates the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateEmailIdentityPolicyRequest
     *        Represents a request to update a sending authorization policy for an identity. Sending authorization is an
     *        Amazon SES feature that enables you to authorize other senders to use your identities. For information,
     *        see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return Result of the UpdateEmailIdentityPolicy operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UpdateEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEmailIdentityPolicyResponse updateEmailIdentityPolicy(
            UpdateEmailIdentityPolicyRequest updateEmailIdentityPolicyRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEmailIdentityPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateEmailIdentityPolicyRequest#builder()}
     * </p>
     *
     * @param updateEmailIdentityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyRequest.Builder} to create a
     *        request. Represents a request to update a sending authorization policy for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a href=
     *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
     *        >Amazon SES Developer Guide</a>.
     * @return Result of the UpdateEmailIdentityPolicy operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UpdateEmailIdentityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailIdentityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEmailIdentityPolicyResponse updateEmailIdentityPolicy(
            Consumer<UpdateEmailIdentityPolicyRequest.Builder> updateEmailIdentityPolicyRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return updateEmailIdentityPolicy(UpdateEmailIdentityPolicyRequest.builder()
                .applyMutation(updateEmailIdentityPolicyRequest).build());
    }

    /**
     * <p>
     * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateEmailTemplateRequest
     *        Represents a request to update an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the UpdateEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UpdateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateEmailTemplateResponse updateEmailTemplate(UpdateEmailTemplateRequest updateEmailTemplateRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            SesV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEmailTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEmailTemplateRequest#builder()}
     * </p>
     *
     * @param updateEmailTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateRequest.Builder} to create a
     *        request. Represents a request to update an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return Result of the UpdateEmailTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource you attempted to access doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been made to the operation.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SesV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SesV2Client.UpdateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateEmailTemplateResponse updateEmailTemplate(
            Consumer<UpdateEmailTemplateRequest.Builder> updateEmailTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return updateEmailTemplate(UpdateEmailTemplateRequest.builder().applyMutation(updateEmailTemplateRequest).build());
    }

    /**
     * Create a {@link SesV2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SesV2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SesV2Client}.
     */
    static SesV2ClientBuilder builder() {
        return new DefaultSesV2ClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SesV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
