/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to change the account suppression list preferences for a specific configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConfigurationSetSuppressionOptionsRequest extends SesV2Request implements
        ToCopyableBuilder<PutConfigurationSetSuppressionOptionsRequest.Builder, PutConfigurationSetSuppressionOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName")
            .getter(getter(PutConfigurationSetSuppressionOptionsRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()).build();

    private static final SdkField<List<String>> SUPPRESSED_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SuppressedReasons")
            .getter(getter(PutConfigurationSetSuppressionOptionsRequest::suppressedReasonsAsStrings))
            .setter(setter(Builder::suppressedReasonsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressedReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            SUPPRESSED_REASONS_FIELD));

    private final String configurationSetName;

    private final List<String> suppressedReasons;

    private PutConfigurationSetSuppressionOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.suppressedReasons = builder.suppressedReasons;
    }

    /**
     * <p>
     * The name of the configuration set to change the suppression list preferences for.
     * </p>
     * 
     * @return The name of the configuration set to change the suppression list preferences for.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * A list that contains the reasons that email addresses are automatically added to the suppression list for your
     * account. This list can contain any or all of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message
     * sent to that address results in a complaint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message
     * sent to that address results in a hard bounce.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuppressedReasons} method.
     * </p>
     * 
     * @return A list that contains the reasons that email addresses are automatically added to the suppression list for
     *         your account. This list can contain any or all of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
     *         message sent to that address results in a complaint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
     *         message sent to that address results in a hard bounce.
     *         </p>
     *         </li>
     */
    public final List<SuppressionListReason> suppressedReasons() {
        return SuppressionListReasonsCopier.copyStringToEnum(suppressedReasons);
    }

    /**
     * For responses, this returns true if the service returned a value for the SuppressedReasons property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuppressedReasons() {
        return suppressedReasons != null && !(suppressedReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains the reasons that email addresses are automatically added to the suppression list for your
     * account. This list can contain any or all of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message
     * sent to that address results in a complaint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message
     * sent to that address results in a hard bounce.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuppressedReasons} method.
     * </p>
     * 
     * @return A list that contains the reasons that email addresses are automatically added to the suppression list for
     *         your account. This list can contain any or all of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
     *         message sent to that address results in a complaint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
     *         message sent to that address results in a hard bounce.
     *         </p>
     *         </li>
     */
    public final List<String> suppressedReasonsAsStrings() {
        return suppressedReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSuppressedReasons() ? suppressedReasonsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationSetSuppressionOptionsRequest)) {
            return false;
        }
        PutConfigurationSetSuppressionOptionsRequest other = (PutConfigurationSetSuppressionOptionsRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && hasSuppressedReasons() == other.hasSuppressedReasons()
                && Objects.equals(suppressedReasonsAsStrings(), other.suppressedReasonsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutConfigurationSetSuppressionOptionsRequest")
                .add("ConfigurationSetName", configurationSetName())
                .add("SuppressedReasons", hasSuppressedReasons() ? suppressedReasonsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "SuppressedReasons":
            return Optional.ofNullable(clazz.cast(suppressedReasonsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationSetSuppressionOptionsRequest, T> g) {
        return obj -> g.apply((PutConfigurationSetSuppressionOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutConfigurationSetSuppressionOptionsRequest> {
        /**
         * <p>
         * The name of the configuration set to change the suppression list preferences for.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set to change the suppression list preferences for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * A list that contains the reasons that email addresses are automatically added to the suppression list for
         * your account. This list can contain any or all of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a complaint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a hard bounce.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressedReasons
         *        A list that contains the reasons that email addresses are automatically added to the suppression list
         *        for your account. This list can contain any or all of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account
         *        when a message sent to that address results in a complaint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         *        message sent to that address results in a hard bounce.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedReasonsWithStrings(Collection<String> suppressedReasons);

        /**
         * <p>
         * A list that contains the reasons that email addresses are automatically added to the suppression list for
         * your account. This list can contain any or all of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a complaint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a hard bounce.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressedReasons
         *        A list that contains the reasons that email addresses are automatically added to the suppression list
         *        for your account. This list can contain any or all of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account
         *        when a message sent to that address results in a complaint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         *        message sent to that address results in a hard bounce.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedReasonsWithStrings(String... suppressedReasons);

        /**
         * <p>
         * A list that contains the reasons that email addresses are automatically added to the suppression list for
         * your account. This list can contain any or all of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a complaint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a hard bounce.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressedReasons
         *        A list that contains the reasons that email addresses are automatically added to the suppression list
         *        for your account. This list can contain any or all of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account
         *        when a message sent to that address results in a complaint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         *        message sent to that address results in a hard bounce.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedReasons(Collection<SuppressionListReason> suppressedReasons);

        /**
         * <p>
         * A list that contains the reasons that email addresses are automatically added to the suppression list for
         * your account. This list can contain any or all of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a complaint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a hard bounce.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressedReasons
         *        A list that contains the reasons that email addresses are automatically added to the suppression list
         *        for your account. This list can contain any or all of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account
         *        when a message sent to that address results in a complaint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         *        message sent to that address results in a hard bounce.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedReasons(SuppressionListReason... suppressedReasons);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String configurationSetName;

        private List<String> suppressedReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationSetSuppressionOptionsRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            suppressedReasonsWithStrings(model.suppressedReasons);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final Collection<String> getSuppressedReasons() {
            if (suppressedReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return suppressedReasons;
        }

        public final void setSuppressedReasons(Collection<String> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copy(suppressedReasons);
        }

        @Override
        public final Builder suppressedReasonsWithStrings(Collection<String> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copy(suppressedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedReasonsWithStrings(String... suppressedReasons) {
            suppressedReasonsWithStrings(Arrays.asList(suppressedReasons));
            return this;
        }

        @Override
        public final Builder suppressedReasons(Collection<SuppressionListReason> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copyEnumToString(suppressedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedReasons(SuppressionListReason... suppressedReasons) {
            suppressedReasons(Arrays.asList(suppressedReasons));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationSetSuppressionOptionsRequest build() {
            return new PutConfigurationSetSuppressionOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
