/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to list all of the import jobs for a data destination within the specified maximum number of
 * import jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImportJobsRequest extends SesV2Request implements
        ToCopyableBuilder<ListImportJobsRequest.Builder, ListImportJobsRequest> {
    private static final SdkField<String> IMPORT_DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportDestinationType").getter(getter(ListImportJobsRequest::importDestinationTypeAsString))
            .setter(setter(Builder::importDestinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDestinationType").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListImportJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListImportJobsRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_DESTINATION_TYPE_FIELD,
            NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD));

    private final String importDestinationType;

    private final String nextToken;

    private final Integer pageSize;

    private ListImportJobsRequest(BuilderImpl builder) {
        super(builder);
        this.importDestinationType = builder.importDestinationType;
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
    }

    /**
     * <p>
     * The destination of the import job, which can be used to list import jobs that have a certain
     * <code>ImportDestinationType</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #importDestinationType} will return {@link ImportDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #importDestinationTypeAsString}.
     * </p>
     * 
     * @return The destination of the import job, which can be used to list import jobs that have a certain
     *         <code>ImportDestinationType</code>.
     * @see ImportDestinationType
     */
    public final ImportDestinationType importDestinationType() {
        return ImportDestinationType.fromValue(importDestinationType);
    }

    /**
     * <p>
     * The destination of the import job, which can be used to list import jobs that have a certain
     * <code>ImportDestinationType</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #importDestinationType} will return {@link ImportDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #importDestinationTypeAsString}.
     * </p>
     * 
     * @return The destination of the import job, which can be used to list import jobs that have a certain
     *         <code>ImportDestinationType</code>.
     * @see ImportDestinationType
     */
    public final String importDestinationTypeAsString() {
        return importDestinationType;
    }

    /**
     * <p>
     * A string token indicating that there might be additional import jobs available to be listed. Copy this token to a
     * subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next page of import jobs.
     * </p>
     * 
     * @return A string token indicating that there might be additional import jobs available to be listed. Copy this
     *         token to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next
     *         page of import jobs.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional import
     * jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the
     * <code>NextToken</code> value in subsequent requests to retrieve additional addresses.
     * </p>
     * 
     * @return Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional
     *         import jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response.
     *         Use the <code>NextToken</code> value in subsequent requests to retrieve additional addresses.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportJobsRequest)) {
            return false;
        }
        ListImportJobsRequest other = (ListImportJobsRequest) obj;
        return Objects.equals(importDestinationTypeAsString(), other.importDestinationTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(pageSize(), other.pageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImportJobsRequest").add("ImportDestinationType", importDestinationTypeAsString())
                .add("NextToken", nextToken()).add("PageSize", pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportDestinationType":
            return Optional.ofNullable(clazz.cast(importDestinationTypeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImportJobsRequest, T> g) {
        return obj -> g.apply((ListImportJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListImportJobsRequest> {
        /**
         * <p>
         * The destination of the import job, which can be used to list import jobs that have a certain
         * <code>ImportDestinationType</code>.
         * </p>
         * 
         * @param importDestinationType
         *        The destination of the import job, which can be used to list import jobs that have a certain
         *        <code>ImportDestinationType</code>.
         * @see ImportDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportDestinationType
         */
        Builder importDestinationType(String importDestinationType);

        /**
         * <p>
         * The destination of the import job, which can be used to list import jobs that have a certain
         * <code>ImportDestinationType</code>.
         * </p>
         * 
         * @param importDestinationType
         *        The destination of the import job, which can be used to list import jobs that have a certain
         *        <code>ImportDestinationType</code>.
         * @see ImportDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportDestinationType
         */
        Builder importDestinationType(ImportDestinationType importDestinationType);

        /**
         * <p>
         * A string token indicating that there might be additional import jobs available to be listed. Copy this token
         * to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next page of
         * import jobs.
         * </p>
         * 
         * @param nextToken
         *        A string token indicating that there might be additional import jobs available to be listed. Copy this
         *        token to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the
         *        next page of import jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional import
         * jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the
         * <code>NextToken</code> value in subsequent requests to retrieve additional addresses.
         * </p>
         * 
         * @param pageSize
         *        Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional
         *        import jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the
         *        response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional
         *        addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String importDestinationType;

        private String nextToken;

        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportJobsRequest model) {
            super(model);
            importDestinationType(model.importDestinationType);
            nextToken(model.nextToken);
            pageSize(model.pageSize);
        }

        public final String getImportDestinationType() {
            return importDestinationType;
        }

        public final void setImportDestinationType(String importDestinationType) {
            this.importDestinationType = importDestinationType;
        }

        @Override
        public final Builder importDestinationType(String importDestinationType) {
            this.importDestinationType = importDestinationType;
            return this;
        }

        @Override
        public final Builder importDestinationType(ImportDestinationType importDestinationType) {
            this.importDestinationType(importDestinationType == null ? null : importDestinationType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListImportJobsRequest build() {
            return new ListImportJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
