/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class MetricDataErrorListCopier {
    static List<MetricDataError> copy(Collection<? extends MetricDataError> metricDataErrorListParam) {
        List<MetricDataError> list;
        if (metricDataErrorListParam == null || metricDataErrorListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MetricDataError> modifiableList = new ArrayList<>();
            metricDataErrorListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MetricDataError> copyFromBuilder(Collection<? extends MetricDataError.Builder> metricDataErrorListParam) {
        List<MetricDataError> list;
        if (metricDataErrorListParam == null || metricDataErrorListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MetricDataError> modifiableList = new ArrayList<>();
            metricDataErrorListParam.forEach(entry -> {
                MetricDataError member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MetricDataError.Builder> copyToBuilder(Collection<? extends MetricDataError> metricDataErrorListParam) {
        List<MetricDataError.Builder> list;
        if (metricDataErrorListParam == null || metricDataErrorListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MetricDataError.Builder> modifiableList = new ArrayList<>();
            metricDataErrorListParam.forEach(entry -> {
                MetricDataError.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
