/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The metric to export, can be one of the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>SEND</code> - Emails sent eligible for tracking in the VDM dashboard. This excludes emails sent to the mailbox
 * simulator and emails addressed to more than one recipient.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>COMPLAINT</code> - Complaints received for your account. This excludes complaints from the mailbox simulator,
 * those originating from your account-level suppression list (if enabled), and those for emails addressed to more than
 * one recipient
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>PERMANENT_BOUNCE</code> - Permanent bounces - i.e., feedback received for emails sent to non-existent
 * mailboxes. Excludes bounces from the mailbox simulator, those originating from your account-level suppression list
 * (if enabled), and those for emails addressed to more than one recipient.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>TRANSIENT_BOUNCE</code> - Transient bounces - i.e., feedback received for delivery failures excluding issues
 * with non-existent mailboxes. Excludes bounces from the mailbox simulator, and those for emails addressed to more than
 * one recipient.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>OPEN</code> - Unique open events for emails including open trackers. Excludes opens for emails addressed to
 * more than one recipient.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CLICK</code> - Unique click events for emails including wrapped links. Excludes clicks for emails addressed to
 * more than one recipient.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DELIVERY</code> - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox
 * simulator and for emails addressed to more than one recipient.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DELIVERY_OPEN</code> - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox
 * simulator, for emails addressed to more than one recipient, and emails without open trackers.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DELIVERY_CLICK</code> - Successful deliveries for email sending attempts. Excludes deliveries to the mailbox
 * simulator, for emails addressed to more than one recipient, and emails without click trackers.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DELIVERY_COMPLAINT</code> - Successful deliveries for email sending attempts. Excludes deliveries to the
 * mailbox simulator, for emails addressed to more than one recipient, and emails addressed to recipients hosted by ISPs
 * with which Amazon SES does not have a feedback loop agreement.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum Metric {
    SEND("SEND"),

    COMPLAINT("COMPLAINT"),

    PERMANENT_BOUNCE("PERMANENT_BOUNCE"),

    TRANSIENT_BOUNCE("TRANSIENT_BOUNCE"),

    OPEN("OPEN"),

    CLICK("CLICK"),

    DELIVERY("DELIVERY"),

    DELIVERY_OPEN("DELIVERY_OPEN"),

    DELIVERY_CLICK("DELIVERY_CLICK"),

    DELIVERY_COMPLAINT("DELIVERY_COMPLAINT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Metric> VALUE_MAP = EnumUtils.uniqueIndex(Metric.class, Metric::toString);

    private final String value;

    private Metric(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Metric corresponding to the value
     */
    public static Metric fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Metric}s
     */
    public static Set<Metric> knownValues() {
        Set<Metric> knownValues = EnumSet.allOf(Metric.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
