/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of configuration sets in your Amazon SES account in the current Amazon Web Services Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationSetsResponse extends SesV2Response implements
        ToCopyableBuilder<ListConfigurationSetsResponse.Builder, ListConfigurationSetsResponse> {
    private static final SdkField<List<String>> CONFIGURATION_SETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConfigurationSets")
            .getter(getter(ListConfigurationSetsResponse::configurationSets))
            .setter(setter(Builder::configurationSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConfigurationSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SETS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> configurationSets;

    private final String nextToken;

    private ListConfigurationSetsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSets = builder.configurationSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationSets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigurationSets() {
        return configurationSets != null && !(configurationSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains all of the configuration sets in your Amazon SES account in the current Amazon Web
     * Services Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationSets} method.
     * </p>
     * 
     * @return An array that contains all of the configuration sets in your Amazon SES account in the current Amazon Web
     *         Services Region.
     */
    public final List<String> configurationSets() {
        return configurationSets;
    }

    /**
     * <p>
     * A token that indicates that there are additional configuration sets to list. To view additional configuration
     * sets, issue another request to <code>ListConfigurationSets</code>, and pass this token in the
     * <code>NextToken</code> parameter.
     * </p>
     * 
     * @return A token that indicates that there are additional configuration sets to list. To view additional
     *         configuration sets, issue another request to <code>ListConfigurationSets</code>, and pass this token in
     *         the <code>NextToken</code> parameter.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationSets() ? configurationSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationSetsResponse)) {
            return false;
        }
        ListConfigurationSetsResponse other = (ListConfigurationSetsResponse) obj;
        return hasConfigurationSets() == other.hasConfigurationSets()
                && Objects.equals(configurationSets(), other.configurationSets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConfigurationSetsResponse")
                .add("ConfigurationSets", hasConfigurationSets() ? configurationSets() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSets":
            return Optional.ofNullable(clazz.cast(configurationSets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationSetsResponse, T> g) {
        return obj -> g.apply((ListConfigurationSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListConfigurationSetsResponse> {
        /**
         * <p>
         * An array that contains all of the configuration sets in your Amazon SES account in the current Amazon Web
         * Services Region.
         * </p>
         * 
         * @param configurationSets
         *        An array that contains all of the configuration sets in your Amazon SES account in the current Amazon
         *        Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSets(Collection<String> configurationSets);

        /**
         * <p>
         * An array that contains all of the configuration sets in your Amazon SES account in the current Amazon Web
         * Services Region.
         * </p>
         * 
         * @param configurationSets
         *        An array that contains all of the configuration sets in your Amazon SES account in the current Amazon
         *        Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSets(String... configurationSets);

        /**
         * <p>
         * A token that indicates that there are additional configuration sets to list. To view additional configuration
         * sets, issue another request to <code>ListConfigurationSets</code>, and pass this token in the
         * <code>NextToken</code> parameter.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there are additional configuration sets to list. To view additional
         *        configuration sets, issue another request to <code>ListConfigurationSets</code>, and pass this token
         *        in the <code>NextToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private List<String> configurationSets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationSetsResponse model) {
            super(model);
            configurationSets(model.configurationSets);
            nextToken(model.nextToken);
        }

        public final Collection<String> getConfigurationSets() {
            if (configurationSets instanceof SdkAutoConstructList) {
                return null;
            }
            return configurationSets;
        }

        public final void setConfigurationSets(Collection<String> configurationSets) {
            this.configurationSets = ConfigurationSetNameListCopier.copy(configurationSets);
        }

        @Override
        public final Builder configurationSets(Collection<String> configurationSets) {
            this.configurationSets = ConfigurationSetNameListCopier.copy(configurationSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSets(String... configurationSets) {
            configurationSets(Arrays.asList(configurationSets));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationSetsResponse build() {
            return new ListConfigurationSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
