/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the suppressed email address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSuppressedDestinationResponse extends SesV2Response implements
        ToCopyableBuilder<GetSuppressedDestinationResponse.Builder, GetSuppressedDestinationResponse> {
    private static final SdkField<SuppressedDestination> SUPPRESSED_DESTINATION_FIELD = SdkField
            .<SuppressedDestination> builder(MarshallingType.SDK_POJO).memberName("SuppressedDestination")
            .getter(getter(GetSuppressedDestinationResponse::suppressedDestination))
            .setter(setter(Builder::suppressedDestination)).constructor(SuppressedDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressedDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPRESSED_DESTINATION_FIELD));

    private final SuppressedDestination suppressedDestination;

    private GetSuppressedDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.suppressedDestination = builder.suppressedDestination;
    }

    /**
     * <p>
     * An object containing information about the suppressed email address.
     * </p>
     * 
     * @return An object containing information about the suppressed email address.
     */
    public final SuppressedDestination suppressedDestination() {
        return suppressedDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suppressedDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSuppressedDestinationResponse)) {
            return false;
        }
        GetSuppressedDestinationResponse other = (GetSuppressedDestinationResponse) obj;
        return Objects.equals(suppressedDestination(), other.suppressedDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSuppressedDestinationResponse").add("SuppressedDestination", suppressedDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuppressedDestination":
            return Optional.ofNullable(clazz.cast(suppressedDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSuppressedDestinationResponse, T> g) {
        return obj -> g.apply((GetSuppressedDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetSuppressedDestinationResponse> {
        /**
         * <p>
         * An object containing information about the suppressed email address.
         * </p>
         * 
         * @param suppressedDestination
         *        An object containing information about the suppressed email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedDestination(SuppressedDestination suppressedDestination);

        /**
         * <p>
         * An object containing information about the suppressed email address.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuppressedDestination.Builder} avoiding
         * the need to create one manually via {@link SuppressedDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuppressedDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #suppressedDestination(SuppressedDestination)}.
         * 
         * @param suppressedDestination
         *        a consumer that will call methods on {@link SuppressedDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suppressedDestination(SuppressedDestination)
         */
        default Builder suppressedDestination(Consumer<SuppressedDestination.Builder> suppressedDestination) {
            return suppressedDestination(SuppressedDestination.builder().applyMutation(suppressedDestination).build());
        }
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private SuppressedDestination suppressedDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSuppressedDestinationResponse model) {
            super(model);
            suppressedDestination(model.suppressedDestination);
        }

        public final SuppressedDestination.Builder getSuppressedDestination() {
            return suppressedDestination != null ? suppressedDestination.toBuilder() : null;
        }

        public final void setSuppressedDestination(SuppressedDestination.BuilderImpl suppressedDestination) {
            this.suppressedDestination = suppressedDestination != null ? suppressedDestination.build() : null;
        }

        @Override
        public final Builder suppressedDestination(SuppressedDestination suppressedDestination) {
            this.suppressedDestination = suppressedDestination;
            return this;
        }

        @Override
        public GetSuppressedDestinationResponse build() {
            return new GetSuppressedDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
