/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAwsDefaultServiceQuotasResponse extends ServiceQuotasResponse implements
        ToCopyableBuilder<ListAwsDefaultServiceQuotasResponse.Builder, ListAwsDefaultServiceQuotasResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAwsDefaultServiceQuotasResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ServiceQuota>> QUOTAS_FIELD = SdkField
            .<List<ServiceQuota>> builder(MarshallingType.LIST)
            .memberName("Quotas")
            .getter(getter(ListAwsDefaultServiceQuotasResponse::quotas))
            .setter(setter(Builder::quotas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quotas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceQuota> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceQuota::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXT_TOKEN_FIELD, QUOTAS_FIELD));

    private final String nextToken;

    private final List<ServiceQuota> quotas;

    private ListAwsDefaultServiceQuotasResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.quotas = builder.quotas;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Quotas property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQuotas() {
        return quotas != null && !(quotas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the quotas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQuotas} method.
     * </p>
     * 
     * @return Information about the quotas.
     */
    public final List<ServiceQuota> quotas() {
        return quotas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasQuotas() ? quotas() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAwsDefaultServiceQuotasResponse)) {
            return false;
        }
        ListAwsDefaultServiceQuotasResponse other = (ListAwsDefaultServiceQuotasResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasQuotas() == other.hasQuotas()
                && Objects.equals(quotas(), other.quotas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAwsDefaultServiceQuotasResponse").add("NextToken", nextToken())
                .add("Quotas", hasQuotas() ? quotas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Quotas":
            return Optional.ofNullable(clazz.cast(quotas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAwsDefaultServiceQuotasResponse, T> g) {
        return obj -> g.apply((ListAwsDefaultServiceQuotasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAwsDefaultServiceQuotasResponse> {
        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the quotas.
         * </p>
         * 
         * @param quotas
         *        Information about the quotas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotas(Collection<ServiceQuota> quotas);

        /**
         * <p>
         * Information about the quotas.
         * </p>
         * 
         * @param quotas
         *        Information about the quotas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotas(ServiceQuota... quotas);

        /**
         * <p>
         * Information about the quotas.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicequotas.model.ServiceQuota.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.servicequotas.model.ServiceQuota#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicequotas.model.ServiceQuota.Builder#build()} is called
         * immediately and its result is passed to {@link #quotas(List<ServiceQuota>)}.
         * 
         * @param quotas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicequotas.model.ServiceQuota.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quotas(java.util.Collection<ServiceQuota>)
         */
        Builder quotas(Consumer<ServiceQuota.Builder>... quotas);
    }

    static final class BuilderImpl extends ServiceQuotasResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ServiceQuota> quotas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAwsDefaultServiceQuotasResponse model) {
            super(model);
            nextToken(model.nextToken);
            quotas(model.quotas);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServiceQuota.Builder> getQuotas() {
            List<ServiceQuota.Builder> result = ServiceQuotaListDefinitionCopier.copyToBuilder(this.quotas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuotas(Collection<ServiceQuota.BuilderImpl> quotas) {
            this.quotas = ServiceQuotaListDefinitionCopier.copyFromBuilder(quotas);
        }

        @Override
        public final Builder quotas(Collection<ServiceQuota> quotas) {
            this.quotas = ServiceQuotaListDefinitionCopier.copy(quotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quotas(ServiceQuota... quotas) {
            quotas(Arrays.asList(quotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quotas(Consumer<ServiceQuota.Builder>... quotas) {
            quotas(Stream.of(quotas).map(c -> ServiceQuota.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAwsDefaultServiceQuotasResponse build() {
            return new ListAwsDefaultServiceQuotasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
