/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicediscovery.model.AttributesCopier;
import software.amazon.awssdk.services.servicediscovery.model.HealthStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpInstanceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpInstanceSummary> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(HttpInstanceSummary.getter(HttpInstanceSummary::instanceId)).setter(HttpInstanceSummary.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamespaceName").getter(HttpInstanceSummary.getter(HttpInstanceSummary::namespaceName)).setter(HttpInstanceSummary.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(HttpInstanceSummary.getter(HttpInstanceSummary::serviceName)).setter(HttpInstanceSummary.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthStatus").getter(HttpInstanceSummary.getter(HttpInstanceSummary::healthStatusAsString)).setter(HttpInstanceSummary.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(HttpInstanceSummary.getter(HttpInstanceSummary::attributes)).setter(HttpInstanceSummary.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAMESPACE_NAME_FIELD, SERVICE_NAME_FIELD, HEALTH_STATUS_FIELD, ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String namespaceName;
    private final String serviceName;
    private final String healthStatus;
    private final Map<String, String> attributes;

    private HttpInstanceSummary(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.namespaceName = builder.namespaceName;
        this.serviceName = builder.serviceName;
        this.healthStatus = builder.healthStatus;
        this.attributes = builder.attributes;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final HealthStatus healthStatus() {
        return HealthStatus.fromValue(this.healthStatus);
    }

    public final String healthStatusAsString() {
        return this.healthStatus;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpInstanceSummary)) {
            return false;
        }
        HttpInstanceSummary other = (HttpInstanceSummary)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"HttpInstanceSummary").add("InstanceId", (Object)this.instanceId()).add("NamespaceName", (Object)this.namespaceName()).add("ServiceName", (Object)this.serviceName()).add("HealthStatus", (Object)this.healthStatusAsString()).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "NamespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "HealthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpInstanceSummary, T> g) {
        return obj -> g.apply((HttpInstanceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String namespaceName;
        private String serviceName;
        private String healthStatus;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HttpInstanceSummary model) {
            this.instanceId(model.instanceId);
            this.namespaceName(model.namespaceName);
            this.serviceName(model.serviceName);
            this.healthStatus(model.healthStatus);
            this.attributes(model.attributes);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(HealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public HttpInstanceSummary build() {
            return new HttpInstanceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpInstanceSummary> {
        public Builder instanceId(String var1);

        public Builder namespaceName(String var1);

        public Builder serviceName(String var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(HealthStatus var1);

        public Builder attributes(Map<String, String> var1);
    }
}

