/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperationFilterName {
    NAMESPACE_ID("NAMESPACE_ID"),
    SERVICE_ID("SERVICE_ID"),
    STATUS("STATUS"),
    TYPE("TYPE"),
    UPDATE_DATE("UPDATE_DATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperationFilterName> VALUE_MAP;
    private final String value;

    private OperationFilterName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationFilterName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationFilterName> knownValues() {
        EnumSet<OperationFilterName> knownValues = EnumSet.allOf(OperationFilterName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperationFilterName.class, OperationFilterName::toString);
    }
}

