/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The maximum number of API requests has been exceeded.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThrottlingException extends ServiceCatalogAppRegistryException implements
        ToCopyableBuilder<ThrottlingException.Builder, ThrottlingException> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(ThrottlingException::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceCode;

    private ThrottlingException(BuilderImpl builder) {
        super(builder);
        this.serviceCode = builder.serviceCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The originating service code.
     * </p>
     * 
     * @return The originating service code.
     */
    public String serviceCode() {
        return serviceCode;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThrottlingException, T> g) {
        return obj -> g.apply((ThrottlingException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThrottlingException>,
            ServiceCatalogAppRegistryException.Builder {
        /**
         * <p>
         * The originating service code.
         * </p>
         * 
         * @param serviceCode
         *        The originating service code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryException.BuilderImpl implements Builder {
        private String serviceCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ThrottlingException model) {
            super(model);
            serviceCode(model.serviceCode);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ThrottlingException build() {
            return new ThrottlingException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
