/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationResponse extends ServiceCatalogAppRegistryResponse implements
        ToCopyableBuilder<GetApplicationResponse.Builder, GetApplicationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetApplicationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetApplicationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetApplicationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetApplicationResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetApplicationResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime")
            .getter(getter(GetApplicationResponse::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> ASSOCIATED_RESOURCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("associatedResourceCount").getter(getter(GetApplicationResponse::associatedResourceCount))
            .setter(setter(Builder::associatedResourceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedResourceCount").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetApplicationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integrations> INTEGRATIONS_FIELD = SdkField.<Integrations> builder(MarshallingType.SDK_POJO)
            .memberName("integrations").getter(getter(GetApplicationResponse::integrations))
            .setter(setter(Builder::integrations)).constructor(Integrations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, ASSOCIATED_RESOURCE_COUNT_FIELD,
            TAGS_FIELD, INTEGRATIONS_FIELD));

    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final Integer associatedResourceCount;

    private final Map<String, String> tags;

    private final Integrations integrations;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.associatedResourceCount = builder.associatedResourceCount;
        this.tags = builder.tags;
        this.integrations = builder.integrations;
    }

    /**
     * <p>
     * The identifier of the application.
     * </p>
     * 
     * @return The identifier of the application.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) that specifies the application across services.
     * </p>
     * 
     * @return The Amazon resource name (ARN) that specifies the application across services.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the application. The name must be unique in the region in which you are creating the application.
     * </p>
     * 
     * @return The name of the application. The name must be unique in the region in which you are creating the
     *         application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * 
     * @return The description of the application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ISO-8601 formatted timestamp of the moment when the application was created.
     * </p>
     * 
     * @return The ISO-8601 formatted timestamp of the moment when the application was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The ISO-8601 formatted timestamp of the moment when the application was last updated.
     * </p>
     * 
     * @return The ISO-8601 formatted timestamp of the moment when the application was last updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The number of top-level resources that were registered as part of this application.
     * </p>
     * 
     * @return The number of top-level resources that were registered as part of this application.
     */
    public final Integer associatedResourceCount() {
        return associatedResourceCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key-value pairs associated with the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs associated with the application.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The information about the integration of the application with other services, such as Resource Groups.
     * </p>
     * 
     * @return The information about the integration of the application with other services, such as Resource Groups.
     */
    public final Integrations integrations() {
        return integrations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResourceCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(integrations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(associatedResourceCount(), other.associatedResourceCount()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(integrations(), other.integrations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationResponse").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime())
                .add("AssociatedResourceCount", associatedResourceCount()).add("Tags", hasTags() ? tags() : null)
                .add("Integrations", integrations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "associatedResourceCount":
            return Optional.ofNullable(clazz.cast(associatedResourceCount()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "integrations":
            return Optional.ofNullable(clazz.cast(integrations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogAppRegistryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationResponse> {
        /**
         * <p>
         * The identifier of the application.
         * </p>
         * 
         * @param id
         *        The identifier of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon resource name (ARN) that specifies the application across services.
         * </p>
         * 
         * @param arn
         *        The Amazon resource name (ARN) that specifies the application across services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the application. The name must be unique in the region in which you are creating the application.
         * </p>
         * 
         * @param name
         *        The name of the application. The name must be unique in the region in which you are creating the
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the application.
         * </p>
         * 
         * @param description
         *        The description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ISO-8601 formatted timestamp of the moment when the application was created.
         * </p>
         * 
         * @param creationTime
         *        The ISO-8601 formatted timestamp of the moment when the application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The ISO-8601 formatted timestamp of the moment when the application was last updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The ISO-8601 formatted timestamp of the moment when the application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The number of top-level resources that were registered as part of this application.
         * </p>
         * 
         * @param associatedResourceCount
         *        The number of top-level resources that were registered as part of this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceCount(Integer associatedResourceCount);

        /**
         * <p>
         * Key-value pairs associated with the application.
         * </p>
         * 
         * @param tags
         *        Key-value pairs associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The information about the integration of the application with other services, such as Resource Groups.
         * </p>
         * 
         * @param integrations
         *        The information about the integration of the application with other services, such as Resource Groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrations(Integrations integrations);

        /**
         * <p>
         * The information about the integration of the application with other services, such as Resource Groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link Integrations.Builder} avoiding the need
         * to create one manually via {@link Integrations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Integrations.Builder#build()} is called immediately and its
         * result is passed to {@link #integrations(Integrations)}.
         * 
         * @param integrations
         *        a consumer that will call methods on {@link Integrations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrations(Integrations)
         */
        default Builder integrations(Consumer<Integrations.Builder> integrations) {
            return integrations(Integrations.builder().applyMutation(integrations).build());
        }
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private Integer associatedResourceCount;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integrations integrations;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            associatedResourceCount(model.associatedResourceCount);
            tags(model.tags);
            integrations(model.integrations);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final Integer getAssociatedResourceCount() {
            return associatedResourceCount;
        }

        public final void setAssociatedResourceCount(Integer associatedResourceCount) {
            this.associatedResourceCount = associatedResourceCount;
        }

        @Override
        public final Builder associatedResourceCount(Integer associatedResourceCount) {
            this.associatedResourceCount = associatedResourceCount;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Integrations.Builder getIntegrations() {
            return integrations != null ? integrations.toBuilder() : null;
        }

        public final void setIntegrations(Integrations.BuilderImpl integrations) {
            this.integrations = integrations != null ? integrations.build() : null;
        }

        @Override
        public final Builder integrations(Integrations integrations) {
            this.integrations = integrations;
            return this;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
