/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of a Amazon Web Services Service Catalog AppRegistry attribute group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeGroupSummary.Builder, AttributeGroupSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AttributeGroupSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AttributeGroupSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AttributeGroupSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AttributeGroupSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(AttributeGroupSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime")
            .getter(getter(AttributeGroupSummary::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(AttributeGroupSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, CREATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final String createdBy;

    private AttributeGroupSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.createdBy = builder.createdBy;
    }

    /**
     * <p>
     * The globally unique attribute group identifier of the attribute group.
     * </p>
     * 
     * @return The globally unique attribute group identifier of the attribute group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) that specifies the attribute group across services.
     * </p>
     * 
     * @return The Amazon resource name (ARN) that specifies the attribute group across services.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the attribute group.
     * </p>
     * 
     * @return The name of the attribute group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the attribute group that the user provides.
     * </p>
     * 
     * @return The description of the attribute group that the user provides.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ISO-8601 formatted timestamp of the moment the attribute group was created.
     * </p>
     * 
     * @return The ISO-8601 formatted timestamp of the moment the attribute group was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the
     * creationTime for a newly created attribute group.
     * </p>
     * 
     * @return The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the
     *         same as the creationTime for a newly created attribute group.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The service principal that created the attribute group.
     * </p>
     * 
     * @return The service principal that created the attribute group.
     */
    public final String createdBy() {
        return createdBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeGroupSummary)) {
            return false;
        }
        AttributeGroupSummary other = (AttributeGroupSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(createdBy(), other.createdBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeGroupSummary").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime())
                .add("CreatedBy", createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeGroupSummary, T> g) {
        return obj -> g.apply((AttributeGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeGroupSummary> {
        /**
         * <p>
         * The globally unique attribute group identifier of the attribute group.
         * </p>
         * 
         * @param id
         *        The globally unique attribute group identifier of the attribute group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon resource name (ARN) that specifies the attribute group across services.
         * </p>
         * 
         * @param arn
         *        The Amazon resource name (ARN) that specifies the attribute group across services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the attribute group.
         * </p>
         * 
         * @param name
         *        The name of the attribute group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the attribute group that the user provides.
         * </p>
         * 
         * @param description
         *        The description of the attribute group that the user provides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ISO-8601 formatted timestamp of the moment the attribute group was created.
         * </p>
         * 
         * @param creationTime
         *        The ISO-8601 formatted timestamp of the moment the attribute group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as
         * the creationTime for a newly created attribute group.
         * </p>
         * 
         * @param lastUpdateTime
         *        The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the
         *        same as the creationTime for a newly created attribute group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The service principal that created the attribute group.
         * </p>
         * 
         * @param createdBy
         *        The service principal that created the attribute group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeGroupSummary model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            createdBy(model.createdBy);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @Override
        public AttributeGroupSummary build() {
            return new AttributeGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
