/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSubscribersResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<ListSubscribersResponse.Builder, ListSubscribersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSubscribersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<SubscriberResource>> SUBSCRIBERS_FIELD = SdkField
            .<List<SubscriberResource>> builder(MarshallingType.LIST)
            .memberName("subscribers")
            .getter(getter(ListSubscribersResponse::subscribers))
            .setter(setter(Builder::subscribers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubscriberResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubscriberResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SUBSCRIBERS_FIELD));

    private final String nextToken;

    private final List<SubscriberResource> subscribers;

    private ListSubscribersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.subscribers = builder.subscribers;
    }

    /**
     * <p>
     * If nextToken is returned, there are more results available. You can repeat the call using the returned token to
     * retrieve the next page.
     * </p>
     * 
     * @return If nextToken is returned, there are more results available. You can repeat the call using the returned
     *         token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subscribers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscribers() {
        return subscribers != null && !(subscribers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subscribers available for the specified Security Lake account ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscribers} method.
     * </p>
     * 
     * @return The subscribers available for the specified Security Lake account ID.
     */
    public final List<SubscriberResource> subscribers() {
        return subscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribers() ? subscribers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscribersResponse)) {
            return false;
        }
        ListSubscribersResponse other = (ListSubscribersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSubscribers() == other.hasSubscribers()
                && Objects.equals(subscribers(), other.subscribers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSubscribersResponse").add("NextToken", nextToken())
                .add("Subscribers", hasSubscribers() ? subscribers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "subscribers":
            return Optional.ofNullable(clazz.cast(subscribers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSubscribersResponse, T> g) {
        return obj -> g.apply((ListSubscribersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSubscribersResponse> {
        /**
         * <p>
         * If nextToken is returned, there are more results available. You can repeat the call using the returned token
         * to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        If nextToken is returned, there are more results available. You can repeat the call using the returned
         *        token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The subscribers available for the specified Security Lake account ID.
         * </p>
         * 
         * @param subscribers
         *        The subscribers available for the specified Security Lake account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<SubscriberResource> subscribers);

        /**
         * <p>
         * The subscribers available for the specified Security Lake account ID.
         * </p>
         * 
         * @param subscribers
         *        The subscribers available for the specified Security Lake account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(SubscriberResource... subscribers);

        /**
         * <p>
         * The subscribers available for the specified Security Lake account ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.SubscriberResource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securitylake.model.SubscriberResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.SubscriberResource.Builder#build()} is called
         * immediately and its result is passed to {@link #subscribers(List<SubscriberResource>)}.
         * 
         * @param subscribers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.SubscriberResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribers(java.util.Collection<SubscriberResource>)
         */
        Builder subscribers(Consumer<SubscriberResource.Builder>... subscribers);
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SubscriberResource> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscribersResponse model) {
            super(model);
            nextToken(model.nextToken);
            subscribers(model.subscribers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SubscriberResource.Builder> getSubscribers() {
            List<SubscriberResource.Builder> result = SubscriberResourceListCopier.copyToBuilder(this.subscribers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribers(Collection<SubscriberResource.BuilderImpl> subscribers) {
            this.subscribers = SubscriberResourceListCopier.copyFromBuilder(subscribers);
        }

        @Override
        public final Builder subscribers(Collection<SubscriberResource> subscribers) {
            this.subscribers = SubscriberResourceListCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(SubscriberResource... subscribers) {
            subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Consumer<SubscriberResource.Builder>... subscribers) {
            subscribers(Stream.of(subscribers).map(c -> SubscriberResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSubscribersResponse build() {
            return new ListSubscribersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
